/*
 * FunctionView.fx
 *
 * Created on 08.08.2009, 11:02:17
 */

package mathematics.function;

/**
 * @author raindrop
 */

import javafx.scene.*;
import javafx.scene.paint.*;
import javafx.scene.shape.*;

public class FunctionView extends CustomNode{

    public var xMin: Number;
    public var xMax: Number;
    public var dx: Number = 0.1;
    public var scale: Number = 1.0;
    public var color: Color = Color.BLUE;

    public var func: function(a: Number):Number;

    override function create():Node{
        Polyline{
            stroke: color
            strokeWidth: 2
            points: for(x in [xMin..xMax step dx]) [x * scale, func(x) * scale]
        }
    }
}
