
varying float fogFactor;
varying vec3 opos;
varying vec3 eye;
varying vec3 lightDir;
varying vec3 normal;
varying vec3 lightDirOrig;

uniform sampler2D tex;
uniform sampler2D normaltex;
uniform float bri;
uniform sampler2D screentex;
uniform float width, height;

const vec2 texscale = vec2(0.12);
const float lightSpec = 35.0;
const vec4 green = vec4(0.1, 0.4, 0.025, 1.0);
const vec3 specCol = green.xyz*10;

void main() {
	vec2 tc = gl_TexCoord[0].xy;
//	tc = 0.5+opos.xz*texscale;

	vec4 col = green*texture2D(tex, tc);
	vec3 n = normalize(-1.0+2.0*texture2D(normaltex, tc).xyz);

	vec3 l = normalize(lightDir);
	float diff = dot(n, l);

	float fspec = 0.0;
	if (diff > 0.0) {
		vec3 r = normalize(reflect(-l, n));
		fspec += float(vec4(specCol, 1.0) * pow(max(dot(r, normalize(eye)), 0.0), 4.0));
	}


	vec2 stc = vec2(gl_FragCoord.x/width, gl_FragCoord.y/height);
	stc.xy += 0.02*normalize(reflect(normalize(eye),n).xy);
	vec4 scol = texture2D(screentex, stc);


	gl_FragColor = bri*diff*col + green*scol;
	gl_FragColor.a = 0.75;
//	gl_FragColor.xyz = bri*(0.5+0.5*n);
}
