
varying float fogFactor;
varying vec3 opos;
varying vec3 eye;
varying vec3 lightDir;
varying vec3 normal;
varying vec3 lightDirOrig;

uniform sampler2D tex;
uniform sampler2D normaltex;
uniform float bri;

const float ambient = 0.4;
const vec2 texscale = vec2(0.1, 0.1);
const float lightSpec = 35.0;
const vec3 specCol = vec3(1.0, 0.95, 0.9);

void main() {
	vec2 tc = gl_TexCoord[0].xy;
	//tc = 0.5+opos.xz*texscale;
	tc = 0.5+tc*texscale;

	vec4 col = texture2D(tex, tc);
	vec3 n = -1.0+2.0*texture2D(normaltex, tc).xyz;
	n.z *= 24.0;
	n = normalize(n);

	vec3 l = normalize(lightDir);
	float diff = dot(n, l);
//	diff = max(diff, 0.0);

	float fspec = 0.0;
	if (diff > 0.01) {
		vec3 r = normalize(reflect(-l, n));
		fspec += float(vec4(specCol, 1.0) * pow(max(dot(r, normalize(eye)), 0.0), 4.0));
	}


	col = vec4(1.0);
	gl_FragColor = bri*(ambient*col + diff*col + fspec);
//	gl_FragColor.xyz = bri*(0.5+0.5*n);
}
