varying vec3 vcoord;
uniform float ptimer;

void main()
{
	float x = vcoord.x;
	float y = vcoord.y;
	float z = vcoord.z;

	float t = ptimer;

	float c = (sin((x + t) / 3.0) + sin((y + 2.0*t) / 3.0) + sin((z+1.5*t) / 1.0) + sin((x+y+0.25*t) / 2.0) + sin((y+z+0.5*t) / 2.0) + sin((x+z+2.5*t) / 4.0)) / 12.0 + 0.5;


	float i0 = 0.3;
	float i2 = 0.7;
	float i1 = (i0 + i2) / 2.0;

	if ((c < i0) || (c > i2)) c = 0.0;
	else if ((c >= i0) && (c < i1)) c = (c - i0) * 10.0;
	else if ((c >= i1) && (c <= i2)) c = (i2 - c) * 10.0;

	c = 1.0 - c;

	float lt = 2.0 * z / sqrt(x*x + y*y + z*z);

	float r = c * lt;
	float g = c * lt;
	float b = c * lt;
	float a = c * lt;

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
