uniform float ptimer;
uniform float cfademul;

uniform sampler2D tex;

varying vec3 coord;

void main()
{
	vec2 test = gl_TexCoord[0].st;
	vec2 tstr;
	vec2 tstg;
	vec2 tstb;

	float y = coord.y;

	float t = ptimer / 64.0;
	float tr = sin(t) + sin(2.0 * t);
	float tg = tr + sin(3.0 * t) + sin(4.0 * t);
	float tb = tg + sin(sin(5.0 * t) * t) + sin(sin(sin(6.0*t) * 2.0 * t));

	tstr.s = test.s + (tr * sin((y+t)*4.0)*0.065) / cfademul;
	tstg.s = test.s + (tg * sin((y+t)*2.0)*0.075) / cfademul;
	tstb.s = test.s + (tb * sin((y+t)*3.0)*0.035) / cfademul;
	tstr.t = test.t;
	tstg.t = test.t;
	tstb.t = test.t;

	vec4 newcolor;

	vec4 color_r = texture2D(tex,tstr);
	vec4 color_g = texture2D(tex,tstg);
	vec4 color_b = texture2D(tex,tstb);

	newcolor.r = color_r.r * cfademul;
	newcolor.g = color_g.g * cfademul;
	newcolor.b = color_b.b * cfademul;

	gl_FragColor = newcolor;
}
