uniform float posx;
uniform float posy;
uniform float rmul;
uniform float gmul;
uniform float bmul;

uniform float jmorph;

varying vec3 coord;

void main()
{
	float x0 = coord.x;
	float y0 = coord.y;

	float x1, y1, mj2;
	const float iter = 16.0;
	float iter2 = iter / jmorph;

	float n;
	for (n=0.0; n<=iter; n++)
	{
		x1 = x0*x0 - y0*y0 + posx;
		y1 = 2.0*x0*y0 + posy;
		mj2 = x1*x1 + y1*y1;
		x0 = x1; y0 = y1;
		if (mj2 > iter2) break;
	}

	float c = n / iter;
	float a;
	if (c<0.05) a = 0.0;
		else a = 0.75 + c/4.0;

	float r = rmul * c;
	float g = gmul * c;
	float b = bmul * c;

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
