float    g_fTime;                   // App's time in seconds
//float4x4 g_mWorld;                  // World matrix for object
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix
float4	g_bgColor;
texture g_MeshTexture;              // Color texture for mesh
float	g_canvasBrightness;

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    float2 TextureUV1  : TEXCOORD1;  // vertex texture coords 
};

sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;

/*
		float4x4 worldViewProjection = g_mWorldViewProjection;
		
		float2 sc;
		sincos(g_fTime, sc.x, sc.y);
		
		float4 rvPos = vPos;
		rvPos.x = vPos.x * sc.y + vPos.y * sc.x;
		rvPos.y = vPos.x * sc.x - vPos.y * sc.y;
		
		Output.Position = rvPos;
		Output.Position = mul(rvPos, worldViewProjection);
		*/
		// vPos.y *= -1;
		Output.Position = vPos;
		Output.Diffuse = vColor; // (255, 255, 255, 255);
		Output.TextureUV0 = vTexCoord0;
		Output.TextureUV1 = vTexCoord1;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------


PS_OUTPUT RenderScenePS( VS_OUTPUT In ) 
{ 
	float offset = 0.007;
	float offset2 = 0.001;
	float scale = 5.8f;
	float scale2 = 2.1f;
	
    float4 Color; 
    float4 OrigColor;
    OrigColor = tex2D (inputTex0, In.TextureUV0);
    Color = OrigColor;;
    
    offset2 += (Color.r+Color.g)*0.001;
    
    float2 displacementL = In.TextureUV1 + (offset2 * ((0.5 - Color.r)));
    float2 displacementR = In.TextureUV1 - (offset2 * ((0.5 - Color.g)));;

    Color += tex2D(inputTex1, In.TextureUV1+displacementL);	
    
    Color += tex2D( inputTex0 , In.TextureUV0+offset)*scale; 
    Color += tex2D( inputTex1 , displacementL)*scale2; 
	Color -= tex2D( inputTex0 , In.TextureUV0-offset)*scale; 
	Color -= tex2D( inputTex1 , displacementR)*scale2; 
	Color.rgb = (Color.r+Color.g+Color.b);
		
    PS_OUTPUT Output;
    Color = Color*0.3 * OrigColor*0.8;
    
    float4 ct = Color + 0.8;
    float a = sqrt(ct.r*ct.r + ct.g*ct.g + ct.b*ct.b);
    a *= 0.3;
    // a *= a;
    // a = 0.5;
    
    /*if (a>1) a=1;
    if (a<0.1) a=0.1;
   */
    float4 bgColor = (tex2D(inputTex1, In.TextureUV1)*g_canvasBrightness);
    // g_bgColor += 0.5;
    // bgColor = bgColor + g_bgColor;
    Output.RGBColor = lerp(bgColor, Color, a);
    // Output.RGBColor = ;

    return Output;
}




PS_OUTPUT blur( VS_OUTPUT In )
{ 
		const float scale = 1.0f;
		const float off = 1.00f;
		
		const float SSCALE = 0.025f;
		const float SSCALE2 = SSCALE *0.5;
		
		float2 uv = In.TextureUV0;
		float2 ouv = uv.xy;
	
    float4 OrigColor;
    float4 Color = 0; // tex2D (input, uv);
    OrigColor = tex2D(inputTex0, uv); // In.Diffuse;
    
    float2 off2d;
    

	const int SCALE = 3;
	
	int count = 0;
    for (int y=-SCALE; y<=SCALE; y++)
    	for (int x=-SCALE; x<=SCALE; x++)
    	{
    		uv.x = ouv.x + x*0.002; 
    		uv.y = ouv.y - y*0.002;
    		
    		float a = (5 - (x)) * (5 - (y));
    		// a /= 25;
    		a *= 0.0;
    		// a = 1.0 + a; // *0.5f;
    		Color += (tex2D(inputTex0, uv.xy) * a); ///1.0;
    		
    		count++;
    	}
 
    	
  		// Color = Color / count;
  		
  		// Color = tex2D(input, In.TextureUV);
  		
  		/*
 			Color -= 0.5;
 			Color *= 2.5;
 			Color += 0.5;
 			*/
  		
  	// 	OrigColor = Color;
  	
   
    // float total = (OrigColor-r + OrigColor.g + OrigColor.b)/3;
    // Color = 0.5 + Color;
    
    // Color = Color * (1 + 1.6);

    // OrigColor = lerp(Color * In.Diffuse, OrigColor, 0.8);
    OrigColor *= Color;
    
    /*
    off *= sin(diffuse.r + diffuse.g + OrigColor.b);
    
    float4 c1 = tex2D (input, uv.xy * off);
    
    off *= cos(diffuse.b + diffuse.a + OrigColor.r);
    float4 c2 = tex2D (input, uv.xy * off);
    
    float p = (ouv.y + 0. + sin(c1.r+c2.g+c2.a));
    
		float4 noiseColor = c1*c2*p;

    OrigColor = OrigColor * diffuse;
    OrigColor = OrigColor + (noiseColor*0.15);
    */
    
    PS_OUTPUT Output;
    Output.RGBColor = OrigColor;

    return Output;
}



//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Test
{
    pass P0
    {          
        VertexShader = compile vs_3_0 RenderSceneVS( );
        PixelShader  = compile ps_3_0 RenderScenePS( ); 
        // PixelShader  = compile ps_3_0 blur( ); 
    }
}
