#include "utils.fx"

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);

Texture g_inputNoiseTexture;
float4x4 	g_worldViewProjection;
float		g_noisePhase0;
float		g_noisePhase1;



sampler NoiseSampler = sampler_state
{
	Texture = <g_inputNoiseTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};


//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    float2 TextureUV1  : TEXCOORD1;  // vertex texture coords 
};

VS_OUTPUT NoiseVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;

		Output.Position = mul(vPos, g_worldViewProjection);
		Output.Diffuse = vColor;
		Output.TextureUV0 = vTexCoord0;
		Output.TextureUV1 = vTexCoord1;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;
};


float4 NoisePS( float2 uv0 : TEXCOORD0, float2 uv1 : TEXCOORD1, float4 color : COLOR0) : COLOR0
{ 
		float2 nuv = uv0;
		nuv.x += g_noisePhase0 * 0.2f;
		nuv.y += g_noisePhase1*0.02f;
		
		float2 nnuv;
		nnuv.x = nuv.y * 0.2;
		nnuv.y = nuv.x;
		
		float offset = 0.0001;
		
		float4 p = tex2D(NoiseSampler, nnuv * 0.4f);
		p -= tex2D(NoiseSampler, nnuv * 0.4f - offset)*7;
		p += tex2D(NoiseSampler, nnuv * 0.4f + offset)*7;
		
		// nuv.x *= 0.4;
		float4 p2 = tex2D(NoiseSampler, (nuv + g_noisePhase1));
		
  	float4 c = p * p2 * color * 4;
  	
  	c -= 0.5;
  	c *= 24.2f;
  	c += 0.5;
  	
  	c *= 14.4f;
  	
  	return c;
}


technique Plane
{
    pass P0
    {   
        VertexShader = compile vs_3_0 NoiseVS( );
        PixelShader  = compile ps_3_0 NoisePS( ); 
    }
}


