
uniform sampler2D texture;
uniform float saturation;
uniform float t;
uniform float rt, gt, bt;
uniform float ro, go, bo;

const float pi = 3.1415926535897932;
const float offmul = 0.008;
const float tcmul = 4.0;

float noise(float x) {
	return (cos(x*pi)*cos(x*pi))*cos(x*3.0*pi)*cos(x*5.0*pi)*0.5+sin(x*25.0*pi)*0.02*saturation;
}

void main() {
//	float offmul = (1-saturation)*0.1;
	vec2 tc = gl_TexCoord[0].xy;
	vec2 tcr = vec2(tc.x+ro+offmul*noise(rt+tc.y*tcmul+noise(t*pi+tc.y)), tc.y);
	vec2 tcg = vec2(tc.x+go+offmul*noise(gt+tc.y*tcmul+noise(t*pi+tc.y)), tc.y);
	vec2 tcb = vec2(tc.x+bo+offmul*noise(bt+tc.y*tcmul+noise(t*pi+tc.y)), tc.y);

	float r = texture2D(texture, tcr).r;
	float g = texture2D(texture, tcg).g;
	float b = texture2D(texture, tcb).b;

	gl_FragColor = vec4(r, g, b, 1.0);


}