
const float n = 5.0;
const float c = -1.0;

uniform sampler2D tex;
uniform float width, height;
uniform float intensity;

void main() {
	float xp = 1.0/width;
	float yp = 1.0/height;

	vec3 t11 = texture2D(tex, gl_TexCoord[0].xy).rgb;
	vec3 t10 = texture2D(tex, gl_TexCoord[0].xy+vec2(0, -yp)).rgb;
	vec3 t01 = texture2D(tex, gl_TexCoord[0].xy+vec2(-xp, 0)).rgb;
	vec3 t21 = texture2D(tex, gl_TexCoord[0].xy+vec2(xp, 0)).rgb;
	vec3 t12 = texture2D(tex, gl_TexCoord[0].xy+vec2(0, yp)).rgb;

	vec3 sharpencol = t11*n+t10*c+t01*c+t21*c+t12*c;

	gl_FragColor = vec4(mix(t11, sharpencol, intensity), 1.0);
}
