
uniform sampler2D texture;
uniform float bri;
uniform float intensity;
uniform float fade;
uniform float xmul;
uniform float ymul;
uniform float bw;
uniform float contrast;
uniform float ofade;

void main() {

	gl_FragColor = vec4(0.5, 1.0, 1.0, 1.0);

	vec2 paskamul = vec2(xmul, ymul);
	vec2 texnew1 = gl_TexCoord[0].xy*paskamul;

	vec3 col = texture2D(texture, gl_TexCoord[0].xy).rgb;

	vec2 texvec = (texnew1*2.0-1.0)*intensity;

	vec3 dvec = -0.5+0.5*col;
	texnew1.x += texvec.x*dvec.x*0.5;
	texnew1.y += texvec.y*dvec.z*0.5;

	vec4 newcol = texture2D(texture, texnew1.xy)*fade + texture2D(texture, texnew1.yx*0.025)*(1.0-fade);

	col = (1.0-ofade)*col + ofade*newcol.rgb;

	float dlen = length(dvec);
	dlen = dlen*(1.0-bri*0.8);
	float brimul = 1.0*(1.0-dlen);

	vec3 fincol = col*brimul;
	fincol = mix(fincol, vec3(max(fincol.r, max(fincol.g, fincol.b))), bw);

	fincol -= 0.5;
	fincol = fincol*contrast;
	fincol += 0.5;

//	fincol =
//	fincol.r = max(fincol.r, max(fincol.g, fincol.b));
	fincol.gb = vec2(fincol.r,  fincol.r);

	// temporarily replaced saturate(fincol) with clamp(fincol,0.0,1.0)
	gl_FragColor = vec4(clamp(fincol,0.0,1.0), 1.0);
}
