/*
 * Decompiled with CFR 0.152.
 */
package ddf.mimin.javasound;

import ddf.mimin.javasound.JSMinim;
import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.spi.AudioRecordingStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.FloatSampleBuffer;

abstract class JSBaseAudioRecordingStream
implements Runnable,
AudioRecordingStream {
    private Thread iothread;
    private AudioListener listener;
    private AudioEffect effect;
    private boolean play;
    private boolean loop;
    private int numLoops;
    private int loopBegin;
    private int loopEnd;
    protected AudioInputStream ais;
    private byte[] rawBytes;
    private int totalBytesRead;
    protected AudioFormat format;
    private SourceDataLine line;
    private FloatSampleBuffer buffer;
    private int bufferSize;
    private boolean finished;
    private float[] silence;
    protected JSMinim system;

    JSBaseAudioRecordingStream(JSMinim sys, AudioInputStream stream, SourceDataLine sdl, int bufferSize, int msLen) {
        this.format = sdl.getFormat();
        this.bufferSize = bufferSize;
        this.buffer = new FloatSampleBuffer(this.format.getChannels(), bufferSize, this.format.getSampleRate());
        this.system = sys;
        this.system.debug("FloatSampleBuffer has " + this.buffer.getSampleCount() + " samples.");
        this.finished = false;
        this.line = sdl;
        this.ais = stream;
        this.loop = false;
        this.play = false;
        this.numLoops = 0;
        this.loopBegin = 0;
        this.loopEnd = (int)AudioUtils.millis2BytesFrameAligned((long)msLen, (AudioFormat)this.format);
        this.rawBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        this.silence = new float[bufferSize];
        this.iothread = null;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        ** GOTO lbl14
        {
            this.sleep(10);
            do {
                if (this.line.available() < this.rawBytes.length) continue block0;
                if (this.play) {
                    if (this.loop) {
                        this.readBytesLoop();
                    } else {
                        this.readBytes();
                    }
                    this.process();
                    this.writeBytes();
                }
                this.broadcast();
                this.sleep(10);
lbl14:
                // 2 sources

            } while (!this.finished);
        }
        this.line.drain();
        this.line.close();
        this.line = null;
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBytes() {
        int bytesRead = 0;
        int toRead = this.rawBytes.length;
        try {
            while (bytesRead < toRead) {
                int actualRead = 0;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    actualRead = this.ais.read(this.rawBytes, bytesRead, toRead - bytesRead);
                }
                if (actualRead == -1) {
                    this.pause();
                    break;
                }
                bytesRead += actualRead;
            }
        }
        catch (IOException e) {
            this.system.error("Error reading from the file - " + e.getMessage());
        }
        this.totalBytesRead += bytesRead;
    }

    private void readBytesLoop() {
        int toLoopEnd = this.loopEnd - this.totalBytesRead;
        if (toLoopEnd <= 0) {
            this.setMillisecondPosition(this.loopBegin);
            this.readBytesLoop();
            return;
        }
        if (toLoopEnd < this.rawBytes.length) {
            this.readBytesWrap(toLoopEnd, 0);
            if (this.loop && this.numLoops == 0) {
                this.loop = false;
                this.pause();
            } else if (this.loop) {
                this.setMillisecondPosition(this.loopBegin);
                this.readBytesWrap(this.rawBytes.length - toLoopEnd, toLoopEnd);
                if (this.numLoops != -1) {
                    --this.numLoops;
                }
            }
        } else {
            this.readBytesWrap(this.rawBytes.length, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBytesWrap(int toRead, int offset) {
        int bytesRead = 0;
        try {
            while (bytesRead < toRead) {
                int actualRead = 0;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    actualRead = this.ais.read(this.rawBytes, bytesRead + offset, toRead - bytesRead);
                }
                if (-1 == actualRead) {
                    this.setMillisecondPosition(0);
                    continue;
                }
                if (actualRead != 0) {
                    bytesRead += actualRead;
                    this.totalBytesRead += actualRead;
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.system.error("Error reading from the file - " + ioe.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeBytes() {
        actualWrit = this.line.write(this.rawBytes, 0, this.rawBytes.length);
        ** GOTO lbl7
        {
            this.sleep(10);
            do {
                if (this.line.available() < this.rawBytes.length - actualWrit) continue block0;
                actualWrit += this.line.write(this.rawBytes, actualWrit, this.rawBytes.length - actualWrit);
lbl7:
                // 2 sources

            } while (actualWrit != this.rawBytes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast() {
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            if (this.buffer.getChannelCount() == 1) {
                if (this.play) {
                    this.listener.samples(this.buffer.getChannel(0));
                } else {
                    this.listener.samples(this.silence);
                }
            } else if (this.buffer.getChannelCount() == 2) {
                if (this.play) {
                    this.listener.samples(this.buffer.getChannel(0), this.buffer.getChannel(1));
                } else {
                    this.listener.samples(this.silence, this.silence);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void process() {
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            int frameCount = this.rawBytes.length / this.format.getFrameSize();
            this.buffer.setSamplesFromBytes(this.rawBytes, 0, this.format, 0, frameCount);
            if (this.buffer.getChannelCount() == 1) {
                this.effect.process(this.buffer.getChannel(0));
            } else if (this.buffer.getChannelCount() == 2) {
                this.effect.process(this.buffer.getChannel(0), this.buffer.getChannel(1));
            }
            this.buffer.convertToByteArray(this.rawBytes, 0, this.format);
        }
    }

    public void play() {
        this.line.start();
        this.loop = false;
        this.numLoops = 0;
        this.play = true;
    }

    public boolean isPlaying() {
        return this.play;
    }

    public void pause() {
        this.line.stop();
        this.play = false;
    }

    public void loop(int n) {
        this.loop = true;
        this.numLoops = n;
        this.play = true;
        this.setMillisecondPosition(this.loopBegin);
        this.line.start();
    }

    public void open() {
        this.iothread = new Thread(this);
        this.finished = false;
        this.iothread.start();
    }

    public void close() {
        this.line.stop();
        this.finished = true;
        try {
            this.iothread.join(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.iothread = null;
        try {
            this.ais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ais = null;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getLoopCount() {
        return this.numLoops;
    }

    public void setLoopPoints(int start, int stop) {
        this.loopBegin = start <= 0 || start > stop ? 0 : start;
        this.loopEnd = stop <= this.getMillisecondLength() && stop > start ? (int)AudioUtils.millis2BytesFrameAligned((long)stop, (AudioFormat)this.format) : (int)AudioUtils.millis2BytesFrameAligned((long)this.getMillisecondLength(), (AudioFormat)this.format);
    }

    public int getMillisecondPosition() {
        return (int)AudioUtils.bytes2Millis((long)this.totalBytesRead, (AudioFormat)this.format);
    }

    public void setMillisecondPosition(int millis) {
        boolean wasPlaying = this.play;
        this.play = false;
        if (millis < this.getMillisecondPosition()) {
            this.rewind();
            this.totalBytesRead = this.skip(millis);
        } else {
            this.totalBytesRead += this.skip(millis - this.getMillisecondPosition());
        }
        this.play = wasPlaying;
    }

    public Control[] getControls() {
        return this.line.getControls();
    }

    public void setAudioEffect(AudioEffect effect) {
        this.effect = effect;
    }

    public void setAudioListener(AudioListener listener) {
        this.listener = listener;
    }

    protected abstract void rewind();

    protected abstract int skip(int var1);
}

