
//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
matrix View;
matrix Projection;
float time;

matrix ChocoModel;
matrix ChocoView;
matrix ChocoProjection;

Texture2D ChocoTexture;

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

Texture2D OverlayTexture;


//--------------------------------------------------------------------------------------
// PASS 0 - CHOCO
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos : SV_POSITION;
    float4 Color : COLOR;
};

//--------------------------------------------------------------------------------------
// Vertex Shader P0
//--------------------------------------------------------------------------------------
VS_OUTPUT VS0( float4 Pos : POSITION, 
                float3 Normal : NORMAL,
                float3 Center : TEXCOORD0 )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    
    output.Pos = mul( Pos, ChocoModel );
    output.Pos = mul( output.Pos, ChocoView );
    output.Pos = mul( output.Pos, ChocoProjection );
    
    float4 iNormal = float4(Normal, 0);
    float4 oNormal = mul( iNormal, ChocoModel );
    
    float litColor = -oNormal.z;
    output.Color = litColor * float4(0.6, 0.6, 1, 1);
    
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader P0
//--------------------------------------------------------------------------------------
float4 PS0( VS_OUTPUT input ) : SV_Target
{
    //return float4(0,0,0,1);
    return input.Color;
}


//--------------------------------------------------------------------------------------
// PASS 1 - SEA
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Vertex Shader P1
//--------------------------------------------------------------------------------------
VS_OUTPUT VS1( float4 Pos : POSITION, 
                float3 Normal : NORMAL,
                float3 Center : TEXCOORD0 )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    
    float yOffset = 0.5 * cos(Center.x + time);
    float yOffsetBef = 0.5 * cos(Center.x - 1 + time);
    float yOffsetAft = 0.5 * cos(Center.x + 1 + time);
    
    // form the new rotation transform
    float3 xaxis = normalize(float3(2, yOffsetAft - yOffsetBef, 0));
    float3 zaxis = float3(0, 0, 1);
    float3 yaxis = normalize(cross(zaxis, xaxis));
    
    // calculate rotated hex points
    float4 rotatedPos = float4(
        Pos.x * xaxis.x + Pos.y * yaxis.x + Pos.z * zaxis.x + Center.x,
        Pos.x * xaxis.y + Pos.y * yaxis.y + Pos.z * zaxis.y + yOffset,
        Pos.x * xaxis.z + Pos.z * yaxis.z + Pos.z * zaxis.z + Center.z,
        1
        );

    // calculate rotated normals
    float4 rotatedNor = float4(
        Normal.x * xaxis.x + Normal.y * yaxis.x + Normal.z * zaxis.x,
        Normal.x * xaxis.y + Normal.y * yaxis.y + Normal.z * zaxis.y,
        Normal.x * xaxis.z + Normal.z * yaxis.z + Normal.z * zaxis.z,
        0
        );
    
    output.Pos = mul( rotatedPos, View );
    output.Pos = mul( output.Pos, Projection );
    float fogZ = 0.02 * output.Pos.z;
    
    float litColor = dot( rotatedNor, float4(-0.8, 0.6, 0, 0) );
    float2 tex = float2( Center.x + 20, Center.z + 20) / 40;
    output.Color = 0.4 * litColor + 0.6 * ChocoTexture.SampleLevel( samLinear, tex, 0 );
    output.Color = (1 - fogZ) * output.Color + fogZ;
    
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader P1
//--------------------------------------------------------------------------------------
float4 PS1( VS_OUTPUT input ) : SV_Target
{
    return input.Color;
    //return float4(0,0,0,1);
}

BlendState NoBlending
{
    BlendEnable[0] = FALSE;
};


//--------------------------------------------------------------------------------------
// PASS 2 - OVERLAY
//--------------------------------------------------------------------------------------
struct VS_OUTPUT2
{
    float4 Pos : SV_POSITION;
    float2 Tex : TEXCOORD;
};

//--------------------------------------------------------------------------------------
// Vertex Shader P2
//--------------------------------------------------------------------------------------
VS_OUTPUT2 VS2( float4 Pos : POSITION, 
                float3 Normal : NORMAL,
                float3 Tex : TEXCOORD0 )
{
    VS_OUTPUT2 output;
    output.Pos = Pos;
    output.Tex = Tex.xy;
    
    return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader P2
//--------------------------------------------------------------------------------------
float4 PS2( VS_OUTPUT2 input ) : SV_Target
{
    float alpha = (2.8 - input.Tex.x) / 2.8;
    float2 tex = float2(input.Tex.x - time * 0.5, input.Tex.y);
    float2 tex2 = 2 * float2(input.Tex.x - time * 0.2, input.Tex.y);
    float4 c1 = float4(0.2, 0.3, 0.1, alpha) * OverlayTexture.Sample( samLinear, tex );
    float4 c2 = float4(0.1, 0.3, 0.1, alpha * 0.7 ) * OverlayTexture.Sample( samLinear, - tex2);
    return c1 + c2;
}

BlendState SrcAlphaBlendingAdd
    {
        BlendEnable[0] = TRUE;
        SrcBlend = SRC_ALPHA;
        DestBlend = INV_SRC_ALPHA;
        BlendOp = ADD;
        SrcBlendAlpha = ZERO;
        DestBlendAlpha = ZERO;
        BlendOpAlpha = ADD;
        RenderTargetWriteMask[0] = 0x0F;
    };


//--------------------------------------------------------------------------------------
technique10 Render
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_4_0, VS0() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS0() ) );
        SetBlendState( NoBlending, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }

    pass P1
    {
        SetVertexShader( CompileShader( vs_4_0, VS1() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS1() ) );
        SetBlendState( NoBlending, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }

    pass P2
    {
        SetVertexShader( CompileShader( vs_4_0, VS2() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS2() ) );
        SetBlendState( SrcAlphaBlendingAdd, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}

