#include <GL/gl.h>
#include <GL/glu.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "timer.h"
#include "wiimote.h"

int shutting_down ;

/* number of stars to have */
#define STAR_NUM 500
#define STARFIELD_NUM 300

/* twinkle on/off (1 = on, 0 = off) */
int twinkle = 0;

typedef struct {         // Star structure
    int r, g, b;         // stars' color
    GLfloat dist;        // stars' distance from center
    GLfloat angle;       // stars' current angle
    float x, y, z;
    float size;
} stars;                 // name is stars

stars star[STAR_NUM];    // make 'star' array of STAR_NUM size using info from the structure 'stars'
stars starfield[STARFIELD_NUM];    // make 'star' array of STAR_NUM size using info from the structure 'stars'

GLfloat zoom = -35.5f; //-15.0f;   // viewing distance from stars.
GLfloat tilt = 90.0f;    // tilt the view
GLfloat spin;            // spin twinkling stars

GLuint loop;             // general loop variable
GLuint texture[1];       // storage for one texture;

float star_amp = 1.0;

/* Image type - contains height, width, and data */
struct Image {
    unsigned long sizeX;
    unsigned long sizeY;
    char *data;
};
typedef struct Image Image;

/*
 * getint and getshort are help functions to load the bitmap byte by byte on 
 * SPARC platform (actually, just makes the thing work on platforms of either
 * endianness, not just Intel's little endian)
 */

static unsigned int getint(fp)
     FILE *fp;
{
  int c, c1, c2, c3;

  // get 4 bytes
  c = getc(fp);  
  c1 = getc(fp);  
  c2 = getc(fp);  
  c3 = getc(fp);
  
  return ((unsigned int) c) +   
    (((unsigned int) c1) << 8) + 
    (((unsigned int) c2) << 16) +
    (((unsigned int) c3) << 24);
}

static unsigned int getshort(fp)
     FILE *fp;
{
  int c, c1;
  
  //get 2 bytes
  c = getc(fp);  
  c1 = getc(fp);

  return ((unsigned int) c) + (((unsigned int) c1) << 8);
}

// quick and dirty bitmap loader...for 24 bit bitmaps with 1 plane only.  
// See http://www.dcs.ed.ac.uk/~mxr/gfx/2d/BMP.txt for more info.

int ImageLoad(char *filename, Image *image) 
{
    FILE *file;
    unsigned long size;                 // size of the image in bytes.
    unsigned long i;                    // standard counter.
    unsigned short int planes;          // number of planes in image (must be 1) 
    unsigned short int bpp;             // number of bits per pixel (must be 24)
    char temp;                          // used to convert bgr to rgb color.

    // make sure the file is there.
    if ((file = fopen(filename, "rb"))==NULL) {
      printf("File Not Found : %s\n",filename);
      return 0;
    }
    
    // seek through the bmp header, up to the width/height:
    fseek(file, 18, SEEK_CUR);

    // No 100% errorchecking anymore!!!

    // read the width
    image->sizeX = getint (file);
    //printf("Width of %s: %lu\n", filename, image->sizeX);
    
    // read the height 
    image->sizeY = getint (file);
    //printf("Height of %s: %lu\n", filename, image->sizeY);
    
    // calculate the size (assuming 24 bits or 3 bytes per pixel).
    size = image->sizeX * image->sizeY * 3;

    // read the planes
    planes = getshort(file);
    if (planes != 1) {
	printf("Planes from %s is not 1: %u\n", filename, planes);
	return 0;
    }

    // read the bpp
    bpp = getshort(file);
    if (bpp != 24) {
      printf("Bpp from %s is not 24: %u\n", filename, bpp);
      return 0;
    }
	
    // seek past the rest of the bitmap header.
    fseek(file, 24, SEEK_CUR);

    // read the data. 
    image->data = (char *) malloc(size);
    if (image->data == NULL) {
	printf("Error allocating memory for color-corrected image data");
	return 0;	
    }

    if ((i = fread(image->data, size, 1, file)) != 1) {
	printf("Error reading image data from %s.\n", filename);
	return 0;
    }

    for (i=0;i<size;i+=3) { // reverse all of the colors. (bgr -> rgb)
	temp = image->data[i];
	image->data[i] = image->data[i+2];
	image->data[i+2] = temp;
    }

    // we're done.
    return 1;
}

// Load Bitmaps And Convert To Textures
GLvoid LoadGLTextures(GLvoid) 
{	
    // Load Texture
    Image *image1;
    
    // allocate space for texture
    image1 = (Image *) malloc(sizeof(Image));
    if (image1 == NULL) {
	printf("Error allocating space for image");
	exit(0);
    }

    if (!ImageLoad("star.bmp", image1)) {
	exit(1);
    }        

    // Create Textures	
    glGenTextures(3, &texture[0]);

    // linear filtered texture
    glBindTexture(GL_TEXTURE_2D, texture[0]);   // 2d texture (x and y size)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); // scale linearly when image bigger than texture
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // scale linearly when image smalled than texture
    glTexImage2D(GL_TEXTURE_2D, 0, 3, image1->sizeX, image1->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, image1->data);
};

float rand1()
{
  return ((rand() / (RAND_MAX + 1.0)));
}

void init_star_in_starfield(int loop)
{
  starfield[loop].angle = 0.0f;                // initially no rotation.
  
  starfield[loop].dist = loop * 1.0f / STAR_NUM * 5.0f; // calculate distance form the center
  starfield[loop].r = 255; //rand() % 256;            // random red intensity;
  starfield[loop].g = 255; //rand() % 256;            // random green intensity;
  starfield[loop].b = 255; //rand() % 256;            // random blue intensity;
  starfield[loop].x = (rand1() - 0.5 )* 100.0;
  starfield[loop].y = (rand1() - 0.5 )* 100.0 + 50.0;
  starfield[loop].z = (rand1() - 0.5 )* 100.0;
  starfield[loop].size = 0.2;
}

void init_star()
{
  shutting_down = 0;
    LoadGLTextures();                           // load the textures.
    glEnable(GL_TEXTURE_2D);                    // Enable texture mapping.

    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	// This Will Clear The Background Color To Black
    glClearDepth(1.0);				// Enables Clearing Of The Depth Buffer

    glShadeModel(GL_SMOOTH);			// Enables Smooth Color Shading
    
    /* setup blending */
    glBlendFunc(GL_SRC_ALPHA,GL_ONE);	        // Set The Blending Function For Translucency
    glEnable(GL_BLEND);                         // Enable Blending

    glDisable(GL_DEPTH_TEST);

    /* set up the stars */
    for (loop=0; loop<STAR_NUM; loop++) {
	star[loop].angle = 0.0f;                // initially no rotation.
	
	star[loop].dist = loop * 1.0f / STAR_NUM * 5.0f; // calculate distance form the center
	star[loop].r = 255; //rand() % 256;            // random red intensity;
	star[loop].g = 255; //rand() % 256;            // random green intensity;
	star[loop].b = 255; //rand() % 256;            // random blue intensity;
    }    

    for (loop=0; loop<STARFIELD_NUM; loop++) {
      init_star_in_starfield(loop);
    }    
}

static int current = 0;
static int current2 = 0;
static float bx = 0, by = 0, bz = 0;
static float bx2 = 0, by2 = 0, bz2 = 0;
  static float fx = 0, fy = 0, fz = 0;

void create_stars()
{
  static float r = 255, g = 255, b = 255;
  float accel, accel2;
  static float last_x = 0;
  static float last_y = 0;
  static float last_z = 0;
  static float last_accel = 0;
  int i, new_stars;
  
  if (shutting_down)
    return;
    /*
    r = (bx + wiimote1->gforce.x) * 128;
    if (r > 255) r = 255;
    if (r < 0) r = 0;
    g = (by + wiimote1->gforce.y) * 128;
    if (g > 255) g = 255;
    if (g < 0) g = 0;
    b = (bz + wiimote1->gforce.z) * 128;
    if (b > 255) b = 255;
    if (b < 0) b = 0;
    */
    //printf("chuk: %f %f %f\n", wiimote1->exp.nunchuk.gforce.x, wiimote1->exp.nunchuk.gforce.y, wiimote1->exp.nunchuk.gforce.z);
    r = fabs(wiimote1->exp.nunchuk.gforce.x) * 3.0 * 255;
    g = fabs(wiimote1->exp.nunchuk.gforce.y) * 3.0 * 255;
    b = fabs(wiimote1->exp.nunchuk.gforce.z - 0.30) * 3.0 * 255;
    //printf("rgb: %i %i %i\n", r, g, b);

  
  fx = wiimote1->gforce.x;
  fy = wiimote1->gforce.y;
  fz = wiimote1->gforce.z;
  
  accel = (fz*fz + fy*fy + fx*fx);
  
  //if (accel >= 1.1)
    new_stars = ceil(accel / 3.0);
  //else
    //new_stars = 0;
  
  for (i=0; i<new_stars; i++)
  {
      
    star[current].x = last_z + (fz - last_z) * (i + 1) / (new_stars);
    star[current].y = last_y + (fy - last_y) * (i + 1) / (new_stars);; //+sqrt(fz*fz + fy*fy + fx*fx)*5;
    star[current].z = last_x + (fx - last_x) * (i + 1) / (new_stars);
    
    star[current].x *= star_amp;
    star[current].y *= star_amp;
    star[current].z *= star_amp;
    
    //printf("y: %g\n", star[current].y);
    star[current].r = r;
    star[current].g = g;
    star[current].b = b;
    
    star[current].size = 1.0; //accel / 3.0f;
    
    current++;
    if (current >= STAR_NUM)
      current = 0;
  }
  last_accel = accel;
  last_x = fx;
  last_y = fy;
  last_z = fz;
}

int ax,ay,az = 0;

void draw_star()
{
  int wii_update = 0;
  static float fx2 = 0, fy2 = 0, fz2 = 0;
  static int r2 = 255, g2 = 255, b2 = 255;
  static unsigned int ticks = 0;
  struct timeval time;
  static float rx = 516, rz = -76;
  static float tx = 0, ty = 0, tz = 0;
  static int paused = 0;
  static float hit_acc = 0;
  static float hit_delay = 0.001;
  float seconds;
  float bamp;
  
  seconds = frame_ticks / 1000.0;

  hit_acc += seconds;
  
  /*
  while (wiimote_is_open(&wi2) && wiimote_pending(&wi2)) {
    wiimote_update(&wi2); 	// synchronize with wiimote
    r2 = (bx2 + wi2.force.x) * 128;
    if (r2 > 255) r2 = 255;
    if (r2 < 0) r2 = 0;
    g2 = (by2 + wi2.force.y) * 128;
    if (g2 > 255) g2 = 255;
    if (g2 < 0) g2 = 0;
    b2 = (bz2 + wi2.force.z) * 128;
    if (b2 > 255) b2 = 255;
    if (b2 < 0) b2 = 0;
    //printf("wi2: %d, %d, %d\n", r, g, b);
  
    if (wi2.keys.b)
    {
      bx2 = wi2.force.x;
      by2 = wi2.force.y;
      bz2 = wi2.force.z;
    }
    if (wi2.keys.home) // && !wi.old.keys.plus
    {
      bx2 = 0;
      by2 = 0;
      bz2 = 0;
    }
    
    
    fx2 = wi2.force.x;
    fy2 = wi2.force.y;
    fz2 = wi2.force.z;
    accel2 = sqrt(fz2*fz2 + fy2*fy2 + fx2*fx2);
    
  }
  */
    /*
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_B))
    {
      //-0.038462 0.461538 1.576923
      bx = wiimote1->gforce.x;
      by = wiimote1->gforce.y;
      bz = wiimote1->gforce.z;
      printf("b color: %f %f %f\n", bx, by, bz);
    }
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_HOME)) // && !wi.old.keys.plus
    {
      bx = 0;
      by = 0;
      bz = 0;
    }
    */
    /*
    printf("chuk: %f %f %f\n", wiimote1->exp.nunchuk.gforce.x, wiimote1->exp.nunchuk.gforce.y, wiimote1->exp.nunchuk.gforce.z);
    
    bamp = 2.0;
    bx = wiimote1->exp.nunchuk.gforce.x * bamp;
    by = wiimote1->exp.nunchuk.gforce.y * bamp;
    bz = wiimote1->exp.nunchuk.gforce.z * bamp;
    */
    /*
    printf("ir1 x=%04d y=%04d size=%02d | ", wi.ir1.x, wi.ir1.y, wi.ir1.size);
    printf("ir2 x=%04d y=%04d size=%02d\n", wi.ir2.x, wi.ir2.y, wi.ir2.size);
    */
    create_stars();
    
    /*
    if (IS_JUST_PRESSED(wiimote1, WIIMOTE_BUTTON_A))
      paused = !paused;
    */
    if (!paused && (hit_acc >= hit_delay))
    {
      hit_acc -= hit_delay;
    
    /*
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_PLUS)) // && !wi.old.keys.plus
    {
      zoom += -fx;
      printf("zoom: %g\n", zoom);
    }
    */
    /*
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_MINUS)) // && !wi.old.keys.minus
    {
      tilt += -fx;
      printf("tilt: %g\n", tilt);
    }
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_ONE))
    {
      rx += -fx;
      printf("rx: %g\n", rx);
    }
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_TWO))
    {
      rz += -fx;
      printf("rz: %g\n", rz);
    }
    */
    if (isfinite(wiimote1->exp.nunchuk.js.ang))
    {
      tilt += wiimote1->exp.nunchuk.js.mag * sin(wiimote1->exp.nunchuk.js.ang / 180.0 * M_PI);
      zoom += wiimote1->exp.nunchuk.js.mag * cos(wiimote1->exp.nunchuk.js.ang / 180.0 * M_PI);
      //printf("mag: %f ang: %f\n", wiimote1->exp.nunchuk.js.mag, wiimote1->exp.nunchuk.js.ang);
      //printf("cos(ang): %f\n", cos(wiimote1->exp.nunchuk.js.ang / 180.0 * M_PI));
      //printf("zoom: %f tilt: %f\n", zoom, tilt);
    }
    if (zoom > -5.0f)
      zoom = -5.0f;
    if (zoom < -80.0f)
      zoom = -80.0f;
    
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_RIGHT))
      tx -= 0.1;
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_LEFT))
      tx += 0.1;
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_UP))
      ty -= 0.1;
    if (IS_PRESSED(wiimote1, WIIMOTE_BUTTON_DOWN))
      ty += 0.1;
  
  
    /*
    if (wiimote_is_open(&wi2))
    {
      star[current2].x = fz2;
      star[current2].y = fy2; //+sqrt(fz*fz + fy*fy + fx*fx)*5;
      star[current2].z = fx2;
      //printf("y: %g\n", star[current].y);
      star[current2].r = r2;
      star[current2].g = g2;
      star[current2].b = b2;
      
      star[current2].size = 1.0; //accel / 3.0f;
      
      current2++;
      if (current2 >= STAR_NUM)
        current2 = STAR_NUM / 2;
    }
    */
    /*if (wi.keys.home) {	// check if home key is pressed
      wiimote_disconnect(&wi);
    }*/
    /*if (wi.keys.a) {
      printf("x=%d y=%d z=%d\n", wi.axis.x, wi.axis.y, wi.axis.z);
    }*/
    
    /*
    for (loop=0; loop<STAR_NUM; loop++) {        // loop through all the stars.
	    star[loop].r = wi.axis.x;        // new red color.
	    star[loop].g = wi.axis.y;        // new green color.
	    star[loop].b = wi.axis.z;        // new blue color.
		}
		*/
  
    float speed = 0.2;
    if (shutting_down)
      speed *= 3;
      
    for (loop=0; loop<STAR_NUM; loop++) {        // loop through all the stars.
        star[loop].y -= speed * frame_ticks / 20.0;
    
    	spin +=0.01f * frame_ticks / 20.0;                           // used to spin the stars.
	//if (wi.keys.b && wi.axis.z > 0xA0)
  //	spin += (wi.axis.z - 0xA0) / 256.0;
	
	//star[loop].angle += loop * 1.0f / STAR_NUM * 1.0f;    // change star angle.
	star[loop].dist  -= 0.01f;              // bring back to center.

	if (star[loop].dist<0.0f) {             // star hit the center
	    star[loop].dist += 5.0f;            // move 5 units from the center.
        }
    }
  
    for (loop=0; loop<STARFIELD_NUM; loop++) {        // loop through all the stars.
        starfield[loop].y -= speed * frame_ticks / 20.0;
    
    	//spin +=0.0001f;                           // used to spin the stars.
	//if (wi.keys.b && wi.axis.z > 0xA0)
  //	spin += (wi.axis.z - 0xA0) / 256.0;
	
	//star[loop].angle += loop * 1.0f / STAR_NUM * 1.0f;    // change star angle.
	starfield[loop].dist  -= 0.01f;              // bring back to center.

        if (!shutting_down)
          if (starfield[loop].dist<-5.0f) {             // star hit the center
              init_star_in_starfield(loop);
              //starfield[loop].dist += 5.0f;            // move 5 units from the center.
              //starfield[loop].dist = 0.0;
          }
    }
  
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear The Screen And The Depth Buffer
    
    glBindTexture(GL_TEXTURE_2D, texture[0]);    // pick the texture.
/*
	if (wi.keys.b && finite(wi.force.z))
	{
  	tilt += (wi.force.z - 1) / 50.0;
  	//if (!finite(tilt))
  	//  tilt = 0;
  	//printf("tilt: %g\n", tilt);
  	//zoom += wi.force.y / 10.0;
  }
*/
  //tilt = wi.force.z;

    for (loop=0; loop<STAR_NUM; loop++) {        // loop through all the stars.

	glLoadIdentity();                        // reset the view before we draw each star.
	glTranslatef(tx, ty, tz);          // zoom into the screen.
	glTranslatef(0.0f, 0.0f, zoom);          // zoom into the screen.
	glRotatef(rx, 0.0f, 1.0f, 0.0f);
	glRotatef(rz, 0.0f, 0.0f, 1.0f);
	glRotatef(tilt, 1.0f, 0.0f, 0.0f);       // tilt the view.
  //if (finite(wi.force.x) && finite(wi.force.y) && finite(wi.force.z))
  //	glRotatef(0.001, wi.force.x, wi.force.y, wi.force.z);       // tilt the view.
	
	/*
	glRotatef(star[loop].angle, 0.0f, 1.0f, 0.0f); // rotate to the current star's angle.
	glTranslatef(star[loop].dist, 0.0f, 0.0f); // move forward on the X plane (the star's x plane).
        */
        
        glTranslatef(star[loop].x, star[loop].y, star[loop].z); // move forward on the X plane (the star's x plane).
        
        
	glRotatef(-star[loop].angle, 0.0f, 1.0f, 0.0f); // cancel the current star's angle.
	glRotatef(-tilt, 1.0f, 0.0f, 0.0f);      // cancel the screen tilt.
	glRotatef(-rz, 0.0f, 0.0f, 1.0f);
	glRotatef(-rx, 0.0f, 1.0f, 0.0f);
	glScalef(star[loop].size, star[loop].size, star[loop].size);
	
	if (twinkle) {                           // twinkling stars enabled ... draw an additional star.
	    // assign a color using bytes
	    glColor4ub(star[STAR_NUM - loop].r, star[STAR_NUM - loop].g, star[STAR_NUM - loop].b, 255);

	    glBegin(GL_QUADS);                   // begin drawing the textured quad.
	    glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, 0.0f);
	    glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, 0.0f);
	    glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, 0.0f);
	    glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f, 1.0f, 0.0f);
	    glEnd();                             // done drawing the textured quad.
	}
	

	// main star
	glRotatef(spin, 0.0f, 0.0f, 1.0f);       // rotate the star on the z axis.

        // Assign A Color Using Bytes
	glColor4ub(star[loop].r,star[loop].g,star[loop].b,255);
	glBegin(GL_QUADS);			// Begin Drawing The Textured Quad
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,-1.0f, 0.0f);
	glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,-1.0f, 0.0f);
	glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f, 1.0f, 0.0f);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f, 1.0f, 0.0f);
	glEnd();				// Done Drawing The Textured Quad
	
	    
	    /*
	    star[loop].r = rand() % 256;        // new red color.
	    star[loop].g = rand() % 256;        // new green color.
	    star[loop].b = rand() % 256;        // new blue color.
	    */
	    /*
	    star[loop].r = wi.axis.x;        // new red color.
	    star[loop].g = wi.axis.y;        // new green color.
	    star[loop].b = wi.axis.z;        // new blue color.
	    */
	}
	
	/*
	star[loop].size -= seconds * 0.8;
	if (star[loop].size <= 0)
	  star[loop].size = 0;
        */
    }

    for (loop=0; loop<STARFIELD_NUM; loop++) {        // loop through all the stars.

	glLoadIdentity();                        // reset the view before we draw each star.
	glTranslatef(tx, ty, tz);          // zoom into the screen.
	glTranslatef(0.0f, 0.0f, zoom);          // zoom into the screen.
	glRotatef(rx, 0.0f, 1.0f, 0.0f);
	glRotatef(rz, 0.0f, 0.0f, 1.0f);
	glRotatef(tilt, 1.0f, 0.0f, 0.0f);       // tilt the view.
  //if (finite(wi.force.x) && finite(wi.force.y) && finite(wi.force.z))
  //	glRotatef(0.001, wi.force.x, wi.force.y, wi.force.z);       // tilt the view.
	
	/*
	glRotatef(star[loop].angle, 0.0f, 1.0f, 0.0f); // rotate to the current star's angle.
	glTranslatef(star[loop].dist, 0.0f, 0.0f); // move forward on the X plane (the star's x plane).
        */
        
        glTranslatef(starfield[loop].x, starfield[loop].y, starfield[loop].z); // move forward on the X plane (the star's x plane).
        
        
	glRotatef(-starfield[loop].angle, 0.0f, 1.0f, 0.0f); // cancel the current star's angle.
	glRotatef(-tilt, 1.0f, 0.0f, 0.0f);      // cancel the screen tilt.
	glRotatef(-rz, 0.0f, 0.0f, 1.0f);
	glRotatef(-rx, 0.0f, 1.0f, 0.0f);
	glScalef(starfield[loop].size, starfield[loop].size, starfield[loop].size);
	
	if (twinkle) {                           // twinkling stars enabled ... draw an additional star.
	    // assign a color using bytes
	    glColor4ub(starfield[STAR_NUM - loop].r, starfield[STAR_NUM - loop].g, starfield[STAR_NUM - loop].b, 255);

	    glBegin(GL_QUADS);                   // begin drawing the textured quad.
	    glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, 0.0f);
	    glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, 0.0f);
	    glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, 0.0f);
	    glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f, 1.0f, 0.0f);
	    glEnd();                             // done drawing the textured quad.
	}
	

	// main star
	glRotatef(spin, 0.0f, 0.0f, 1.0f);       // rotate the star on the z axis.

        // Assign A Color Using Bytes
	glColor4ub(starfield[loop].r,starfield[loop].g,starfield[loop].b,255);
	glBegin(GL_QUADS);			// Begin Drawing The Textured Quad
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,-1.0f, 0.0f);
	glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,-1.0f, 0.0f);
	glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f, 1.0f, 0.0f);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f, 1.0f, 0.0f);
	glEnd();				// Done Drawing The Textured Quad
	}
}

void shutdown_star()
{
  shutting_down = 1;
}

void restart_star()
{
  shutting_down = 0;
  star_amp = 2.0;
}
