#include <stdlib.h>
#include "sdl.h"
#include "wiimote.h"
#include "fluid.h"
#include "star.h"
#include "timer.h"
#include "main.h"
#include "sound.h"

int error_code = 0;

#define INTRO 1
#define STAR_EFFECT 2
#define FLUID_EFFECT 3
#define CREDITS 4

int current = INTRO;

void parse_args(int argc, char **argv)
{
}

void init()
{
  init_sdl();
  init_timer();
  init_bmp_display();
  draw_intro();
  sdl_render();
  init_wiimote();
  init_sound();
}

void shutdown_and_exit()
{
  shutdown_sdl();
  shutdown_wiimote();
  shutdown_sound();
  exit(error_code);
}

int music_inited = 0;

void step()
{
  //printf("step %d\n", current);
  process_sdl_events();
  step_timer();
  if (music_inited)
    step_sound();
  wiimote_step();
  
  switch (current)
  {
    case INTRO:
      draw_intro();
      break;
      
    case STAR_EFFECT:
      draw_star();
      break;
      
    case FLUID_EFFECT:
      draw_fluid();
      break;
    
    case CREDITS:
       draw_credits();
       break;
  }
  if (current != CREDITS)
    draw_cursors();
  //draw_intro();
  sdl_render();
}


void on_wiimote_event()
{
  if (current == FLUID_EFFECT)
    update_fluid();
  
  if (current != INTRO)
    update_music();

  if (current == INTRO && !music_inited && IS_JUST_PRESSED(wiimote1, WIIMOTE_BUTTON_A))
  {
    init_music();
    music_inited = 1;
  }
}

void key_down_event(SDL_Event *event)
{
  sound_key_down(event);
}

void on_music_event(int mark, int new_part, int just_before_new_part)
{
  printf("mark %d\n", mark);
  
  switch (mark)
  {
    case 1:
      printf("star effect\n");
      current = STAR_EFFECT;
      init_star();
      break;
    
    case 31:
      shutdown_star();
      break;
    
    case 33:
      printf("fluid effect\n");
      current = FLUID_EFFECT;
      init_fluid();
      break;
    
    case 81:
      printf("star effect\n");
      current = STAR_EFFECT;
      init_star();
      break;
      
    case 101:
      shutdown_star();
      break;
      
    case 105:
      printf("credits\n");
      current = CREDITS;
      break;
    
    case 121:
      shutdown_and_exit();
      break;
  }
  
  if (current == FLUID_EFFECT)
    fluid_mark(mark);
}

void on_cursor_effect_event(int index, int value)
{
  //printf("cursor event! %d %d\n", index, value);
  set_cursor(index, value);
}

int main(int argc, char **argv)
{
  parse_args(argc, argv);
  init();
  while (1)
    step();
}
