
#include "gfmath.h"

//================================================================================
//
// Structures
//
//================================================================================

#ifdef __cplusplus

/*GFMATRIX::GFMATRIX()
{
	_11 = 1.0f;
	_12 = 0.0f;
	_13 = 0.0f;
	_14 = 0.0f;
	_21 = 0.0f;
	_22 = 1.0f;
	_23 = 0.0f;
	_24 = 0.0f;
	_31 = 0.0f;
	_32 = 0.0f;
	_33 = 1.0f;
	_34 = 0.0f;
	_41 = 0.0f;
	_42 = 0.0f;
	_43 = 0.0f;
	_44 = 1.0f;
}

GFMATRIX::GFMATRIX( CONST FLOAT * f )
{
	_11 = (*f);
	_12 = (*f) + 0x1;
	_13 = (*f) + 0x2;
	_14 = (*f) + 0x3;
	_21 = (*f) + 0x4;
	_22 = (*f) + 0x5;
	_23 = (*f) + 0x6;
	_24 = (*f) + 0x7;
	_31 = (*f) + 0x8;
	_32 = (*f) + 0x9;
	_33 = (*f) + 0xa;
	_34 = (*f) + 0xb;
	_41 = (*f) + 0xc;
	_42 = (*f) + 0xd;
	_43 = (*f) + 0xe;
	_44 = (*f) + 0xf;
}

GFMATRIX::GFMATRIX( FLOAT _11, FLOAT _12, FLOAT _13, FLOAT _14,
	FLOAT _21, FLOAT _22, FLOAT _23, FLOAT _24,
	FLOAT _31, FLOAT _32, FLOAT _33, FLOAT _34,
	FLOAT _41, FLOAT _42, FLOAT _43, FLOAT _44 )
{
	this->_11 = _11;
	this->_12 = _12;
	this->_13 = _13;
	this->_14 = _14;
	this->_21 = _21;
	this->_22 = _22;
	this->_23 = _23;
	this->_24 = _24;
	this->_31 = _31;
	this->_32 = _32;
	this->_33 = _33;
	this->_34 = _34;
	this->_41 = _41;
	this->_42 = _42;
	this->_43 = _43;
	this->_44 = _44;
}

GFMATRIX::operator FLOAT* ()
{
	return (FLOAT*) this;
}

GFMATRIX::operator CONST FLOAT* () CONST
{
	return (CONST FLOAT*) this;
}

void GFMATRIX::operator = ( CONST GFMATRIX& m )
{
	_11 = m._11; _12 = m._12; _13 = m._13; _14 = m._14;
	_21 = m._21; _22 = m._22; _23 = m._23; _24 = m._24;
	_31 = m._31; _32 = m._32; _33 = m._33; _34 = m._34;
	_41 = m._41; _42 = m._42; _43 = m._43; _44 = m._44;
}

void GFMATRIX::operator = ( FLOAT s )
{
	_11 = s; _12 = s; _13 = s; _14 = s;
	_21 = s; _22 = s; _23 = s; _24 = s;
	_31 = s; _32 = s; _33 = s; _34 = s;
	_41 = s; _42 = s; _43 = s; _44 = s;
}

GFMATRIX& GFMATRIX::operator += ( CONST GFMATRIX& m )
{
	(*this) = (*this) + m;
	return (*this);
}

GFMATRIX& GFMATRIX::operator -= ( CONST GFMATRIX& m )
{
	(*this) = (*this) - m;
	return (*this);
}

GFMATRIX& GFMATRIX::operator *= ( CONST GFMATRIX& m )
{
	(*this) = (*this) * m;
	return (*this);
}

GFMATRIX& GFMATRIX::operator *= ( FLOAT s )
{
	(*this) = (*this) * s;
	return (*this);
}

GFMATRIX& GFMATRIX::operator /= ( FLOAT s )
{
	if ( s == 0.0f )
	{
		(*this) = 0.0f;
		return (*this);
	}

	(*this) = (*this) / s;
	return (*this);
}

GFMATRIX GFMATRIX::operator + () CONST
{
	return GFMATRIX(
		_11, _12, _13, _14,
		_21, _22, _23, _24,
		_31, _32, _33, _34,
		_41, _42, _43, _44);
}

GFMATRIX GFMATRIX::operator - () CONST
{
	return GFMATRIX(
		-_11, -_12, -_13, -_14,
		-_21, -_22, -_23, -_24,
		-_31, -_32, -_33, -_34,
		-_41, -_42, -_43, -_44);
}

GFMATRIX GFMATRIX::operator + ( CONST GFMATRIX& m ) CONST
{
	return GFMATRIX(
		_11 + m._11, _12 + m._12, _13 + m._13, _14 + m._14,
		_21 + m._21, _22 + m._22, _23 + m._23, _24 + m._24,
		_31 + m._31, _32 + m._32, _33 + m._33, _34 + m._34,
		_41 + m._41, _42 + m._42, _43 + m._43, _44 + m._44);
}

GFMATRIX GFMATRIX::operator - ( CONST GFMATRIX& m ) CONST
{
	return GFMATRIX(
		_11 - m._11, _12 - m._12, _13 - m._13, _14 - m._14,
		_21 - m._21, _22 - m._22, _23 - m._23, _24 - m._24,
		_31 - m._31, _32 - m._32, _33 - m._33, _34 - m._34,
		_41 - m._41, _42 - m._42, _43 - m._43, _44 - m._44);
}

GFMATRIX GFMATRIX::operator * ( CONST GFMATRIX& m ) CONST
{
	if ( (_41 == _42 == _43 == 0.0f) && (_44 == 1.0f) && (m._41 == m._42 == m._43 == 0.0f) && (m._44 == 1.0f) )
	{
		return GFMATRIX(
			(_11 * m._11) + (_12 * m._21) + (_13 * m._31) + (_14 * m._41),
			(_11 * m._12) + (_12 * m._22) + (_13 * m._32) + (_14 * m._42),
			(_11 * m._13) + (_12 * m._23) + (_13 * m._33) + (_14 * m._43),
			0.0f,

			(_21 * m._11) + (_22 * m._21) + (_23 * m._31) + (_24 * m._41),
			(_21 * m._12) + (_22 * m._22) + (_23 * m._32) + (_24 * m._42),
			(_21 * m._13) + (_22 * m._23) + (_23 * m._33) + (_24 * m._43),
			0.0f,

			(_31 * m._11) + (_32 * m._21) + (_33 * m._31) + (_34 * m._41),
			(_31 * m._12) + (_32 * m._22) + (_33 * m._32) + (_34 * m._42),
			(_31 * m._13) + (_32 * m._23) + (_33 * m._33) + (_34 * m._43),
			0.0f,

			(_41 * m._11) + (_42 * m._21) + (_43 * m._31) + (_44 * m._41),
			(_41 * m._12) + (_42 * m._22) + (_43 * m._32) + (_44 * m._42),
			(_41 * m._13) + (_42 * m._23) + (_43 * m._33) + (_44 * m._43),
			1.0f);
	}
	else
	{
		return GFMATRIX(
			(_11 * m._11) + (_12 * m._21) + (_13 * m._31) + (_14 * m._41),
			(_11 * m._12) + (_12 * m._22) + (_13 * m._32) + (_14 * m._42),
			(_11 * m._13) + (_12 * m._23) + (_13 * m._33) + (_14 * m._43),
			(_11 * m._14) + (_12 * m._24) + (_13 * m._34) + (_14 * m._44),

			(_21 * m._11) + (_22 * m._21) + (_23 * m._31) + (_24 * m._41),
			(_21 * m._12) + (_22 * m._22) + (_23 * m._32) + (_24 * m._42),
			(_21 * m._13) + (_22 * m._23) + (_23 * m._33) + (_24 * m._43),
			(_21 * m._14) + (_22 * m._24) + (_23 * m._34) + (_24 * m._44),

			(_31 * m._11) + (_32 * m._21) + (_33 * m._31) + (_34 * m._41),
			(_31 * m._12) + (_32 * m._22) + (_33 * m._32) + (_34 * m._42),
			(_31 * m._13) + (_32 * m._23) + (_33 * m._33) + (_34 * m._43),
			(_31 * m._14) + (_32 * m._24) + (_33 * m._34) + (_34 * m._44),

			(_41 * m._11) + (_42 * m._21) + (_43 * m._31) + (_44 * m._41),
			(_41 * m._12) + (_42 * m._22) + (_43 * m._32) + (_44 * m._42),
			(_41 * m._13) + (_42 * m._23) + (_43 * m._33) + (_44 * m._43),
			(_41 * m._14) + (_42 * m._24) + (_43 * m._34) + (_44 * m._44));
	}
}

GFMATRIX GFMATRIX::operator * ( FLOAT s ) CONST
{
	if ( s == 0.0f )
	{
		return GFMATRIX();
	}

	return GFMATRIX(
		_11 * s, _12 * s, _13 * s, _14 * s,
		_21 * s, _22 * s, _23 * s, _24 * s,
		_31 * s, _32 * s, _33 * s, _34 * s,
		_41 * s, _42 * s, _43 * s, _44 * s);	
}

GFMATRIX GFMATRIX::operator / ( FLOAT s ) CONST
{
	if ( s == 0.0f )
	{
		return GFMATRIX();
	}

	return GFMATRIX(
		_11 / s, _12 / s, _13 / s, _14 / s,
		_21 / s, _22 / s, _23 / s, _24 / s,
		_31 / s, _32 / s, _33 / s, _34 / s,
		_41 / s, _42 / s, _43 / s, _44 / s);
}

GFMATRIX operator * ( FLOAT s, CONST GFMATRIX& m )
{
	return m * s;
}

BOOL GFMATRIX::operator == ( CONST GFMATRIX& m ) CONST
{
	return (_11 == m._11 && _12 == m._12 && _13 == m._13 && _14 == m._14 &&
		_21 == m._21 && _22 == m._22 && _23 == m._23 && _24 == m._24 &&
		_31 == m._31 && _32 == m._32 && _33 == m._33 && _34 == m._34 &&
		_41 == m._41 && _42 == m._42 && _43 == m._43 && _44 == m._44) ? true : false;
}

BOOL GFMATRIX::operator != ( CONST GFMATRIX& m ) CONST
{
	return (_11 != m._11 && _12 != m._12 && _13 != m._13 && _14 != m._14 &&
		_21 != m._21 && _22 != m._22 && _23 != m._23 && _24 != m._24 &&
		_31 != m._31 && _32 != m._32 && _33 != m._33 && _34 != m._34 &&
		_41 != m._41 && _42 != m._42 && _43 != m._43 && _44 != m._44) ? true : false;
}*/

#endif // __cplusplus

//================================================================================
//
// Functions
//
//================================================================================

GFMATRIX* GFMatrixAffineTransformation(GFMATRIX *pOut, FLOAT Scaling, CONST GFVECTOR3 *pRotationCenter, CONST GFQUATERNION *pRotation, CONST GFVECTOR3 *pTranslation)
{
	return pOut;
}

GFMATRIX* GFMatrixAffineTransformation2D(GFMATRIX *pOut, FLOAT Scaling, CONST GFVECTOR2 *pRotationCenter, FLOAT Rotation, GFVECTOR2 *pTranslation)
{
	return pOut;
}

BOOL GFMatrixDecompose(GFVECTOR3 *pOutScale, GFQUATERNION *pOutRotation, GFVECTOR3 *pOutTranslation, CONST GFMATRIX *pM)
{
	return FALSE;
}

FLOAT GFMatrixDeterminant(CONST GFMATRIX *pM)
{
	return 0.0f;
}

GFMATRIX* GFMatrixIdentity(GFMATRIX *pOut)
{
	*pOut = GFMATRIX();

	return pOut;
}

GFMATRIX* GFMatrixInverse(GFMATRIX *pOut, FLOAT *pDeterminant, CONST GFMATRIX *pM)
{
	return pOut;
}

BOOL GFMatrixIsIdentity(CONST GFMATRIX *pM)
{
	if ( pM->_11 != 1.0f ) return FALSE;
	if ( pM->_12 != 0.0f ) return FALSE;
	if ( pM->_13 != 0.0f ) return FALSE;
	if ( pM->_14 != 0.0f ) return FALSE;
	if ( pM->_21 != 0.0f ) return FALSE;
	if ( pM->_22 != 1.0f ) return FALSE;
	if ( pM->_23 != 0.0f ) return FALSE;
	if ( pM->_24 != 0.0f ) return FALSE;
	if ( pM->_31 != 0.0f ) return FALSE;
	if ( pM->_32 != 0.0f ) return FALSE;
	if ( pM->_33 != 1.0f ) return FALSE;
	if ( pM->_34 != 0.0f ) return FALSE;
	if ( pM->_41 != 0.0f ) return FALSE;
	if ( pM->_42 != 0.0f ) return FALSE;
	if ( pM->_43 != 0.0f ) return FALSE;
	if ( pM->_44 != 1.0f ) return FALSE;

	return TRUE;
}

GFMATRIX* GFMatrixLookAtLH(GFMATRIX *pOut, CONST GFVECTOR3 *pEye, CONST GFVECTOR3 *pAt, CONST GFVECTOR3 *pUp)
{
	return pOut;
}

GFMATRIX* GFMatrixLookAtRH(GFMATRIX *pOut, CONST GFVECTOR3 *pEye, CONST GFVECTOR3 *pAt, CONST GFVECTOR3 *pUp)
{
	return pOut;
}

GFMATRIX* GFMatrixMultiply(GFMATRIX *pOut, CONST GFMATRIX *pM1, CONST GFMATRIX *pM2)
{
	GFMATRIX m;

	if ( (pM1->_41 == 0.0f) && (pM1->_42 == 0.0f) && (pM1->_43 == 0.0f) && (pM1->_44 == 1.0f) &&
		 (pM2->_41 == 0.0f) && (pM2->_42 == 0.0f) && (pM2->_43 == 0.0f) && (pM2->_44 == 1.0f) )
	{
		m._11 = (pM1->_11 * pM2->_11) + (pM1->_12 * pM2->_21) + (pM1->_13 * pM2->_31) + (pM1->_14 * pM2->_41);
		m._12 = (pM1->_11 * pM2->_12) + (pM1->_12 * pM2->_22) + (pM1->_13 * pM2->_32) + (pM1->_14 * pM2->_42);
		m._13 = (pM1->_11 * pM2->_13) + (pM1->_12 * pM2->_23) + (pM1->_13 * pM2->_33) + (pM1->_14 * pM2->_43);

		m._21 = (pM1->_21 * pM2->_11) + (pM1->_22 * pM2->_21) + (pM1->_23 * pM2->_31) + (pM1->_24 * pM2->_41);
		m._22 = (pM1->_21 * pM2->_12) + (pM1->_22 * pM2->_22) + (pM1->_23 * pM2->_32) + (pM1->_24 * pM2->_42);
		m._23 = (pM1->_21 * pM2->_13) + (pM1->_22 * pM2->_23) + (pM1->_23 * pM2->_33) + (pM1->_24 * pM2->_43);

		m._31 = (pM1->_31 * pM2->_11) + (pM1->_32 * pM2->_21) + (pM1->_33 * pM2->_31) + (pM1->_34 * pM2->_41);
		m._32 = (pM1->_31 * pM2->_12) + (pM1->_32 * pM2->_22) + (pM1->_33 * pM2->_32) + (pM1->_34 * pM2->_42);
		m._33 = (pM1->_31 * pM2->_13) + (pM1->_32 * pM2->_23) + (pM1->_33 * pM2->_33) + (pM1->_34 * pM2->_43);

		m._41 = (pM1->_41 * pM2->_11) + (pM1->_42 * pM2->_21) + (pM1->_43 * pM2->_31) + (pM1->_44 * pM2->_41);
		m._42 = (pM1->_41 * pM2->_12) + (pM1->_42 * pM2->_22) + (pM1->_43 * pM2->_32) + (pM1->_44 * pM2->_42);
		m._43 = (pM1->_41 * pM2->_13) + (pM1->_42 * pM2->_23) + (pM1->_43 * pM2->_33) + (pM1->_44 * pM2->_43);
	}
	else
	{
		m._11 = (pM1->_11 * pM2->_11) + (pM1->_12 * pM2->_21) + (pM1->_13 * pM2->_31) + (pM1->_14 * pM2->_41);
		m._12 = (pM1->_11 * pM2->_12) + (pM1->_12 * pM2->_22) + (pM1->_13 * pM2->_32) + (pM1->_14 * pM2->_42);
		m._13 = (pM1->_11 * pM2->_13) + (pM1->_12 * pM2->_23) + (pM1->_13 * pM2->_33) + (pM1->_14 * pM2->_43);
		m._14 = (pM1->_11 * pM2->_14) + (pM1->_12 * pM2->_24) + (pM1->_13 * pM2->_34) + (pM1->_14 * pM2->_44);

		m._21 = (pM1->_21 * pM2->_11) + (pM1->_22 * pM2->_21) + (pM1->_23 * pM2->_31) + (pM1->_24 * pM2->_41);
		m._22 = (pM1->_21 * pM2->_12) + (pM1->_22 * pM2->_22) + (pM1->_23 * pM2->_32) + (pM1->_24 * pM2->_42);
		m._23 = (pM1->_21 * pM2->_13) + (pM1->_22 * pM2->_23) + (pM1->_23 * pM2->_33) + (pM1->_24 * pM2->_43);
		m._24 = (pM1->_21 * pM2->_14) + (pM1->_22 * pM2->_24) + (pM1->_23 * pM2->_34) + (pM1->_24 * pM2->_44);

		m._31 = (pM1->_31 * pM2->_11) + (pM1->_32 * pM2->_21) + (pM1->_33 * pM2->_31) + (pM1->_34 * pM2->_41);
		m._32 = (pM1->_31 * pM2->_12) + (pM1->_32 * pM2->_22) + (pM1->_33 * pM2->_32) + (pM1->_34 * pM2->_42);
		m._33 = (pM1->_31 * pM2->_13) + (pM1->_32 * pM2->_23) + (pM1->_33 * pM2->_33) + (pM1->_34 * pM2->_43);
		m._34 = (pM1->_31 * pM2->_14) + (pM1->_32 * pM2->_24) + (pM1->_33 * pM2->_34) + (pM1->_34 * pM2->_44);

		m._41 = (pM1->_41 * pM2->_11) + (pM1->_42 * pM2->_21) + (pM1->_43 * pM2->_31) + (pM1->_44 * pM2->_41);
		m._42 = (pM1->_41 * pM2->_12) + (pM1->_42 * pM2->_22) + (pM1->_43 * pM2->_32) + (pM1->_44 * pM2->_42);
		m._43 = (pM1->_41 * pM2->_13) + (pM1->_42 * pM2->_23) + (pM1->_43 * pM2->_33) + (pM1->_44 * pM2->_43);
		m._44 = (pM1->_41 * pM2->_14) + (pM1->_42 * pM2->_24) + (pM1->_43 * pM2->_34) + (pM1->_44 * pM2->_44);
	}

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixMultiplyTranspose(GFMATRIX *pOut, CONST GFMATRIX *pM1, CONST GFMATRIX *pM2)
{
	return pOut;
}

GFMATRIX* GFMatrixOrthoLH(GFMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf )
{
	GFMATRIX m;

	m._11 = 2 / w;
	m._22 = 2 / h;
	m._33 = 1 / (zf - zn);
	m._43 = zn / (zn - zf);

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixOrthoOffCenterLH(GFMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = 2 / (r - l);
	m._22 = 2 / (t - b);
	m._33 = 1 / (zf - zn);
	m._41 = (l + r) / (l - r);
	m._42 = (t + b) / (b - t);
	m._43 = zn / (zn - zf);

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixOrthoOffCenterRH(GFMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = 2 / (r - l);
	m._22 = 2 / (t - b);
	m._33 = 1 / (zn - zf);
	m._41 = (l + r) / (l - r);
	m._42 = (t + b) / (b - t);
	m._43 = zn / (zn - zf);

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixOrthoRH(GFMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = 2 / w;
	m._22 = 2 / h;
	m._33 = 1 / (zn - zf);
	m._43 = zn / (zn - zf);

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixPerspectiveFovLH(GFMATRIX *pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = cot(fovy / 2);
	m._22 = cot(fovy / 2) / Aspect;
	m._33 = zf / (zf - zn);
	m._34 = 1.0f;
	m._43 = -zn * zf / (zf - zn);
	m._44 = 0.0f;

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixPerspectiveFovRH(GFMATRIX *pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = cot(fovy / 2);
	m._22 = cot(fovy / 2) / Aspect;
	m._33 = zf / (zn - zf);
	m._34 = -1.0f;
	m._43 = zn * zf / (zn - zf);
	m._44 = 0.0f;

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixPerspectiveLH(GFMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = 2 * zn / w;
	m._22 = 2 * zn / h;
	m._33 = zf / (zf - zn);
	m._34 = 1.0f;
	m._43 = zn * zf / (zn - zf);
	m._44 = 0.0f;

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixPerspectiveOffCenterLH(GFMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = 2 * zn / (r - l);
	m._22 = 2 * zn / (t - b);
	m._33 = 1 / (zn - zf);
	m._31 = (l + r) / (l - r);
	m._32 = (t + b) / (b - t);
	m._33 = zn / (zf - zn);
	m._34 = 1.0f;
	m._43 = zn * zf / (zn - zf);
	m._44 = 0.0f;

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixPerspectiveOffCenterRH(GFMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = 2 * zn / (r - l);
	m._22 = 2 * zn / (t - b);
	m._33 = 1 / (zn - zf);
	m._31 = (l + r) / (l - r);
	m._32 = (t + b) / (b - t);
	m._33 = zn / (zn - zf);
	m._34 = -1.0f;
	m._43 = zn * zf / (zn - zf);
	m._44 = 0.0f;

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixPerspectiveRH(GFMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf)
{
	GFMATRIX m;

	m._11 = 2 * zn / w;
	m._22 = 2 * zn / h;
	m._33 = zf / (zn - zf);
	m._34 = -1.0f;
	m._43 = zn * zf / (zn - zf);
	m._44 = 0.0f;

	*pOut = m;

	return pOut;
}

GFMATRIX* GFMatrixReflect(GFMATRIX *pOut, CONST GFPLANE *pPlane)
{
	return pOut;
}

GFMATRIX* GFMatrixRotationAxis(GFMATRIX *pOut, CONST GFVECTOR3 *pV, FLOAT Angle)
{
	return pOut;
}

GFMATRIX* GFMatrixRotationQuaternion(GFMATRIX *pOut, CONST GFQUATERNION *pQ)
{
	return pOut;
}

GFMATRIX* GFMatrixRotationX(GFMATRIX *pOut, FLOAT Angle)
{
	return pOut;
}

GFMATRIX* GFMatrixRotationY(GFMATRIX *pOut, FLOAT Angle)
{
	return pOut;
}

GFMATRIX* GFMatrixRotationYawPitchRoll(GFMATRIX *pOut, FLOAT Yaw, FLOAT Pitch, FLOAT Roll)
{
	return pOut;
}

GFMATRIX* GFMatrixRotationZ(GFMATRIX *pOut, FLOAT Angle)
{
	return pOut;
}

GFMATRIX* GFMatrixScaling(GFMATRIX *pOut, FLOAT sx, FLOAT sy, FLOAT sz)
{
	pOut->_11 *= sx;
	pOut->_22 *= sy;
	pOut->_33 *= sz;

	return pOut;
}

GFMATRIX* GFMatrixShadow(GFMATRIX *pOut, CONST GFVECTOR4 *pLight, CONST GFPLANE *pPlane)
{
	return pOut;
}

GFMATRIX* GFMatrixTransformation(GFMATRIX *pOut, CONST GFVECTOR3 *pScalingCenter, CONST GFQUATERNION *pScalingRotation, CONST GFVECTOR3 *pScaling, CONST GFVECTOR3 *pRotationCenter, CONST GFQUATERNION *pRotation, CONST GFVECTOR3 *pTranslation)
{
	return pOut;
}

GFMATRIX* GFMatrixTransformation2D(GFMATRIX *pOut, CONST GFVECTOR2* pScalingCenter, FLOAT ScalingRotation, CONST GFVECTOR2* pScaling, CONST GFVECTOR2* pRotationCenter, FLOAT Rotation, CONST GFVECTOR2* pTranslation)
{
	return pOut;
}

GFMATRIX* GFMatrixTranslation(GFMATRIX *pOut, FLOAT x, FLOAT y, FLOAT z)
{
	pOut->_41 += x;
	pOut->_42 += y;
	pOut->_43 += z;

	return pOut;
}

GFMATRIX* GFMatrixTranspose(GFMATRIX *pOut, CONST GFMATRIX *pM)
{
	GFMATRIX m;

	m._11 = pM->_11; m._12 = pM->_21; m._13 = pM->_31; m._14 = pM->_41;
	m._21 = pM->_12; m._22 = pM->_22; m._23 = pM->_32; m._24 = pM->_42;
	m._31 = pM->_13; m._32 = pM->_23; m._33 = pM->_33; m._34 = pM->_43;
	m._41 = pM->_14; m._42 = pM->_24; m._43 = pM->_34; m._44 = pM->_44;

	*pOut = m;

	return pOut;
}