
#ifndef _CG_VECTOR3_H
#define _CG_VECTOR3_H

#include "cgMatrix.h"
#include "cgVector4.h"
#include "cgViewport.h"

namespace gravity
{

	class cgVector3
	{
	public:
		float x, y, z;

		cgVector3();
		cgVector3( const float * );
		cgVector3( float x, float y, float z );

		operator float* ();
		operator const float* () const;

		cgVector3& operator += ( const cgVector3& );
		cgVector3& operator -= ( const cgVector3& );
		cgVector3& operator *= ( float );
		cgVector3& operator /= ( float );

		cgVector3 operator + () const;
		cgVector3 operator - () const;

		cgVector3 operator + ( const cgVector3& ) const;
		cgVector3 operator - ( const cgVector3& ) const;
		cgVector3 operator * ( float ) const;
		cgVector3 operator / ( float ) const;

		friend cgVector3 operator * ( float, const cgVector3& );

		bool operator == ( const cgVector3& ) const;
		bool operator != ( const cgVector3& ) const;

		void	add					( const cgVector3 *v );
		void	baryCentric			( const cgVector3 *v1, const cgVector3 *v2, float f, float g );
		void	catmullRom			( const cgVector3 *v1, const cgVector3 *v2, const cgVector3 *v3, float s );
		void	cross				( const cgVector3 *v );
		float	dot					( const cgVector3 *v );
		void	hermite				( const cgVector3 *v1, const cgVector3 *v2, const cgVector3 *v3, float s );
		float	lenght				(  );
		float	lenghtSqr			(  );
		void	lerp				( const cgVector3 *v, float s );
		void	maximize			( const cgVector3 *v );
		void	minimize			( const cgVector3 *v );
		void	normalize			(  );
		void	project				( const cgViewport *pViewport, const cgMatrix *pProjection, const cgMatrix *pView, const cgMatrix *pWorld );
		void	scale				( float s );
		void	subtract			( const cgVector3 *v );
		cgVector4*	transform		( const cgMatrix *m );
		void	transformCoord		( const cgMatrix *m );
		void	transformNormal		( const cgMatrix *m );
		void	unproject			( const cgViewport *pViewport, const cgMatrix *pProjection, const cgMatrix *pView, const cgMatrix *pWorld );
	};

}

#endif // _CG_VECTOR3_H