
#include "cgMath.h"

namespace gravity
{

	cgMatrix::cgMatrix()
	{
		m11 = 1.0f; m12 = 0.0f; m13 = 0.0f; m14 = 0.0f;
		m21 = 0.0f; m22 = 1.0f; m23 = 0.0f; m24 = 0.0f;
		m31 = 0.0f; m32 = 0.0f; m33 = 1.0f; m34 = 0.0f;
		m41 = 0.0f; m42 = 0.0f; m43 = 0.0f; m44 = 1.0f;
	}

	cgMatrix::cgMatrix( const float * f )
	{
		m11 = (*f);
		m12 = (*f) + 0x1;
		m13 = (*f) + 0x2;
		m14 = (*f) + 0x3;
		m21 = (*f) + 0x4;
		m22 = (*f) + 0x5;
		m23 = (*f) + 0x6;
		m24 = (*f) + 0x7;
		m31 = (*f) + 0x8;
		m32 = (*f) + 0x9;
		m33 = (*f) + 0xa;
		m34 = (*f) + 0xb;
		m41 = (*f) + 0xc;
		m42 = (*f) + 0xd;
		m43 = (*f) + 0xe;
		m44 = (*f) + 0xf;
	}

	cgMatrix::cgMatrix( float m11, float m12, float m13, float m14,
		float m21, float m22, float m23, float m24,
		float m31, float m32, float m33, float m34,
		float m41, float m42, float m43, float m44 )
	{
		this->m11 = m11;
		this->m12 = m12;
		this->m13 = m13;
		this->m14 = m14;
		this->m21 = m21;
		this->m22 = m22;
		this->m23 = m23;
		this->m24 = m24;
		this->m31 = m31;
		this->m32 = m32;
		this->m33 = m33;
		this->m34 = m34;
		this->m41 = m41;
		this->m42 = m42;
		this->m43 = m43;
		this->m44 = m44;
	}

	cgMatrix::operator float* ()
	{
		return (float*) this;
	}

	cgMatrix::operator const float* () const
	{
		return (const float*) this;
	}

	void cgMatrix::operator = ( const cgMatrix& m )
	{
		m11 = m.m11; m12 = m.m12; m13 = m.m13; m14 = m.m14;
		m21 = m.m21; m22 = m.m22; m23 = m.m23; m24 = m.m24;
		m31 = m.m31; m32 = m.m32; m33 = m.m33; m34 = m.m34;
		m41 = m.m41; m42 = m.m42; m43 = m.m43; m44 = m.m44;
	}

	void cgMatrix::operator = ( float s )
	{
		m11 = s; m12 = s; m13 = s; m14 = s;
		m21 = s; m22 = s; m23 = s; m24 = s;
		m31 = s; m32 = s; m33 = s; m34 = s;
		m41 = s; m42 = s; m43 = s; m44 = s;
	}

	cgMatrix& cgMatrix::operator += ( const cgMatrix& m )
	{
		(*this) = (*this) + m;
		return (*this);
	}

	cgMatrix& cgMatrix::operator -= ( const cgMatrix& m )
	{
		(*this) = (*this) - m;
		return (*this);
	}

	cgMatrix& cgMatrix::operator *= ( const cgMatrix& m )
	{
		(*this) = (*this) * m;
		return (*this);
	}

	cgMatrix& cgMatrix::operator *= ( float s )
	{
		(*this) = (*this) * s;
		return (*this);
	}

	cgMatrix& cgMatrix::operator /= ( float s )
	{
		if ( s == 0.0f )
		{
			(*this) = 0.0f;
			return (*this);
		}

		(*this) = (*this) / s;
		return (*this);
	}

	cgMatrix cgMatrix::operator + () const
	{
		return cgMatrix(
			m11, m12, m13, m14,
			m21, m22, m23, m24,
			m31, m32, m33, m34,
			m41, m42, m43, m44);
	}

	cgMatrix cgMatrix::operator - () const
	{
		return cgMatrix(
			-m11, -m12, -m13, -m14,
			-m21, -m22, -m23, -m24,
			-m31, -m32, -m33, -m34,
			-m41, -m42, -m43, -m44);
	}

	cgMatrix cgMatrix::operator + ( const cgMatrix& m ) const
	{
		return cgMatrix(
			m11 + m.m11, m12 + m.m12, m13 + m.m13, m14 + m.m14,
			m21 + m.m21, m22 + m.m22, m23 + m.m23, m24 + m.m24,
			m31 + m.m31, m32 + m.m32, m33 + m.m33, m34 + m.m34,
			m41 + m.m41, m42 + m.m42, m43 + m.m43, m44 + m.m44);
	}

	cgMatrix cgMatrix::operator - ( const cgMatrix& m ) const
	{
		return cgMatrix(
			m11 - m.m11, m12 - m.m12, m13 - m.m13, m14 - m.m14,
			m21 - m.m21, m22 - m.m22, m23 - m.m23, m24 - m.m24,
			m31 - m.m31, m32 - m.m32, m33 - m.m33, m34 - m.m34,
			m41 - m.m41, m42 - m.m42, m43 - m.m43, m44 - m.m44);
	}

	cgMatrix cgMatrix::operator * ( const cgMatrix& m ) const
	{
		if ( (m41 == m42 == m43 == 0.0f) && (m44 == 1.0f) && (m.m41 == m.m42 == m.m43 == 0.0f) && (m.m44 == 1.0f) )
		{
			return cgMatrix(
				(m11 * m.m11) + (m12 * m.m21) + (m13 * m.m31) + (m14 * m.m41),
				(m11 * m.m12) + (m12 * m.m22) + (m13 * m.m32) + (m14 * m.m42),
				(m11 * m.m13) + (m12 * m.m23) + (m13 * m.m33) + (m14 * m.m43),
				0.0f,

				(m21 * m.m11) + (m22 * m.m21) + (m23 * m.m31) + (m24 * m.m41),
				(m21 * m.m12) + (m22 * m.m22) + (m23 * m.m32) + (m24 * m.m42),
				(m21 * m.m13) + (m22 * m.m23) + (m23 * m.m33) + (m24 * m.m43),
				0.0f,

				(m31 * m.m11) + (m32 * m.m21) + (m33 * m.m31) + (m34 * m.m41),
				(m31 * m.m12) + (m32 * m.m22) + (m33 * m.m32) + (m34 * m.m42),
				(m31 * m.m13) + (m32 * m.m23) + (m33 * m.m33) + (m34 * m.m43),
				0.0f,

				(m41 * m.m11) + (m42 * m.m21) + (m43 * m.m31) + (m44 * m.m41),
				(m41 * m.m12) + (m42 * m.m22) + (m43 * m.m32) + (m44 * m.m42),
				(m41 * m.m13) + (m42 * m.m23) + (m43 * m.m33) + (m44 * m.m43),
				1.0f);
		}
		else
		{
			return cgMatrix(
				(m11 * m.m11) + (m12 * m.m21) + (m13 * m.m31) + (m14 * m.m41),
				(m11 * m.m12) + (m12 * m.m22) + (m13 * m.m32) + (m14 * m.m42),
				(m11 * m.m13) + (m12 * m.m23) + (m13 * m.m33) + (m14 * m.m43),
				(m11 * m.m14) + (m12 * m.m24) + (m13 * m.m34) + (m14 * m.m44),

				(m21 * m.m11) + (m22 * m.m21) + (m23 * m.m31) + (m24 * m.m41),
				(m21 * m.m12) + (m22 * m.m22) + (m23 * m.m32) + (m24 * m.m42),
				(m21 * m.m13) + (m22 * m.m23) + (m23 * m.m33) + (m24 * m.m43),
				(m21 * m.m14) + (m22 * m.m24) + (m23 * m.m34) + (m24 * m.m44),

				(m31 * m.m11) + (m32 * m.m21) + (m33 * m.m31) + (m34 * m.m41),
				(m31 * m.m12) + (m32 * m.m22) + (m33 * m.m32) + (m34 * m.m42),
				(m31 * m.m13) + (m32 * m.m23) + (m33 * m.m33) + (m34 * m.m43),
				(m31 * m.m14) + (m32 * m.m24) + (m33 * m.m34) + (m34 * m.m44),

				(m41 * m.m11) + (m42 * m.m21) + (m43 * m.m31) + (m44 * m.m41),
				(m41 * m.m12) + (m42 * m.m22) + (m43 * m.m32) + (m44 * m.m42),
				(m41 * m.m13) + (m42 * m.m23) + (m43 * m.m33) + (m44 * m.m43),
				(m41 * m.m14) + (m42 * m.m24) + (m43 * m.m34) + (m44 * m.m44));
		}
	}

	cgMatrix cgMatrix::operator * ( float s ) const
	{
		if ( s == 0.0f )
		{
			return cgMatrix();
		}

		return cgMatrix(
			m11 * s, m12 * s, m13 * s, m14 * s,
			m21 * s, m22 * s, m23 * s, m24 * s,
			m31 * s, m32 * s, m33 * s, m34 * s,
			m41 * s, m42 * s, m43 * s, m44 * s);	
	}

	cgMatrix cgMatrix::operator / ( float s ) const
	{
		if ( s == 0.0f )
		{
			return cgMatrix();
		}

		return cgMatrix(
			m11 / s, m12 / s, m13 / s, m14 / s,
			m21 / s, m22 / s, m23 / s, m24 / s,
			m31 / s, m32 / s, m33 / s, m34 / s,
			m41 / s, m42 / s, m43 / s, m44 / s);
	}

	cgMatrix operator * ( float s, const cgMatrix& m )
	{
		return m * s;
	}

	bool cgMatrix::operator == ( const cgMatrix& m ) const
	{
		return (m11 == m.m11 && m12 == m.m12 && m13 == m.m13 && m14 == m.m14 &&
			m21 == m.m21 && m22 == m.m22 && m23 == m.m23 && m24 == m.m24 &&
			m31 == m.m31 && m32 == m.m32 && m33 == m.m33 && m34 == m.m34 &&
			m41 == m.m41 && m42 == m.m42 && m43 == m.m43 && m44 == m.m44) ? true : false;
	}

	bool cgMatrix::operator != ( const cgMatrix& m ) const
	{
		return (m11 != m.m11 && m12 != m.m12 && m13 != m.m13 && m14 != m.m14 &&
			m21 != m.m21 && m22 != m.m22 && m23 != m.m23 && m24 != m.m24 &&
			m31 != m.m31 && m32 != m.m32 && m33 != m.m33 && m34 != m.m34 &&
			m41 != m.m41 && m42 != m.m42 && m43 != m.m43 && m44 != m.m44) ? true : false;
	}

	void cgMatrix::affineTransformation(float scaling, const cgVector3 *rotationCenter, const cgQuaternion *rotation, const cgVector3 *translation)
	{

	}

	void cgMatrix::affineTransformation2D(float scaling, const cgVector2 *rotationCenter, float rotation, cgVector2 *translation)
	{

	}

	bool cgMatrix::decompose(cgVector3 *pOutScale, cgQuaternion *pOutRotation, cgVector3 *pOutTranslation)
	{
		return true;
	}

	float cgMatrix::determinant()
	{
		float det;

		det =
			m11 * ( m22 * ( m33 * m44 - m34 * m43 ) - m23 * ( m32 * m44 - m34 * m42 ) + m24 * ( m32 * m43 - m33 * m42 ) ) -
			m12 * ( m21 * ( m33 * m44 - m34 * m43 ) - m23 * ( m31 * m44 - m34 * m41 ) + m24 * ( m31 * m43 - m33 * m41 ) ) +
			m13 * ( m21 * ( m32 * m44 - m34 * m42 ) - m22 * ( m31 * m44 - m34 * m41 ) + m24 * ( m31 * m42 - m32 * m41 ) ) -
			m14 * ( m21 * ( m32 * m43 - m33 * m42 ) - m22 * ( m31 * m43 - m33 * m41 ) + m23 * ( m31 * m42 - m32 * m41 ) );

		return det;
	}

	void cgMatrix::identity()
	{
		m11 = 1.0f; m12 = 0.0f; m13 = 0.0f; m14 = 0.0f;
		m21 = 0.0f; m22 = 1.0f; m23 = 0.0f; m24 = 0.0f;
		m31 = 0.0f; m32 = 0.0f; m33 = 1.0f; m34 = 0.0f;
		m41 = 0.0f; m42 = 0.0f; m43 = 0.0f; m44 = 1.0f;
	}

	void cgMatrix::inverse()
	{
		float det = 1/determinant();

		m11 = m23*m34*m42 - m24*m33*m42 + m24*m32*m43 - m22*m34*m43 - m23*m32*m44 + m22*m33*m44;
		m12 = m14*m33*m42 - m13*m34*m42 - m14*m32*m43 + m12*m34*m43 + m13*m32*m44 - m12*m33*m44;
		m13 = m13*m24*m42 - m14*m23*m42 + m14*m22*m43 - m12*m24*m43 - m13*m22*m44 + m12*m23*m44;
		m14 = m14*m23*m32 - m13*m24*m32 - m14*m22*m33 + m12*m24*m33 + m13*m22*m34 - m12*m23*m34;
		m21 = m24*m33*m41 - m23*m34*m41 - m24*m31*m43 + m21*m34*m43 + m23*m31*m44 - m21*m33*m44;
		m22 = m13*m34*m41 - m14*m33*m41 + m14*m31*m43 - m11*m34*m43 - m13*m31*m44 + m11*m33*m44;
		m23 = m14*m23*m41 - m13*m24*m41 - m14*m21*m43 + m11*m24*m43 + m13*m21*m44 - m11*m23*m44;
		m24 = m13*m24*m31 - m14*m23*m31 + m14*m21*m33 - m11*m24*m33 - m13*m21*m34 + m11*m23*m34;
		m31 = m22*m34*m41 - m24*m32*m41 + m24*m31*m42 - m21*m34*m42 - m22*m31*m44 + m21*m32*m44;
		m32 = m14*m32*m41 - m12*m34*m41 - m14*m31*m42 + m11*m34*m42 + m12*m31*m44 - m11*m32*m44;
		m33 = m12*m24*m41 - m14*m22*m41 + m14*m21*m42 - m11*m24*m42 - m12*m21*m44 + m11*m22*m44;
		m34 = m14*m22*m31 - m12*m24*m31 - m14*m21*m32 + m11*m24*m32 + m12*m21*m34 - m11*m22*m34;
		m41 = m23*m32*m41 - m22*m33*m41 - m23*m31*m42 + m21*m33*m42 + m22*m31*m43 - m21*m32*m43;
		m42 = m12*m33*m41 - m13*m32*m41 + m13*m31*m42 - m11*m33*m42 - m12*m31*m43 + m11*m32*m43;
		m43 = m13*m22*m41 - m12*m23*m41 - m13*m21*m42 + m11*m23*m42 + m12*m21*m43 - m11*m22*m43;
		m44 = m12*m23*m31 - m13*m22*m31 + m13*m21*m32 - m11*m23*m32 - m12*m21*m33 + m11*m22*m33;

		cgMatrix mat;

		mat.m11 = det;
		mat.m22 = det;
		mat.m33 = det;

		multiply(&mat);

		//transpose();
	}

	bool cgMatrix::isIdentity()
	{
		if ( m11 != 1.0f ) return false;
		if ( m12 != 0.0f ) return false;
		if ( m13 != 0.0f ) return false;
		if ( m14 != 0.0f ) return false;
		if ( m21 != 0.0f ) return false;
		if ( m22 != 1.0f ) return false;
		if ( m23 != 0.0f ) return false;
		if ( m24 != 0.0f ) return false;
		if ( m31 != 0.0f ) return false;
		if ( m32 != 0.0f ) return false;
		if ( m33 != 1.0f ) return false;
		if ( m34 != 0.0f ) return false;
		if ( m41 != 0.0f ) return false;
		if ( m42 != 0.0f ) return false;
		if ( m43 != 0.0f ) return false;
		if ( m44 != 1.0f ) return false;

		return true;
	}

	void cgMatrix::lookAtLH(const cgVector3 *eye, const cgVector3 *center, const cgVector3 *up)
	{

	}

	void cgMatrix::lookAtRH(const cgVector3 *eye, const cgVector3 *center, const cgVector3 *up)
	{

	}

	void cgMatrix::multiply(const cgMatrix *m)
	{
		if ( (m41 == 0.0f) && (m42 == 0.0f) && (m43 == 0.0f) && (m44 == 1.0f) &&
			 (m->m41 == 0.0f) && (m->m42 == 0.0f) && (m->m43 == 0.0f) && (m->m44 == 1.0f) )
		{
			m11 = (m11 * m->m11) + (m12 * m->m21) + (m13 * m->m31) + (m14 * m->m41);
			m12 = (m11 * m->m12) + (m12 * m->m22) + (m13 * m->m32) + (m14 * m->m42);
			m13 = (m11 * m->m13) + (m12 * m->m23) + (m13 * m->m33) + (m14 * m->m43);
			m14 = 0.0f;

			m21 = (m21 * m->m11) + (m22 * m->m21) + (m23 * m->m31) + (m24 * m->m41);
			m22 = (m21 * m->m12) + (m22 * m->m22) + (m23 * m->m32) + (m24 * m->m42);
			m23 = (m21 * m->m13) + (m22 * m->m23) + (m23 * m->m33) + (m24 * m->m43);
			m24 = 0.0f;

			m31 = (m31 * m->m11) + (m32 * m->m21) + (m33 * m->m31) + (m34 * m->m41);
			m32 = (m31 * m->m12) + (m32 * m->m22) + (m33 * m->m32) + (m34 * m->m42);
			m33 = (m31 * m->m13) + (m32 * m->m23) + (m33 * m->m33) + (m34 * m->m43);
			m34 = 0.0f;

			m41 = (m41 * m->m11) + (m42 * m->m21) + (m43 * m->m31) + (m44 * m->m41);
			m42 = (m41 * m->m12) + (m42 * m->m22) + (m43 * m->m32) + (m44 * m->m42);
			m43 = (m41 * m->m13) + (m42 * m->m23) + (m43 * m->m33) + (m44 * m->m43);
			m44 = 0.0f;
		}
		else
		{
			m11 = (m11 * m->m11) + (m12 * m->m21) + (m13 * m->m31) + (m14 * m->m41);
			m12 = (m11 * m->m12) + (m12 * m->m22) + (m13 * m->m32) + (m14 * m->m42);
			m13 = (m11 * m->m13) + (m12 * m->m23) + (m13 * m->m33) + (m14 * m->m43);
			m14 = (m11 * m->m14) + (m12 * m->m24) + (m13 * m->m34) + (m14 * m->m44);

			m21 = (m21 * m->m11) + (m22 * m->m21) + (m23 * m->m31) + (m24 * m->m41);
			m22 = (m21 * m->m12) + (m22 * m->m22) + (m23 * m->m32) + (m24 * m->m42);
			m23 = (m21 * m->m13) + (m22 * m->m23) + (m23 * m->m33) + (m24 * m->m43);
			m24 = (m21 * m->m14) + (m22 * m->m24) + (m23 * m->m34) + (m24 * m->m44);

			m31 = (m31 * m->m11) + (m32 * m->m21) + (m33 * m->m31) + (m34 * m->m41);
			m32 = (m31 * m->m12) + (m32 * m->m22) + (m33 * m->m32) + (m34 * m->m42);
			m33 = (m31 * m->m13) + (m32 * m->m23) + (m33 * m->m33) + (m34 * m->m43);
			m34 = (m31 * m->m14) + (m32 * m->m24) + (m33 * m->m34) + (m34 * m->m44);

			m41 = (m41 * m->m11) + (m42 * m->m21) + (m43 * m->m31) + (m44 * m->m41);
			m42 = (m41 * m->m12) + (m42 * m->m22) + (m43 * m->m32) + (m44 * m->m42);
			m43 = (m41 * m->m13) + (m42 * m->m23) + (m43 * m->m33) + (m44 * m->m43);
			m44 = (m41 * m->m14) + (m42 * m->m24) + (m43 * m->m34) + (m44 * m->m44);
		}
	}

	void cgMatrix::multiplyTranspose(const cgMatrix *m)
	{

	}

	void cgMatrix::orthoLH(float w, float h, float zn, float zf)
	{
		identity();

		m11 = 2 / w;
		m22 = 2 / h;
		m33 = 1 / (zf - zn);
		m43 = zn / (zn - zf);
	}

	void cgMatrix::orthoOffCenterLH(float l, float r, float b, float t, float zn, float zf)
	{
		identity();

		m11 = 2 / (r - l);
		m22 = 2 / (t - b);
		m33 = 1 / (zf - zn);
		m41 = (l + r) / (l - r);
		m42 = (t + b) / (b - t);
		m43 = zn / (zn - zf);
	}

	void cgMatrix::orthoOffCenterRH(float l, float r, float b, float t, float zn, float zf)
	{
		identity();

		m11 = 2 / (r - l);
		m22 = 2 / (t - b);
		m33 = 1 / (zn - zf);
		m41 = (l + r) / (l - r);
		m42 = (t + b) / (b - t);
		m43 = zn / (zn - zf);
	}

	void cgMatrix::orthoRH(float w, float h, float zn, float zf)
	{
		identity();

		m11 = 2 / w;
		m22 = 2 / h;
		m33 = 1 / (zn - zf);
		m43 = zn / (zn - zf);
	}

	void cgMatrix::perspectiveFovLH(float fovy, float aspect, float zn, float zf)
	{
		identity();

		m11 = cot(fovy / 2);
		m22 = cot(fovy / 2) / aspect;
		m33 = zf / (zf - zn);
		m34 = 1.0f;
		m43 = -zn * zf / (zf - zn);
		m44 = 0.0f;
	}

	void cgMatrix::perspectiveFovRH(float fovy, float aspect, float zn, float zf)
	{
		identity();

		m11 = cot(fovy / 2);
		m22 = cot(fovy / 2) / aspect;
		m33 = zf / (zn - zf);
		m34 = -1.0f;
		m43 = zn * zf / (zn - zf);
		m44 = 0.0f;
	}

	void cgMatrix::perspectiveLH(float w, float h, float zn, float zf)
	{
		identity();

		m11 = 2 * zn / w;
		m22 = 2 * zn / h;
		m33 = zf / (zf - zn);
		m34 = 1.0f;
		m43 = zn * zf / (zn - zf);
		m44 = 0.0f;
	}

	void cgMatrix::perspectiveOffCenterLH(float l, float r, float b, float t, float zn, float zf)
	{
		identity();

		m11 = 2 * zn / (r - l);
		m22 = 2 * zn / (t - b);
		m33 = 1 / (zn - zf);
		m31 = (l + r) / (l - r);
		m32 = (t + b) / (b - t);
		m33 = zn / (zf - zn);
		m34 = 1.0f;
		m43 = zn * zf / (zn - zf);
		m44 = 0.0f;
	}

	void cgMatrix::perspectiveOffCenterRH(float l, float r, float b, float t, float zn, float zf)
	{
		identity();

		m11 = 2 * zn / (r - l);
		m22 = 2 * zn / (t - b);
		m33 = 1 / (zn - zf);
		m31 = (l + r) / (l - r);
		m32 = (t + b) / (b - t);
		m33 = zn / (zn - zf);
		m34 = -1.0f;
		m43 = zn * zf / (zn - zf);
		m44 = 0.0f;
	}

	void cgMatrix::perspectiveRH(float w, float h, float zn, float zf)
	{
		identity();

		m11 = 2 * zn / w;
		m22 = 2 * zn / h;
		m33 = zf / (zn - zf);
		m34 = -1.0f;
		m43 = zn * zf / (zn - zf);
		m44 = 0.0f;
	}

	void cgMatrix::reflect(const cgPlane *p)
	{

	}

	void cgMatrix::rotationAxis(const cgVector3 *v, float angle)
	{

	}

	void cgMatrix::rotationQuaternion(const cgQuaternion *q)
	{

	}

	void cgMatrix::rotationX(float angle)
	{
		cgMatrix	rotation;

		rotation.m22 = cos(angle);
		rotation.m23 = -sin(angle);
		rotation.m32 = sin(angle);
		rotation.m33 = cos(angle);

		(*this) = (*this) * rotation;
	}

	void cgMatrix::rotationY(float angle)
	{
		cgMatrix	rotation;

		rotation.m11 = cos(angle);
		rotation.m13 = sin(angle);
		rotation.m31 = -sin(angle);
		rotation.m33 = cos(angle);

		(*this) = (*this) * rotation;
	}

	void cgMatrix::rotationYawPitchRoll(float yaw, float pitch, float roll)
	{
		cgMatrix	rotation;

		float cp = cos(pitch);
		float sp = sin(pitch);
		float cy = cos(yaw);
		float sy = sin(yaw);
		float cr = cos(roll);
		float sr = sin(roll);

		float cpsy = cp * sy;
		float spsy = sp * sy;

		m11 =  cy * cr;
		m12 = -cy * sr;
		m13 =  sy;
		m14 =  0;

		m21 =  spsy * cr + cp * sr;
		m22 = -spsy * sr + cp * cr;
		m23 = -sp * cy;
		m24 =  0;

		m31 = -cpsy * cr + sp * sr;
		m32 =  cpsy * sr + sp * cr;
		m33 =  cp * cy;
		m34 =  0;

		m41 = 0;
		m42 = 0;
		m43 = 0;
		m44 = 1;

		(*this) = (*this) * rotation;
	}

	void cgMatrix::rotationZ(float angle)
	{
		cgMatrix	rotation;

		rotation.m11 = cos(angle);
		rotation.m12 = -sin(angle);
		rotation.m21 = sin(angle);
		rotation.m22 = cos(angle);

		(*this) = (*this) * rotation;
	}

	void cgMatrix::scaling(float sx, float sy, float sz)
	{
		cgMatrix	scale;

		scale.m11 = sx;
		scale.m22 = sy;
		scale.m33 = sz;

		multiply(&scale);
	}

	void cgMatrix::shadow(const cgVector4 *light, const cgPlane *p)
	{

	}

	void cgMatrix::transformation(const cgVector3 *scalingCenter, const cgQuaternion *scalingRotation, const cgVector3 *scaling, const cgVector3 *rotationCenter, const cgQuaternion *rotation, const cgVector3 *translation)
	{

	}

	void cgMatrix::transformation2D(const cgVector2 *scalingCenter, float scalingRotation, const cgVector2* scaling, const cgVector2* rotationCenter, float rotation, const cgVector2* translation)
	{

	}

	void cgMatrix::translation(float x, float y, float z)
	{
		cgMatrix	translate;

		translate.m41 = x;
		translate.m42 = y;
		translate.m43 = z;

		(*this) = (*this) * translate;
	}

	void cgMatrix::transpose()
	{
		cgMatrix tmp;

		tmp.m11 = m11; tmp.m12 = m21; tmp.m13 = m31; tmp.m14 = m41;
		tmp.m21 = m12; tmp.m22 = m22; tmp.m23 = m32; tmp.m24 = m42;
		tmp.m31 = m13; tmp.m32 = m23; tmp.m33 = m33; tmp.m34 = m43;
		tmp.m41 = m14; tmp.m42 = m24; tmp.m43 = m34; tmp.m44 = m44;

		*this = tmp;
	}


}