
#ifndef _F_MENU_H
#define _F_MENU_H

#include "engine/text.h"

#define MENU_MAIN		0
#define MENU_NEW		1
#define MENU_HOWTOPLAY	2
#define MENU_CREDITS	3
#define MENU_EXIT		99

namespace fingers
{

	class fMenu
	{
	private:
		HDC	hDC;

		text_c	fontTitle;
		text_c	fontItem;

	protected:
		void	renderBack(int x, int y, int w, int h);
		void	renderPoint(int x, int y);

		void	printTitle(int x, int y, const char* text);
		void	printItem(int x, int y, const char* text);

	public:
		int		currentItem;
		int		currentMenu;

		fMenu();

		void	initialize(HDC hDC);

		int		input(int key);
		void	render();
		void	update();
	};

}

#endif // _F_MENU_H