
#include <stdio.h>
#include <windows.h>
#include <gl\gl.h>
#include "texture.h"

texture_c::texture_c()
{

}

texture_c::~texture_c()
{
	unload();
}

int texture_c::loadBMP(const char* filename, bool alpha)
{
	bmpHeader_t		header;
	bmpInfo_t		info;
	bmpPalette_t*	palette;

	FILE*			file;

	char*	tmp;
	char*	data;

	unsigned int	texture;

	int				colors;
	int				size;
	int				width;
	int				pad;

	file = fopen(filename, "rb");

	if ( file != 0 )
	{
		// Read the header and the info structure
		//int a = sizeof(bmpHeader_t);
		fread(&header, sizeof(bmpHeader_t), 1, file);
		fread(&info, sizeof(bmpInfo_t), 1, file);

		// Confirm that this actually is a bitmap file
		if ( header.type != 0x4d42 )
		{
			MessageBox(NULL, "This is not a valid BMP file", "loadBMP", MB_OK | MB_ICONERROR);

			fclose(file);
			return 0;
		}

		// Read the color palette, if any
		if ( info.bitCount == 8 )
		{
			colors	= 1 << info.bitCount;
			palette	= new bmpPalette_t[colors];

			fread(&palette, sizeof(bmpPalette_t), colors, file);
		}

		// Allocate a temporary storage for the bitmap
		size	= info.width * info.height * (info.bitCount / 8); //header.size - header.offset;
		tmp		= new char[size];

		// Make sure there was enough memory to store the entire bitmap
		if ( !tmp )
		{
			MessageBox(NULL, "Out of memory", "loadBMP", MB_OK | MB_ICONERROR);

			fclose(file);
			return 0;
		}

		// Read the entire bitmap
		fread(tmp, sizeof(unsigned char), size, file);

		// Dont need to keep the file open anymore
		fclose(file);

		// Calculate the width & padding of the image
		width = pad = (int) (info.width * info.bitCount / 8);

		// Adjust pad to nearest accepted value
		while ( pad % 4 != 0 )
			pad++;


		if ( alpha )
			data = new char[info.width * info.height * 4];
		else
			data = new char[info.width * info.height * 3];

		int size2 = info.width * info.height * 4;

		// Convert from BGR to RGB
		if ( info.bitCount == 24 )
		{
			if ( info.height > 0 )
			{
				//count backwards so you start at the front of the image
				if ( alpha )
				{
					int i, j;
					for ( i = 0, j = 0; i < size; i += 3, j += 4 )
					{
						//jump over the padding at the start of a new line
						if ( (i + 1) % pad == 0 )
						{
							i += pad - width;
						}

						data[j]		= tmp[i + 2];
						data[j + 1] = tmp[i + 1];
						data[j + 2] = tmp[i];

						/*data[i]		= 255;
						data[i + 1] = 255;
						data[i + 2] = 255;
						data[i + 3] = 255;*/

						if ( (tmp[i] == 0) && (tmp[i + 1] == 0) && (tmp[i + 2] == 0) )
							data[j + 3] = 0;
						else
							data[j + 3] = 255;

						//data[i + 0] = 255;
					}
				}
				else
				{
					for ( int i = 0; i < size; i += 3 )
					{
						//jump over the padding at the start of a new line
						if ( (i + 1) % pad == 0 )
						{
							i += pad - width;
						}

						data[i]		= tmp[i + 2];
						data[i + 1] = tmp[i + 1];
						data[i + 2] = tmp[i];
					}
				}
			}
		}
		else if ( info.bitCount == 8 )
		{

		}

		// The temporary information is no longer needed
		delete [] tmp;

		glGenTextures(1, &texture); 
		glBindTexture(GL_TEXTURE_2D, texture);

		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

		if ( alpha )
			glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, info.width, info.height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
		else
			glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, info.width, info.height, 0, GL_RGB, GL_UNSIGNED_BYTE, data);

		// And, since the texture now is in graphic memory, we dont need it here anymore either.
		delete [] data;

	}
	else
	{
		MessageBox(NULL, "File not found", "loadBMP", MB_OK | MB_ICONERROR);
		return 0;
	}
	
	return texture;
}

void texture_c::unload()
{
	
}


texture_c	texloader;