
#ifndef _STUDIO_H
#define _STUDIO_H

// Exclude rarely used Win32 headers
#ifndef WIN32_LEAN_AND_MEAN
	#define WIN32_LEAN_AND_MEAN
#endif

// Ignore Unicode. We dont need it
#ifdef UNICODE
	#undef UNICODE
#endif

// General system includes
#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include <stdlib.h>

// Import libraries
#pragma comment (lib, "opengl32.lib")
#pragma comment (lib, "glu32.lib")

typedef HRESULT (*EVENT)();
typedef HRESULT (*KEYEVENT)(int iKeyCode);
typedef HRESULT (*MOUSEEVENT)(int iX, int iY, int iButtons);

class studio_c
{
private:
	HWND		m_hWnd;

	HGLRC		m_hRC;
	HINSTANCE	m_hInst;
	MSG			m_hMsg;

	int			m_iWidth;
	int			m_iHeight;
	int			m_iColorBits;
	int			m_iAlphaBits;
	int			m_iDepthBits;
	int			m_iStencilBits;
	bool		m_bFullscreen;

protected:
	HRESULT deviceValidate	();
	HRESULT deviceCreate	();
	HRESULT deviceDestroy	();

	HRESULT initialize		();
	HRESULT update			();
	HRESULT render			();
	HRESULT finalize		();

	HRESULT keyDown			(int KeyCode);
	HRESULT keyPress		(int KeyCode);
	HRESULT keyUp			(int KeyCode);

	bool	handleMessages	( void );
	static LRESULT CALLBACK WndProc ( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );

public:
	// Event callbacks
	EVENT		onInitialize;
	EVENT		onUpdate;
	EVENT		onRender;
	EVENT		onFinalize;
	KEYEVENT	onKeyDown;
	KEYEVENT	onKeyPress;
	KEYEVENT	onKeyUp;

		HDC			m_hDC;

	studio_c (char* lpszTitle, int iWidth, int iHeight, int iColorBits, int iDepthBits, int iStencilBits, bool bFullscreen);

	HRESULT begin();
};

//int WINAPI WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstance, char *lpCmdLine, int nShowCmd );

#endif // _STUDIO_H