
#ifndef _CG_SOUND_H
#define _CG_SOUND_H

#if defined(WIN32) || defined(_WIN64) || defined(__WATCOMC__)
    #include <windows.h>
    #include <conio.h>
#else
    #include "wincompat.h"
#endif

#include "fmod.h"
#include "fmod_errors.h"

#pragma comment(lib, "fmodvc.lib")

namespace engine
{

	class cgSound
	{
	public:
		bool			initialized;

		FSOUND_STREAM*	music;
		FSOUND_SAMPLE*	sound[32];
		FSOUND_SAMPLE*	error;
		FSOUND_SAMPLE*	bonus;

		cgSound();
		~cgSound();
		
		void initialize(int frequency = 44100, int streams = 32, unsigned int flags = 0);
		void finalize();

		void musicLoad(const char* filename, unsigned int mode = 0, int offset = 0, int length = 0);
		void musicPlay();
		void musicPause();
		void musicStop();
		void musicUnload();
		void musicVolume(char volume);

		void soundPrecache(int id, const char* filename, unsigned int mode = 0, int offset = 0, int length = 0);
		void soundPlay(int id);
		void soundPause();
		void soundStop();
		void soundUnload(int id);

	};

}

#endif // _CG_SOUND_H