uniform extern matrix	g_world_mat;
uniform extern matrix	g_view_mat;
uniform extern matrix	g_proj_mat;
uniform extern float	g_size;
uniform extern float4	g_diffuse;

struct OutputVS
{
    float4 pos		: POSITION;
    float2 tex		: TEXCOORD; 
    float4 diffuse	: COLOR;
};

OutputVS ParticleVS(float4 pos	: POSITION, 
					float2 tex	: TEXCOORD)
{
	OutputVS outVS = (OutputVS)0;

	outVS.pos = pos * g_size;
	outVS.pos = mul(outVS.pos, transpose(g_view_mat));
	outVS.pos.w = 1;
	outVS.pos = mul(outVS.pos, g_world_mat);
	outVS.pos = mul(outVS.pos, g_view_mat);
	outVS.pos = mul(outVS.pos, g_proj_mat);
	outVS.tex = tex;
	outVS.diffuse = g_diffuse;

	return outVS;
}

technique ParticleTech
{
	pass P0
	{
		vertexShader		= compile vs_1_1 ParticleVS();
		ZWriteEnable		= false;
		AlphaBlendEnable	= true;
		SrcBlend			= ONE;
		DestBlend			= ONE;
	}
}