float4x4 matWorldViewProj;	
float4x4 matWorld;	
float4 vecLightDir;
float4 vecEye;
bool	bSpecular;
float	time;

// diffuse color map texture
texture ColorMap;
sampler ColorMapSampler = sampler_state
{
   Texture = <ColorMap>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Mirror;
   AddressV  = Mirror;
};

// bumpmap texture
texture BumpMap;
sampler BumpMapSampler = sampler_state
{
   Texture = <BumpMap>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Mirror;
   AddressV  = Mirror;
};

// definer output
struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float2 Tex : TEXCOORD0;
    float3 Light : TEXCOORD1;
    float3 View : TEXCOORD2;
};

// Vertex shader
VS_OUTPUT VS(float4 Pos : POSITION, float2 Tex : TEXCOORD, float3 Normal : NORMAL, float3 Tangent : TANGENT  )
{
    VS_OUTPUT Out = (VS_OUTPUT)0;
     
    Out.Pos = mul(Pos, matWorldViewProj);	// posisjonen til vertex
    
    // worldspace -> tangent space
    float3x3 worldToTangentSpace;
    worldToTangentSpace[0] = mul(Tangent, matWorld);
    worldToTangentSpace[1] = mul(cross(Tangent, Normal), matWorld);
    worldToTangentSpace[2] = mul(Normal, matWorld);
        
    Out.Tex = Tex;
    
    float4 PosWorld = mul(Pos, matWorld);	
    
    Out.Light = mul(worldToTangentSpace, vecLightDir);
    Out.View = mul(worldToTangentSpace, vecEye - PosWorld);
    
   return Out;
}

// Pixel Shader
float4 PS(float2 Tex: TEXCOORD0, float3 Light : TEXCOORD1, float3 View : TEXCOORD2) : COLOR
{
    float4 Ambient = float4(0.2, 0.2, 0.2, 1.0);
    
    // Hent fargen p gjeldende pixel  ( C )
    float2 TexTemp = Tex;
    Tex.y -= time/4;
    float4 Color = tex2D(ColorMapSampler, Tex);
    Tex = TexTemp;
    Color.w = Tex.y+0.4f;
    Tex.y -= time/2;
    
    // hent bumpmap verdien til gjeldende pixel ( N )
    float3 Normal =(2 * (tex2D(BumpMapSampler, Tex)))- 1.0; 
 	
 	// normaliser V og L
 	float3 ViewDir = normalize(View);
    float3 LightDir = normalize(Light);
        
	// D = [ N . V ]
    float Diffuse = saturate(dot(Normal, LightDir)); 
    
    float Shadow = 4.0f * LightDir.z;
    if(Shadow > 0.0f)
    {
		// R = [ 2 * D * N - L ]
		float3 Reflect = normalize(2 * Diffuse * Normal - LightDir);  // R
	 	
		// S = [ R . V ]
		float Specular = pow(saturate(dot(Reflect, ViewDir)), 150);

		// O = [ 0.2 * C + C * D + S ]
		if(bSpecular)
			return 0.5 * Color + Color * Diffuse + Specular;	
		else
			return 0.5 * Color + Color * Diffuse;
	}
	else
		return 0.5 * Color + Color * Diffuse;
}

// -------------------------------------------------------------
// 
// -------------------------------------------------------------
technique TShader
{
    pass P0
    {
        Sampler[0] = (ColorMapSampler);		
        Sampler[1] = (BumpMapSampler);		
    
        // compile shaders
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}