float4x4 matWorldViewProj;	
float4x4 matWorld;	
float4 vecLightDir;
float4 vecEye;
int selectLightModel;
float4 AddToColor;
bool UseAddColor;

// diffuse color map texture
texture ColorMap;
sampler ColorMapSampler = sampler_state
{
   Texture = <ColorMap>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Clamp;
   AddressV  = Clamp;
};

// bumpmap texture
texture BumpMap;
sampler BumpMapSampler = sampler_state
{
   Texture = <BumpMap>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Clamp;
   AddressV  = Clamp;
};

// definer output
struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float2 Tex : TEXCOORD0;
    float3 Light : TEXCOORD1;
    float3 View : TEXCOORD2;
};

// Vertex shader
VS_OUTPUT VS(float4 Pos : POSITION, float2 Tex : TEXCOORD, float3 Normal : NORMAL, float3 Tangent : TANGENT  )
{
    VS_OUTPUT Out = (VS_OUTPUT)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// posisjonen til vertex
    
    // worldspace -> tangent space
    float3x3 worldToTangentSpace;
    worldToTangentSpace[0] = mul(Tangent, matWorld);
    worldToTangentSpace[1] = mul(cross(Tangent, Normal), matWorld);
    worldToTangentSpace[2] = mul(Normal, matWorld);
        
    Out.Tex = Tex;
    
    float4 PosWorld = mul(Pos, matWorld);	
    
    Out.Light = mul(worldToTangentSpace, vecLightDir);
    Out.View = mul(worldToTangentSpace, vecEye - PosWorld);
    
   return Out;
}

// Pixel Shader
float4 PS(float2 Tex: TEXCOORD0, float3 Light : TEXCOORD1, float3 View : TEXCOORD2) : COLOR
{
    // Hent fargen p gjeldende pixel  ( C )
    
    float4 Color = tex2D(ColorMapSampler, Tex);	
    
    if(UseAddColor)
		Color.rgb += AddToColor.rgb;
	
    float4 Temp = Color;
    
    // hent bumpmap verdien til gjeldende pixel ( N )
    float3 Normal =(2 * (tex2D(BumpMapSampler, Tex)))- 1.0; 
 	
 	// normaliser V og L
 	float3 ViewDir = normalize(View);
    float3 LightDir = normalize(Light);
        
	// D = [ N . V ]
    float Diffuse = saturate(dot(Normal, LightDir)); 
    
    // R = [ 2 * D * N - L ]
    float3 Reflect = normalize(2 * Diffuse * Normal - LightDir);  // R
 	
    // S = [ R . V ]
    float Specular = pow(saturate(dot(Reflect, ViewDir)), 30);

	float4 ret;
	
	if(selectLightModel == 0) {
		ret = 0.65 * Color + Color * Diffuse + Specular;
	}
	else if(selectLightModel == 1) {
		ret = 0.65*Color + 0.5*Diffuse;
	}
	
	// O = [ 0.2 * C + C * D + S ]
	
	//float4 ret;
	//float4 temp = Color;
	
	if(Color.a <= 0)
		ret = Color;
	//else
	//	ret = 0.65*Color + 0.5*Diffuse;
	
	ret.a = Temp.a;
		
    return ret;
}

// -------------------------------------------------------------
// 
// -------------------------------------------------------------
technique TShader
{
    pass P0
    {
        Sampler[0] = (ColorMapSampler);		
        Sampler[1] = (BumpMapSampler);		
    
        // compile shaders
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
