/*********************************************************************************

	1 light using FP format.

**********************************************************************************/

varying vec3 LightDir0; 
varying vec3 eNormal;
varying vec3 eVertex;


uniform sampler2D tex0;

void main()
{
	vec4 acc;
	vec3 normNormal,normLightDir;
	float dist, att, reflected, diffuse, specular;	
	vec4 frag = texture2D(tex0, gl_TexCoord[0].st);
	normNormal 	= normalize(eNormal);



	/****************************

		Light #1

	*****************************/
	normLightDir 	= normalize(LightDir0);

	/*
		Attenuation factor
	*/
	dist = distance(eVertex,  gl_LightSource[0].position.xyz);
	att = 1.0 / ((0.2*dist) + (0.08*dist*dist));


	/*
		Reflection factor, since the eye vector is <0.0, 0.0, -1.0>, 
		we can ignore X and Y.
	*/
	reflected = normalize(reflect(normalize(-normLightDir), normNormal)).z;

	diffuse   = max(dot(normalize(LightDir0), normNormal), 0.0);
	specular  = pow(max(reflected, 0.0), 4.0);

	acc = frag * (diffuse + specular) * att;
	

	gl_FragColor = acc;
}