var activeEditor = null;
function activateEditor(editor) {
	if (editor == activeEditor) return;
	if (activeEditor != null) activeEditor.deactivate($('#editor'));
	activeEditor = editor;
	editor.activate($('#editor'));
}

function NullEditor(actor, timeline) {
}

function GenericEditor(actor, timeline) {
	this.actor = actor;
	this.timeline = timeline;
	this.createTimelineSpan();
}
GenericEditor.prototype.createTimelineSpan = function() {
	this.timelineSpan = $('<div class="timeline_span"><span class="label"></span><div class="end_handle"></div></div>');
	this.setTimelineSpanY();
	$('.label', this.timelineSpan).text(this.actor.opts.label);
	this.timeline.addSpan(this.timelineSpan);
	var editor = this;
	this.timeline.addEventListener('redraw', function() {editor.redrawTimelineSpan()});
	this.redrawTimelineSpan();
	$('.end_handle', this.timelineSpan).drag(
		function(e) {
			editor.deathTimeBeforeDrag = editor.actor.opts.deathTime;
		},
		function(e) {
			if (editor.deathTimeBeforeDrag == null) return;
			var offsetT = e.offsetX / editor.timeline.pixelsPerMs;
			editor.actor.opts.deathTime = editor.deathTimeBeforeDrag + offsetT;
			editor.redrawTimelineSpan();
			controller.seek(controller.currentTime());
		}
	)
	this.timelineSpan.click(function() {
		activateEditor(editor);
	}).drag(
		function(e) {
			editor.timelineYBeforeDrag = editor.actor.opts.timelineY || 0;
			editor.birthTimeBeforeDrag = editor.actor.opts.birthTime;
			editor.deathTimeBeforeDrag = editor.actor.opts.deathTime;
		},
		function(e) {
			editor.actor.opts.timelineY = Math.max(0,(editor.timelineYBeforeDrag + Math.floor(e.offsetY / 12)));
			editor.setTimelineSpanY();
			if (editor.birthTimeBeforeDrag == null) return;
			var offsetT = e.offsetX / editor.timeline.pixelsPerMs;
			editor.actor.opts.birthTime = editor.birthTimeBeforeDrag + offsetT;
			if (editor.actor.opts.deathTime != null) {
				editor.actor.opts.deathTime = editor.deathTimeBeforeDrag + offsetT;
			}
			editor.redrawTimelineSpan();
			controller.seek(controller.currentTime());
		}
	);
}
GenericEditor.prototype.setTimelineSpanY = function() {
	this.timelineSpan.css({top: 12 + (this.actor.opts.timelineY || 0) * 12});
}
GenericEditor.prototype.activate = function(panel) {
	this.timelineSpan.addClass('active');
	panel.html('<p>type: ' + this.actor.type + '</p>');
}
GenericEditor.prototype.deactivate = function(panel) {
	this.timelineSpan.removeClass('active');
	panel.empty();
}
GenericEditor.prototype.redrawTimelineSpan = function() {
	var birthTime = this.actor.opts.birthTime || 0;
	var deathTime = this.actor.opts.deathTime || this.timeline.totalDuration;
	this.timelineSpan.css({
		left: this.timeline.pixelsPerMs * birthTime,
		width: this.timeline.pixelsPerMs * (deathTime - birthTime)
	});
}

function CameraEditor(actor, timeline) {
	this.actor = actor;
	this.timeline = timeline;
	this.createTimelineSpan();
	this.timelineSpan.addClass('camera');
	this.keyframesContainer = $('<div></div>');
	this.timelineSpan.prepend(this.keyframesContainer);
	this.componentEditors = {
		position: new SplineEditor(this.actor.position, this.timeline, this.keyframesContainer, 'position'),
		target: new SplineEditor(this.actor.target, this.timeline, this.keyframesContainer, 'target'),
		up: new SplineEditor(this.actor.up, this.timeline, this.keyframesContainer, 'up')
	}
}
$.extend(CameraEditor.prototype, GenericEditor.prototype);
CameraEditor.prototype.activate = function(panel) {
	this.timelineSpan.addClass('active');
	panel.append('<h2>camerah editah</h2>');
	this.componentEditors.position.putEditor(panel);
	this.componentEditors.target.putEditor(panel);
	this.componentEditors.up.putEditor(panel);
	this.activateComponentEditor('position');
}
CameraEditor.prototype.putComponentEditor = function(panel, component) {
	var title = $('<h3></h3>');
	title.text(component);
	var cameraEditor = this;
	title.click(function() {cameraEditor.activateComponentEditor(component);});
	panel.append(title);
	this.componentEditors[component].putEditor(panel);
}
CameraEditor.prototype.activateComponentEditor = function(component) {
// tracking / deactivating the active editor is done via the icky global activeSplineEditor variable now
//	if (this.activeComponentEditor != null) this.activeComponentEditor.deactivate();
//	this.activeComponentEditor = this.componentEditors[component];
	this.componentEditors[component].activate();
}
CameraEditor.prototype.deactivate = function(panel) {
	this.timelineSpan.removeClass('active');
	if (activeSplineEditor != null) activeSplineEditor.deactivate();
	panel.empty();
}
CameraEditor.prototype.redrawTimelineSpan = function() {
	var birthTime = this.actor.opts.birthTime || 0;
	var deathTime = this.actor.opts.deathTime || this.timeline.totalDuration;
	this.timelineSpan.css({
		left: this.timeline.pixelsPerMs * birthTime,
		width: this.timeline.pixelsPerMs * (deathTime - birthTime)
	});
	if (activeSplineEditor) activeSplineEditor.redraw();
}

function WandererEditor(actor, timeline) {
	this.actor = actor;
	this.timeline = timeline;
	this.createTimelineSpan();
	this.timelineSpan.addClass('wanderer');
	this.componentEditors = {
		position: new SplineEditor(this.actor.position, this.timeline, this.timelineSpan, 'position'),
	}
}
$.extend(WandererEditor.prototype, GenericEditor.prototype);
WandererEditor.prototype.activate = function(panel) {
	this.timelineSpan.addClass('active');
	panel.append('<h2>wandering sprite</h2>');
	this.componentEditors.position.putEditor(panel);
	this.activateComponentEditor('position');
}
WandererEditor.prototype.putComponentEditor = function(panel, component) {
	var title = $('<h3></h3>');
	title.text(component);
	var editor = this;
	title.click(function() {editor.activateComponentEditor(component);});
	panel.append(title);
	this.componentEditors[component].putEditor(panel);
}
WandererEditor.prototype.activateComponentEditor = function(component) {
// tracking / deactivating the active editor is done via the icky global activeSplineEditor variable now
//	if (this.activeComponentEditor != null) this.activeComponentEditor.deactivate();
//	this.activeComponentEditor = this.componentEditors[component];
	this.componentEditors[component].activate();
}
WandererEditor.prototype.deactivate = function(panel) {
	this.timelineSpan.removeClass('active');
	if (activeSplineEditor != null) activeSplineEditor.deactivate();
	panel.empty();
}
WandererEditor.prototype.redrawTimelineSpan = function() {
	var birthTime = this.actor.opts.birthTime || 0;
	var deathTime = this.actor.opts.deathTime || this.timeline.totalDuration;
	this.timelineSpan.css({
		left: this.timeline.pixelsPerMs * birthTime,
		width: this.timeline.pixelsPerMs * (deathTime - birthTime)
	});
	if (activeSplineEditor) activeSplineEditor.redraw();
}



var activeSplineEditor = null; /* I HATE this being a global variable */
function SplineEditor(spline, timeline, timelineSpan, title) {
	this.spline = spline;
	this.title = title;
	this.timeline = timeline;
	this.timelineSpan = timelineSpan;
	var splineEditor = this;
	this.spline.addEventListener('addPoint', function(point) {
		var keyframeMarker = splineEditor.createKeyframeMarker(point);
		splineEditor.keyframeMarkers.splice(point.i, 0, keyframeMarker);
		splineEditor.redraw();
		splineEditor.populateKeyframeChooser();
		splineEditor.addTimeChangeListener(point);
		splineEditor.selectKeyframe(point.i);
	});
}
SplineEditor.prototype.addTimeChangeListener = function(point) {
	var splineEditor = this;
	point.bind('changeTime', function(t) {
		splineEditor.redraw();
		splineEditor.populateKeyframeChooser();
		controller.seek(controller.currentTime());
	});
}
SplineEditor.prototype.putEditor = function(panel) {
	this.inputs = [];

	var splineEditor = this;

	this.keyframeChooser = $('<select></select>').change(function() {
		splineEditor.selectKeyframe($(this).val())
	});
	this.populateKeyframeChooser();
	var addKeyframeButton = $('<img src="tool/add.png" align="absmiddle" style="margin-left: 4px;" width="16" height="16" alt="add" title="add keyframe" />');
	addKeyframeButton.click(function() {
		splineEditor.spline.addPoint();
	})

	for (i = 0; i < 3; i++) {
		this.inputs[i] = this.createInput(i);
	}
	this.heading = $('<h3></h3>');
	this.heading.text(this.title);
	this.heading.click(function() {
		splineEditor.activate();
	})
	panel.append(
		this.heading,
		$('<div>keyframe: </div>').append(this.keyframeChooser, addKeyframeButton),
		this.inputs[0], this.inputs[1], this.inputs[2]
	);
	this.selectKeyframe(0);
}
SplineEditor.prototype.populateKeyframeChooser = function() {
	this.keyframeChooser.empty();
	for (i = 0; i < this.spline.points.length; i++) {
		this.keyframeChooser.append(
			$('<option></option>').val(i).text(i + ': ' + Math.floor(this.spline.points[i].t))
		);
	}
}
SplineEditor.prototype.createInput = function(i) {
	var splineEditor = this;
	var input = $('<input />');
	input.change(function() {
		var val = parseFloat($(this).val());
		if (!isNaN(val)) {
			var keyframe = splineEditor.currentKeyframe;
			keyframe.v[i] = val;
			keyframe.setV(keyframe.v);
			controller.doFrame();
		}
	});
	return input;
}
SplineEditor.prototype.selectKeyframe = function(keyframeNumber) {
	if (this.currentKeyframe) {
		this.currentKeyframe.unbind('change', this.keyframeOnchange);
		if (this.keyframeMarkers) {
			this.keyframeMarkers[this.currentKeyframe.i].removeClass('selected');
		}
	}

	this.keyframeChooser.get(0).selectedIndex = keyframeNumber;
	this.currentKeyframe = this.spline.points[keyframeNumber];
	for (i = 0; i < 3; i++) {
		this.inputs[i].val(this.currentKeyframe.v[i]);
	}
	var splineEditor = this;
	this.keyframeOnchange = function(v) {
		for (i = 0; i < 3; i++) {
			splineEditor.inputs[i].val(v[i]);
		}
	};
	this.currentKeyframe.bind('change', this.keyframeOnchange);
	if (this.keyframeMarkers) {
		this.keyframeMarkers[keyframeNumber].addClass('selected');
	}
}
SplineEditor.prototype.activate = function() {
	if (this == activeSplineEditor) return;
	if (activeSplineEditor != null) activeSplineEditor.deactivate();
	activeSplineEditor = this;
	this.heading.addClass('active');
	this.keyframeMarkers = [];
	for (var i = 0; i < this.spline.points.length; i++) {
		var keyframeMarker = this.createKeyframeMarker(this.spline.points[i]);
		this.keyframeMarkers.push(keyframeMarker);
		this.addTimeChangeListener(this.spline.points[i]);
	}
	this.redraw();
}
SplineEditor.prototype.createKeyframeMarker = function(keyframe) {
	var keyframeMarker = $('<div class="keyframe"></div>');
	if (this.currentKeyframe == keyframe) keyframeMarker.addClass('selected');
	var splineEditor = this;
	var keyframeTBeforeDrag;
	keyframeMarker.mousedown(function() {
		splineEditor.selectKeyframe(keyframe.i);
		controller.seekWithin(splineEditor.spline.parent, keyframe.t);
	}).drag(
		function() {keyframeTBeforeDrag = keyframe.t;},
		function(e) {
			var offsetT = e.offsetX / splineEditor.timeline.pixelsPerMs;
			keyframe.setT(keyframeTBeforeDrag + offsetT);
		}
	)
	this.timelineSpan.append(keyframeMarker);
	return keyframeMarker;
}
SplineEditor.prototype.redraw = function() {
	for (var i = 0; i < this.spline.points.length; i++) {
		this.keyframeMarkers[i].css({left: (this.spline.points[i].t * this.timeline.pixelsPerMs)-4});
	}
}
SplineEditor.prototype.deactivate = function() {
	this.heading.removeClass('active');
	this.timelineSpan.empty();
	activeSplineEditor = null;
}

/* set up canvas drag/wheel events */
var keyframeValueBeforeDrag;
$(function() {
	$('#preview canvas').drag(
		function() {
			if (activeSplineEditor) {
				keyframeValueBeforeDrag = activeSplineEditor.currentKeyframe.v;
			}
		},
		function(e) {
			if (activeSplineEditor) {
				activeSplineEditor.currentKeyframe.setV([
					keyframeValueBeforeDrag[0] - e.offsetX/10,
					keyframeValueBeforeDrag[1] + e.offsetY/10,
					keyframeValueBeforeDrag[2]
				]);
				controller.seek(controller.currentTime());
			}
		}
	).mousewheel(function(e, delta) {
		if (activeSplineEditor) {
			var keyframe = activeSplineEditor.currentKeyframe
			keyframe.setV([
				keyframe.v[0],
				keyframe.v[1],
				keyframe.v[2] + delta * 0.1
			]);
			controller.seek(controller.currentTime());
			return false;
		}
	});
})

/*function ConstantEditor(actor, panelJq) {
} */

var editorClasses = {
	camera: CameraEditor,
	imageloader: NullEditor,
	wanderer: WandererEditor
/*	spline: SplineEditor,
	constant: ConstantEditor */
}
