function Sequence(children, opts) {
	this.type = 'sequence';
	this.children = children;

	this.opts = opts || {};
	this.opts.birthTime = this.opts.birthTime || 0;
}
Sequence.prototype.load = function() {
	var loaders = []
	for (i = 0; i < this.children.length; i++) {
		if (this.children[i].load) loaders.push(this.children[i].load());
		this.children[i].parent = this;
	}
	if (loaders.length == 0) {
		return true;
	} else {
		return deferUntilAllCompleted(loaders);
	}
}
Sequence.prototype.startup = function() {
	this.nextActorIndex = 0;
	this.liveActors = [];
}

Sequence.prototype.play = function() {
	for (var i = 0; i < this.liveActors.length; i++) {
		if (this.liveActors[i].play) this.liveActors[i].play();
	}
}

Sequence.prototype.pause = function() {
	for (var i = 0; i < this.liveActors.length; i++) {
		if (this.liveActors[i].pause) this.liveActors[i].pause();
	}
}

Sequence.prototype.tick = function(t) {
	/* look for any new actors being born */
	while (true) {
		var nextActor = this.children[this.nextActorIndex];
		if (!nextActor || (nextActor.opts.birthTime != null && nextActor.opts.birthTime > t)) break;

		/* skip actors that have both been born and died since the last tick */
		if (nextActor.opts.deathTime == null || nextActor.opts.deathTime > t) {
			if (nextActor.startup) nextActor.startup();
			if (nextActor.play) nextActor.play();
			this.liveActors.push(nextActor);
			/* TODO: insert in order of deathDate, to avoid a full array scan when purging dead actors */
		}
		this.nextActorIndex++;
	}
	
	/* look for actors who have died */
	var liveActorIndex = 0;
	while (liveActorIndex < this.liveActors.length) {
		var actor = this.liveActors[liveActorIndex];
		if (actor.opts.deathTime != null && actor.opts.deathTime <= t) {
			this.liveActors.splice(liveActorIndex, 1);
			if (actor.teardown) actor.teardown();
		} else {
			liveActorIndex++;
		}
	}
	
	/* run the 'tick' function for each actor */
	for (var i = 0; i < this.liveActors.length; i++) {
		if (this.liveActors[i].tick) this.liveActors[i].tick(t - (this.liveActors[i].opts.birthTime || 0));
	}
}

Sequence.prototype.seek = function(t) {
	var newActorIndex = 0;

	for (i = 0; i < this.children.length; i++) {
		var actor = this.children[i];
		if (actor.opts.birthTime == null || actor.opts.birthTime <= t) {
			newActorIndex = i+1;
			if (actor.opts.deathTime < t) {
				/* already died; see if it should be removed from liveActors */
				for (var j = 0; j < this.liveActors.length; j++) {
					if (this.liveActors[j] == actor) {
						this.liveActors.splice(j, 1);
						if (actor.teardown) actor.teardown();
					}
				}
			} else {
				/* not dead yet; see if it should be added to liveActors */
				var isInLiveActors = false;
				for (var j = 0; j < this.liveActors.length; j++) {
					if (this.liveActors[j] == actor) {
						isInLiveActors = true;
						break;
					}
				}
				if (!isInLiveActors) {
					/* TODO: insert in order of death time, to save an array scan in tick() */
					if (actor.startup) actor.startup();
					this.liveActors.push(actor);
				}
			}
		} else {
			/* not born yet; see if it should be removed from liveActors */
			for (var j = 0; j < this.liveActors.length; j++) {
				if (this.liveActors[j] == actor) {
					this.liveActors.splice(j, 1);
					if (actor.teardown) actor.teardown();
				}
			}
		}
	}
	this.nextActorIndex = newActorIndex;

	/* run the 'seek' function for each actor */
	for (var i = 0; i < this.liveActors.length; i++) {
		if (this.liveActors[i].seek) this.liveActors[i].seek(t - (this.liveActors[i].opts.birthTime || 0));
	}
}

Sequence.prototype.teardown = function() {
	/* tear down all children */
	for (var i = 0; i < this.liveActors.length; i++) {
		if (this.liveActors[i].teardown) this.liveActors[i].teardown();
	}
}

Sequence.prototype.toScript = function() {
	actorLines = [];
	for (var i = 0; i < this.children.length; i++) {
		actorLines[i] = this.children[i].toScript();
	}
	return "new Sequence([\n" + actorLines.join(",\n") + "\n], " + JSON.stringify(this.opts) + ")"
}
