varying vec4 diffuse,ambient;
varying vec3 normal,lightDir,halfVector;
varying float intensity;
varying vec4 pos;
varying float addi;
uniform float minus;
uniform float div;
uniform float mull;
uniform float time;
uniform float puls;
uniform float pulsmul;


void main()
{
	
	normal = normalize(gl_NormalMatrix * gl_Normal);
	
	lightDir = normalize(vec3(gl_LightSource[0].position));

	halfVector = normalize(gl_LightSource[0].halfVector.xyz);
				
	diffuse = gl_FrontMaterial.diffuse;
	ambient = gl_FrontMaterial.ambient;
	vec4 aa = gl_Vertex;
	intensity = max(0.0, min(1.0, (sqrt(aa.x * aa.x + aa.z * aa.z) - minus) / div));
	
	addi = length(aa) * mull * 5.0;
	pos = gl_Vertex;
	
	
	float radAdd = 1.0 + max(0.0, sin(-time / 700.0 + aa.y * 0.008) - puls) * pulsmul;
	aa.x = aa.x * radAdd;
	aa.z = aa.z * radAdd;

	gl_Position = gl_ModelViewProjectionMatrix * aa;
} 