varying vec4 diffuse,ambient;
varying vec3 normal,lightDir,halfVector;
varying float intensity;
varying vec4 pos;
varying float addi;
uniform float minus;
uniform float div;
uniform float mull;

void main()
{	
	normal = normalize(gl_NormalMatrix * gl_Normal);
	
	lightDir = normalize(vec3(gl_LightSource[0].position));

	halfVector = normalize(gl_LightSource[0].halfVector.xyz);
				
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	ambient += gl_LightModel.ambient * gl_FrontMaterial.ambient;
	
	vec4 vertex = gl_Vertex;
	intensity = max(0.0, min(1.0, (length(vertex) - minus) / div));
	
	addi = length(vertex.xyz) * (mull * 5.0);
	pos = gl_Vertex;
	

	gl_Position = ftransform();
} 