uniform sampler2D Texture;
varying vec2 texCoord;
uniform float viewportStep;

void main(void)
{
	vec4 sum;
	sum = texture2D(Texture, texCoord.xy);
	// Down
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, viewportStep));
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, viewportStep*2.0));
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, viewportStep*3.0));
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, viewportStep*4.0));
	// Up
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, -viewportStep));
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, -viewportStep*2.0));
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, -viewportStep*3.0));
	sum += texture2D(Texture, texCoord.xy + vec2(0.0, -viewportStep*4.0));
	gl_FragColor = sum / 9.0;
}
