//-------------------------------------------------------------------
//
//
//-------------------------------------------------------------------

//-------------------------------------------------------------------
// p[^
//-------------------------------------------------------------------

// ˉes
float4x4	projMat;
float		blendRate;

sampler2D noiseTexture = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};


// eNX`Tv

// V[CO@J[obt@
sampler2D srcCBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CP@J[obt@
sampler2D srcCBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CO@Zobt@
sampler2D srcZBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CP@Zobt@
sampler2D srcZBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CO@[Nobt@
sampler2D workBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CP@[Nobt@
sampler2D workBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

float shTime0 : TIME_RATE_0;// V[C0̎
float shTime1 : TIME_RATE_1;// V[C1̎
float shTimeEffect : TIME_RATE_EFFECT;// ̃GtFNg̎


//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void VS(	float4 in_pos			: POSITION	,
				float2 in_texcoord		: TEXCOORD0	,
				out float4 out_pos		: POSITION	,
				out float2 out_texcoord	: TEXCOORD0 )
{
	// pos
	out_pos = mul( projMat, in_pos );

	// texcoord
	out_texcoord = in_texcoord;
}


#define DOF_FocalScale  1.5f
#define DOF_FocalOffset  2.3f

#define SAMPLE_NUM 16
#define BLUR_WIDTH 0.03f
//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void PS_w0(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 out float4 out_col	: COLOR		)
{
	float rate = min(shTimeEffect * 4.0f, 1);
	float brate = min(max(0, 9.0f - shTimeEffect * 10.0f), 1);
	out_col = float4(
			tex2D(workBuf0, samplePos + rate * 0.1f * tex2D(noiseTexture, float2(shTimeEffect, samplePos.y*0.5f))).r,
			tex2D(workBuf0, samplePos + rate * 0.15f * tex2D(noiseTexture, float2(shTimeEffect, samplePos.y*0.5f))).g,
			tex2D(workBuf0, samplePos + rate * 0.30f * tex2D(noiseTexture, float2(shTimeEffect, samplePos.y*0.5f))).b,
			1
			)
	 * brate;
}

void DepthBlend_s0w1(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 out float4 out_col	: COLOR		)
{
	
	float4 scol = tex2D(srcCBuf0, samplePos);
	float4 bcol = tex2D(workBuf1, samplePos);
	float d = max(0, min(1,pow(tex2D(srcZBuf0, samplePos).r*1.2f, 4)* DOF_FocalScale - DOF_FocalOffset));
	//out_col = float4(d,d,d,1);
	out_col = lerp(scol, bcol, d);
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		VertexProgram   = compile glslv VS();
		FragmentProgram = compile glslf PS_w0();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}
