//-------------------------------------------------------------------
//
//
//-------------------------------------------------------------------

//-------------------------------------------------------------------
// p[^
//-------------------------------------------------------------------

// ˉes
float4x4	projMat;
float		blendRate;


// eNX`Tv

// V[CO@J[obt@
sampler2D srcCBuf0 = sampler_state {
//	minFilter = Linear;
//	magFilter = Linear;
    WrapS = ClampToEdge;
    WrapT = ClampToEdge;
	MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;
};
// V[CP@J[obt@
sampler2D srcCBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CO@Zobt@
sampler2D srcZBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CP@Zobt@
sampler2D srcZBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};
// V[CO@[Nobt@
sampler2D workBuf0 = sampler_state {
    WrapS = ClampToEdge;
    WrapT = ClampToEdge;
	MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;	
};
// V[CP@[Nobt@
sampler2D workBuf1 = sampler_state {
    WrapS = ClampToEdge;
    WrapT = ClampToEdge;
	MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;	
};
// V[CQ@[Nobt@
sampler2D workBuf2 = sampler_state {
    WrapS = ClampToEdge;
    WrapT = ClampToEdge;
	MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;	
};

float shTime0 : TIME_RATE_0;// V[C0̎
float shTime1 : TIME_RATE_1;// V[C1̎
float shTimeEffect : TIME_RATE_EFFECT;// ̃GtFNg̎

// Relative filter weights indexed by distance (in texels) from "home" texel
//   (WT_0 is the "home" or center of the filter, WT_4 is four texels away)
// Try changing these around for different filter patterns....
#define WT_0 1.0
#define WT_1 0.9
#define WT_2 0.55
#define WT_3 0.18
#define WT_4 0.1
// these ones are based on the above....
#define WT_NORMALIZE (WT_0+2.0*(WT_1+WT_2+WT_3+WT_4))
#define KW_0 (WT_0/WT_NORMALIZE)
#define KW_1 (WT_1/WT_NORMALIZE)
#define KW_2 (WT_2/WT_NORMALIZE)
#define KW_3 (WT_3/WT_NORMALIZE)
#define KW_4 (WT_4/WT_NORMALIZE)

float2 ViewportSize;
#define gGlowSpan 2.5f

// nine texcoords, to sample nine in-line texels
struct NineTexelVertex
{
	float4 Position   : POSITION;
	float2 UV    : TEXCOORD0;
	float4 UV1   : TEXCOORD1; // xy AND zw used as UV coords
	float4 UV2   : TEXCOORD2; // xy AND zw used as UV coords
	float4 UV3   : TEXCOORD3; // xy AND zw used as UV coords
	float4 UV4   : TEXCOORD4; // xy AND zw used as UV coords
};

//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
NineTexelVertex horiz9BlurVS(
		float3 Position : POSITION, 
		float2 UV : TEXCOORD0
) {
	NineTexelVertex OUT = (NineTexelVertex)0;

	// pos
	OUT.Position = mul( projMat, float4(Position, 1) );

	// UV
	float TexelIncrement = gGlowSpan/ViewportSize.x;
	float2 Coord = float2(UV.xy);
	OUT.UV = Coord;
	OUT.UV1 = float4(Coord.x + TexelIncrement,   Coord.y, Coord.x - TexelIncrement,   Coord.y);
	OUT.UV2 = float4(Coord.x + TexelIncrement*2, Coord.y, Coord.x - TexelIncrement*2, Coord.y);
	OUT.UV3 = float4(Coord.x + TexelIncrement*3, Coord.y, Coord.x - TexelIncrement*3, Coord.y);
	OUT.UV4 = float4(Coord.x + TexelIncrement*4, Coord.y, Coord.x - TexelIncrement*4, Coord.y);
	return OUT;
	}
NineTexelVertex vert9BlurVS(
		float3 Position : POSITION, 
		float2 UV : TEXCOORD0
) {
	NineTexelVertex OUT = (NineTexelVertex)0;

	// pos
	OUT.Position = mul( projMat, float4(Position, 1) );

	// UV
	float TexelIncrement = gGlowSpan/ViewportSize.y;
	float2 Coord = float2(UV.xy);
	OUT.UV = Coord;
	OUT.UV1 = float4(Coord.x, Coord.y + TexelIncrement,   Coord.x, Coord.y - TexelIncrement  );
	OUT.UV2 = float4(Coord.x, Coord.y + TexelIncrement*2, Coord.x, Coord.y - TexelIncrement*2);
	OUT.UV3 = float4(Coord.x, Coord.y + TexelIncrement*3, Coord.x, Coord.y - TexelIncrement*3);
	OUT.UV4 = float4(Coord.x, Coord.y + TexelIncrement*4, Coord.x, Coord.y - TexelIncrement*4);
	return OUT;
}
void ScreenQuadVS2(	float4 in_pos			: POSITION	,
				float2 in_texcoord		: TEXCOORD0	,
				out float4 out_pos		: POSITION	,
				out float2 out_texcoord	: TEXCOORD0 )
{
	// pos
	float3 posTmp = in_pos.xyz;
	out_pos = mul( projMat, float4(posTmp, 1) );

	// texcoord
	out_texcoord = in_texcoord;
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
float4 horiz9BlurPS(NineTexelVertex IN) : COLOR
{   
	float4 OutCol = tex2D(workBuf2, IN.UV4.zw) * KW_4;
	OutCol += tex2D(workBuf2, IN.UV3.zw) * KW_3;
	OutCol += tex2D(workBuf2, IN.UV2.zw) * KW_2;
	OutCol += tex2D(workBuf2, IN.UV1.zw) * KW_1;
	OutCol += tex2D(workBuf2, IN.UV)     * KW_0;
	OutCol += tex2D(workBuf2, IN.UV1.xy) * KW_1;
	OutCol += tex2D(workBuf2, IN.UV2.xy) * KW_2;
	OutCol += tex2D(workBuf2, IN.UV3.xy) * KW_3;
	OutCol += tex2D(workBuf2, IN.UV4.xy) * KW_4;
	return OutCol;
}
float4 vert9BlurPS(NineTexelVertex IN) : COLOR
{
	float4 OutCol = tex2D(workBuf0, IN.UV4.zw) * KW_4;
	OutCol += tex2D(workBuf0, IN.UV3.zw) * KW_3;
	OutCol += tex2D(workBuf0, IN.UV2.zw) * KW_2;
	OutCol += tex2D(workBuf0, IN.UV1.zw) * KW_1;
	OutCol += tex2D(workBuf0, IN.UV)     * KW_0;
	OutCol += tex2D(workBuf0, IN.UV1.xy) * KW_1;
	OutCol += tex2D(workBuf0, IN.UV2.xy) * KW_2;
	OutCol += tex2D(workBuf0, IN.UV3.xy) * KW_3;
	OutCol += tex2D(workBuf0, IN.UV4.xy) * KW_4;
	return OutCol;
}
float4 GlowPS(float2 samplePos	: TEXCOORD0) : COLOR
{
	float4 scn = 1.f * tex2D(srcCBuf0, samplePos);// V[͂̂܂܏o
	float3 glow = 0.3f * tex2D(workBuf1, samplePos).xyz;
	return float4(scn.xyz+glow,scn.w);
}

//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
/*
	Pass0[u[]: [Nobt@0ɏo : [Nobt@2(KDFIuWFNgŕ`)Q
	Pass1[cu[]: [Nobt@1ɏo : [Nobt@0(u[)Q
	Pass2[O[] : XN[eNX`ɏo : [Nobt@1(+cu[)ƃJ[obt@0(KDFIuWFNg`悳Ă)Q
*/
technique sm_glsl
{
	pass P0
	{
		DepthTestEnable = false;
		DepthMask		= false;
		VertexProgram   = compile glslv horiz9BlurVS();
		FragmentProgram = compile glslf horiz9BlurPS();
	}
	pass P1
	{
		DepthMask		= false;
		DepthTestEnable	= false;
		VertexProgram   = compile glslv vert9BlurVS();
		FragmentProgram = compile glslf vert9BlurPS();
	}
	pass P2
	{
		DepthTestEnable = false;
		DepthMask = false;
		VertexProgram   = compile glslv ScreenQuadVS2();
		FragmentProgram = compile glslf GlowPS();
	}
}
