#include "_shared.fx"

float4x4 wvpMatrix : WorldViewProjection;

Texture2D<float4> image;

struct VS_INPUT
{
    float3 Position 	: POSITION;
	float2 uvCoord		: TEXCOORD0;
	uint fq : TEXCOORD1;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord0	: TEXCOORD0;
	uint fq : TEXCOORD1;
};
struct PS_OUTPUT
{
	float4 color : SV_Target;
};

VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
	float coef = min(0.1f,fftData.Load(int3(In.fq,0,0))*50.0f);
	float fac = min(1.0f,max(0.0f,time*0.7f-(1.05f-length(In.Position.xy))*7.0f)*2.0f);
	//float fac = min(1.0f,max(0.0f,time-(3.141592f-sign(In.Position.x)*acos(In.Position.y/length(In.Position.xy)))*7.0f)*2.0f);
	In.Position.xy = lerp(float2(0.0f,0.0f),In.Position.xy,fac);
	In.Position.xy *= (1.0f+coef);
	Out.Position = mul(float4(In.Position,1.0f),wvpMatrix);
	Out.uvCoord0 = In.uvCoord;
	Out.fq = In.fq;
    return Out;
}

float4 RenderScenePS( VS_OUTPUT In ) : SV_Target
{
	float coef = lerp(min(1.0f,fftData.Load(int3(In.fq,0,0))*100.0f),1.0f,0.6f);
	//coef = pow(coef,2.2f);
	return image.SampleLevel(PointSampler,In.uvCoord0,0)*coef;
}

technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
		SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
    }
}