
#ifndef MSXLIB_H
#define MSXLIB_H

#define TRANSPARENT 0 /* MSX color name defines */
#define BLACK       1
#define GREEN       2
#define LIGHT_GREEN 3
#define DARK_BLUE   4
#define LIGHT_BLUE  5
#define DARK_RED    6
#define CYAN        7
#define RED         8
#define LIGHT_RED   9
#define DARK_YELLOW 10
#define LIGHT_YELLOW 11
#define DARK_GREEN  12
#define MAGENTA     13
#define GRAY        14
#define GREY        14
#define WHITE       15

#define VDP_MODE0   0   /* VDP register names */
#define VDP_MODE1   1
#define VDP_NAME_T  2
#define VDP_COLOR_T 3
#define VDP_PATT_T  4
#define VDP_SPRITE_ATTR_T 5
#define VDP_SPRITE_PATT_T 6
#define VDP_COLOR   7

#define MODE0_M3    2       /* MODE0 register bits (MSX1 only) */
#define MODE0_HBI   0x10
#define MODE0_VBI   0x20    /* Dunno if these work on MSX1 */

#define MODE1_SPRITE_MAG 1  /* MODE1 register bits */
#define MODE1_SPRITE_SZ  2  /* 1=16x16 */
#define MODE1_M2    8
#define MODE1_M1    0x10
#define MODE1_IE    0x20    /* 1=interrupt enable */
#define MODE1_BLANK 0x40   /* 0=blank */
#define MODE1_VRAM  0x80    /* 1=16k */

void waitVB(void);
unsigned char space(void);      /* Space pressed? */
void screen(char mode);

void vdp_address(unsigned addr);
void vdp_poke(unsigned addr,unsigned char c);
void vdp_set(unsigned char c,unsigned bytes);
void vdp_slowset(unsigned char c,unsigned bytes);
void vdp_copy(unsigned char *src,unsigned bytes);
void vdp_slowcopy(unsigned char *src,unsigned bytes);
void vdp_register(int reg,unsigned char c);

void sprite_col(int num,char col);
void sprite_pos(int num,unsigned char x,unsigned char y);
void sprite_pat(int num,unsigned char pat);

#endif
