/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSound;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.view.PortFader;
import com.softsynth.jsyn.view.UsageDisplay;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class SoundTester
extends Panel {
    Checkbox[] cbox;
    SynthSound sound;
    Button hitButton;
    static final int NUM_STAGES = 8;

    public SoundTester(SynthSound synthSound) throws SynthException {
        this.sound = synthSound;
        this.setLayout(new GridLayout(0, 1));
        int n = synthSound.getNumPorts();
        int n2 = 0;
        while (n2 < n) {
            SynthPort synthPort = synthSound.getPortAt(n2);
            if (synthPort instanceof SynthVariable) {
                this.addInput((SynthVariable)synthPort);
            }
            ++n2;
        }
        Panel panel = new Panel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.cbox = new Checkbox[8];
        panel.add(new Label("Stage:"));
        int n3 = 0;
        while (n3 < 8) {
            this.cbox[n3] = new Checkbox(Integer.toString(n3), checkboxGroup, n3 == 0);
            panel.add(this.cbox[n3]);
            ++n3;
        }
        this.add(panel);
        this.hitButton = new Button("Hit");
        this.add(this.hitButton);
        this.add(new UsageDisplay());
    }

    void addInput(SynthVariable synthVariable) throws SynthException {
        this.add(new PortFader(synthVariable, synthVariable.get(), synthVariable.getMin(), synthVariable.getMax()));
    }

    public boolean action(Event event, Object object) {
        try {
            int n = 0;
            while (n < 8) {
                if (this.cbox[n] == event.target) {
                    this.sound.setStage(n);
                    return true;
                }
                ++n;
            }
            if (event.target == this.hitButton) {
                this.sound.setStage(0);
                return true;
            }
        }
        catch (SynthException synthException) {
            SynthAlert.showError((Component)this, synthException);
            return true;
        }
        return false;
    }
}

