/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthFilter;
import com.softsynth.jsyn.SynthVariable;

public class Filter_2o2p2z
extends SynthFilter {
    public SynthVariable A0 = new SynthVariable(this, "A0");
    public SynthVariable A1 = new SynthVariable(this, "A1");
    public SynthVariable A2 = new SynthVariable(this, "A2");
    public SynthVariable B1 = new SynthVariable(this, "B1");
    public SynthVariable B2 = new SynthVariable(this, "B2");
    double omega = 0.0;
    double cs = 0.0;
    double sn = 0.0;
    double Q = 0.0;
    double alpha = 0.0;

    public Filter_2o2p2z(SynthContext synthContext, int n) throws SynthException {
        super(synthContext, "Filter_2o2p2z", n, 0);
    }

    public Filter_2o2p2z(SynthContext synthContext) throws SynthException {
        this(synthContext, 0);
    }

    public Filter_2o2p2z() throws SynthException {
        this(Synth.getSharedContext(), 0);
    }

    double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    void calcCommon(double d, double d2) {
        double d3 = d / this.context.getFrameRate();
        if (d3 >= 0.499) {
            d3 = 0.499;
        }
        this.omega = Math.PI * 2 * d3;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        this.Q = this.sn / (Math.log(2.0) * d2 * this.omega);
        this.alpha = this.sn * this.sinh(0.5 / this.Q);
    }

    public void lowPass(int n, double d, double d2) throws SynthException {
        this.calcCommon(d, d2);
        double d3 = 0.5 / (1.0 + this.alpha);
        double d4 = 1.0 - this.cs;
        double d5 = d4 * 0.5 * d3;
        this.A0.set(n, d5);
        this.A1.set(n, d4 * d3);
        this.A2.set(n, d5);
        this.B1.set(n, -2.0 * this.cs * d3);
        this.B2.set(n, (1.0 - this.alpha) * d3);
    }

    public void lowPass(double d, double d2) throws SynthException {
        this.lowPass(this.context.getTickCount(), d, d2);
    }

    public void highPass(int n, double d, double d2) throws SynthException {
        this.calcCommon(d, d2);
        double d3 = 1.0 + this.alpha;
        double d4 = 0.5 / d3;
        double d5 = 1.0 + this.cs;
        double d6 = d5 * 0.5 * d4;
        this.A0.set(n, d6);
        this.A1.set(n, -d5 * d4);
        this.A2.set(n, d6);
        this.B1.set(n, -2.0 * this.cs * d4);
        this.B2.set(n, (1.0 - this.alpha) * d4);
    }

    public void highPass(double d, double d2) throws SynthException {
        this.highPass(this.context.getTickCount(), d, d2);
    }

    public void bandPass(int n, double d, double d2) throws SynthException {
        this.calcCommon(d, d2);
        double d3 = 0.5 / (1.0 + this.alpha);
        this.A0.set(n, this.alpha * d3);
        this.A1.set(n, 0.0);
        this.A2.set(n, -this.alpha * d3);
        this.B1.set(n, -2.0 * this.cs * d3);
        this.B2.set(n, (1.0 - this.alpha) * d3);
    }

    public void bandPass(double d, double d2) throws SynthException {
        this.bandPass(this.context.getTickCount(), d, d2);
    }

    public void notch(int n, double d, double d2) throws SynthException {
        this.calcCommon(d, d2);
        double d3 = 0.5 / (1.0 + this.alpha);
        double d4 = -2.0 * this.cs * d3;
        this.A0.set(n, d3);
        this.A1.set(n, d4);
        this.A2.set(n, d3);
        this.B1.set(n, d4);
        this.B2.set(n, (1.0 - this.alpha) * d3);
    }

    public void notch(double d, double d2) throws SynthException {
        this.notch(this.context.getTickCount(), d, d2);
    }

    double calcA(double d) {
        return Math.pow(10.0, d / 40.0);
    }

    public void peakingEQ(int n, double d, double d2, double d3) throws SynthException {
        this.calcCommon(d, d2);
        double d4 = this.calcA(d3);
        double d5 = this.alpha * d4;
        double d6 = this.alpha / d4;
        double d7 = 0.5 / (1.0 + d6);
        double d8 = -2.0 * this.cs * d7;
        this.A0.set(n, (1.0 + d5) * d7);
        this.A1.set(n, d8);
        this.A2.set(n, (1.0 - d5) * d7);
        this.B1.set(n, d8);
        this.B2.set(n, (1.0 - d6) * d7);
    }

    public void peakingEQ(double d, double d2, double d3) throws SynthException {
        this.peakingEQ(this.context.getTickCount(), d, d2, d3);
    }

    double calcBeta(double d, double d2) {
        double d3 = d2 - 1.0;
        double d4 = (d2 * d2 + 1.0) / d - d3 * d3;
        if (d4 < 0.0) {
            return 0.0;
        }
        return Math.sqrt(d4);
    }

    public void lowShelf(int n, double d, double d2, double d3) throws SynthException {
        double d4 = d / this.context.getFrameRate();
        if (d4 >= 0.499) {
            d4 = 0.499;
        }
        this.omega = Math.PI * 2 * d4;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        double d5 = this.calcA(d2);
        double d6 = this.calcBeta(d3, d5);
        double d7 = d6 * this.sn;
        double d8 = d5 + 1.0;
        double d9 = d5 - 1.0;
        double d10 = d8 * this.cs;
        double d11 = d9 * this.cs;
        double d12 = 0.5 / (d8 + d11 + d7);
        this.A0.set(n, d5 * (d8 - d11 + d7) * d12);
        this.A1.set(n, 2.0 * d5 * (d9 - d10) * d12);
        this.A2.set(n, d5 * (d8 - d11 - d7) * d12);
        this.B1.set(n, -2.0 * (d9 + d10) * d12);
        this.B2.set(n, (d8 + d11 - d7) * d12);
    }

    public void lowShelf(double d, double d2, double d3) throws SynthException {
        this.lowShelf(this.context.getTickCount(), d, d2, d3);
    }

    public void lowShelf(double d, double d2, double d3, double d4) throws SynthException {
        this.lowShelf(this.context.getTickCount(), d, d3, d4);
    }

    public void lowShelf(int n, double d, double d2, double d3, double d4) throws SynthException {
        this.lowShelf(n, d, d3, d4);
    }

    public void highShelf(int n, double d, double d2, double d3) throws SynthException {
        double d4 = d / this.context.getFrameRate();
        if (d4 >= 0.499) {
            d4 = 0.499;
        }
        this.omega = Math.PI * 2 * d4;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        double d5 = this.calcA(d2);
        double d6 = this.calcBeta(d3, d5);
        double d7 = d6 * this.sn;
        double d8 = d5 + 1.0;
        double d9 = d5 - 1.0;
        double d10 = d8 * this.cs;
        double d11 = d9 * this.cs;
        double d12 = 0.5 / (d8 - d11 + d7);
        this.A0.set(n, d5 * (d8 + d11 + d7) * d12);
        this.A1.set(n, -2.0 * d5 * (d9 + d10) * d12);
        this.A2.set(n, d5 * (d8 + d11 - d7) * d12);
        this.B1.set(n, 2.0 * (d9 - d10) * d12);
        this.B2.set(n, (d8 - d11 - d7) * d12);
    }

    public void highShelf(double d, double d2, double d3) throws SynthException {
        this.highShelf(this.context.getTickCount(), d, d2, d3);
    }

    public void highShelf(double d, double d2, double d3, double d4) throws SynthException {
        this.highShelf(this.context.getTickCount(), d, d3, d4);
    }

    public void highShelf(int n, double d, double d2, double d3, double d4) throws SynthException {
        this.highShelf(n, d, d3, d4);
    }
}

