/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

public class EqualTemperedTuning {
    static final double BASE_MIDI_C = 8.1758224;
    int notesPerOctave;
    double fundamental;
    double inverseOctave;

    public EqualTemperedTuning() {
        this(110.0, 12);
    }

    public EqualTemperedTuning(double d) {
        this(d, 12);
    }

    public EqualTemperedTuning(double d, int n) {
        this.setFundamental(d);
        this.setNotesPerOctave(n);
    }

    public void setNotesPerOctave(int n) {
        this.notesPerOctave = n;
        this.inverseOctave = 1.0 / (double)n;
    }

    public int getNotesPerOctave() {
        return this.notesPerOctave;
    }

    public void setFundamental(double d) {
        this.fundamental = d;
    }

    public double getFundamental() {
        return this.fundamental;
    }

    public double getPitch(double d) {
        return (double)this.notesPerOctave * Math.log(d / this.fundamental) / Math.log(2.0);
    }

    public double getFrequency(double d) {
        return this.fundamental * Math.pow(2.0, d * this.inverseOctave);
    }

    public double getFrequency(int n, int n2) {
        return this.getFrequency((double)n + (double)n2 / 100.0);
    }

    public double getFrequency(int n) {
        return this.getFrequency((double)n);
    }

    public static double getMIDIPitch(double d) {
        return 12.0 * Math.log(d / 8.1758224) / Math.log(2.0);
    }

    public static double getMIDIFrequency(double d) {
        return 8.1758224 * Math.pow(2.0, d * 0.08333333333333333);
    }

    public static double getMIDIFrequency(int n, int n2) {
        return EqualTemperedTuning.getMIDIFrequency((double)n + (double)n2 / 100.0);
    }
}

