/*
 * Decompiled with CFR 0.152.
 */
import SoniaHelper.SoniaHelper;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import fullscreen.FullScreen;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import krister.Ess.AudioChannel;
import krister.Ess.AudioOutput;
import krister.Ess.Ess;
import krister.Ess.FFT;
import pitaru.sonia_v2_9.LiveInput;
import pitaru.sonia_v2_9.Sample;
import pitaru.sonia_v2_9.Sonia;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;

public class sunflower
extends PApplet {
    FullScreen fs;
    XGL gl;
    int sWidth = 1024;
    int sHeight = 768;
    float aspectRatio = 1.3333334f;
    int spectrumLength = 2048;
    float damperval;
    SoniaHelper ffthelper;
    Sample mySample;
    XTexture we;
    XTexture vs;
    boolean useSonia = false;
    boolean useSoniaSample = false;
    boolean storeImageSequence = false;
    float frequencyScale = 400.0f;
    int currFrame;
    int currFrameTime;
    float time;
    float startTime;
    XTexture tex;
    XTexture flare3;
    XTexture sunflower;
    int[] camId = new int[]{1, 3, 1, 1, 4, 2, 1, 1, 3, 3, 3, 3, 1, 4, 3, 1, 2, 3, 2, 2, 3, 1, 3, 3, 3, 2, 3, 4, 2, 3, 1, 3, 3, 3, 4, 3, 2, 1, 4, 4, 3, 1, 3, 1, 3, 3};
    int camIndex = 0;
    Vector3 eye;
    Vector3 target;
    Vector3 cam1;
    Vector3 cam2;
    Vector3 cam3;
    Vector3 cam4;
    Vector3 tar1;
    Vector3 tar2;
    Vector3 tar3;
    Vector3 tar4;
    Vector3 lightPos = new Vector3();
    float cTime;
    float sTime;
    float radMod;
    Vector3 count = new Vector3(1.0f, 1.0f, 1.0f);
    Vector3 phase = new Vector3(1.0f, 1.0f, 1.0f);
    Vector3 amount = new Vector3(1.0f, 1.0f, -1.0f);
    int sphereStacks = 120;
    int sphereSlices = 120;
    Vector3[] sphereSurface;
    int[] sphereIndices;
    Vector3[] sphereSurfaceUV;
    Vector3[] sphereSurfaceNormal;
    Vector3[] sphereSurface2;
    Vector3[] sphereSurfaceNormal2;
    int ribWidth = 20;
    int ribCount = 700;
    Vector3[] ribloc;
    Vector3 rib;
    Overlay overlay;
    int numGrass = 255;
    GrassLine[] grasslines;
    XTexture grassTexture;
    SkyBox sky;
    AudioChannel chn;
    FFT fft;
    int frameNumber = 0;
    int framesPerSecond = 25;
    float level;
    float[] fftbuffer;
    String extension = ".jpg";
    String directory = "g:\\_sunflower\\";

    public void setup() {
        this.size(1024, 768, "processing.opengl.PGraphicsOpenGL");
        this.hint(1);
        this.smooth();
        this.frameRate(30.0f);
        this.randomSeed(22L);
        this.gl = new XGL(this);
        this.aspectRatio = (float)this.width / (float)this.height;
        if (this.useSonia) {
            Sonia.start((PApplet)this);
            LiveInput.start((int)this.spectrumLength);
            LiveInput.useEnvelope((boolean)true, (float)2.4f);
            this.ffthelper = new SoniaHelper(this.spectrumLength, 256, false);
            this.ffthelper.setMaxLimits(200.0f, 2000.0f);
            this.damperval = 0.62f;
            this.ffthelper.setDamper((double)this.damperval);
            if (this.useSoniaSample) {
                this.mySample = new Sample("Parks.wav");
                this.mySample.connectLiveInput(true);
            }
        } else {
            this.init_sound(this.dataPath("Parks.mp3"));
            sunflower.println((String)"*** mp3 loaded");
        }
        this.tex = new XTexture("darkenv.jpg");
        this.grassTexture = new XTexture("flare2.png");
        this.flare3 = new XTexture("flare3.png");
        this.sunflower = new XTexture("sunflower3.png");
        this.we = new XTexture("we3_2.png");
        this.vs = new XTexture("vs3.png");
        this.eye = new Vector3();
        this.cam1 = new Vector3();
        this.cam2 = new Vector3();
        this.cam3 = new Vector3();
        this.cam4 = new Vector3();
        this.tar1 = new Vector3();
        this.tar2 = new Vector3();
        this.tar3 = new Vector3();
        this.tar4 = new Vector3();
        this.eye = this.cam1;
        this.target = this.tar1;
        this.buildSphere(60.0f, this.sphereStacks, this.sphereSlices, new Vector3(0.0f, 0.0f, 0.0f));
        this.sphereSurface2 = new Vector3[this.sphereSurface.length];
        this.sphereSurfaceNormal2 = new Vector3[this.sphereSurface.length];
        int n = 0;
        while (n < this.sphereSurface.length) {
            this.sphereSurface2[n] = new Vector3();
            this.sphereSurfaceNormal2[n] = new Vector3();
            ++n;
        }
        this.grasslines = new GrassLine[this.numGrass];
        n = 0;
        while (n < this.grasslines.length) {
            this.grasslines[n] = new GrassLine();
            this.grasslines[n].loadSegmentTexture("flare2.png", 2.0f);
            this.grasslines[n].loadLeafTexture("flare2.png", 8.0f);
            this.grasslines[n].init(n, new Vector3(this.random(-150.0f, 150.0f), -100.0f, this.random(-150.0f, 150.0f)), 15, this.random(100.0f, 150.0f));
            ++n;
        }
        this.rib = new Vector3(0.0f, 0.0f, 0.0f);
        this.rib.x = sunflower.sin((float)0.0f) * 200.0f;
        this.rib.y = sunflower.sin((float)0.0f) * 90.0f;
        this.rib.z = -100.0f + sunflower.cos((float)0.0f) * 200.0f;
        this.ribloc = new Vector3[this.ribCount];
        n = 0;
        while (n < this.ribloc.length) {
            this.ribloc[n] = new Vector3(this.rib);
            ++n;
        }
        this.sky = new SkyBox();
        this.sky.resize(512.0f);
        this.sky.offset(0.0f, 256.0f, 0.0f);
        this.overlay = new Overlay(this.gl._gl);
        this.gl._gl.glHint(3152, 4354);
        this.gl._gl.glEnable(2832);
        this.gl._gl.glEnable(2848);
        this.gl._gl.glHint(3154, 4354);
        if (!this.useSonia) {
            this.chn.play();
        }
        this.sTime = this.startTime = (float)this.millis() * 0.001f;
        sunflower.println((String)"--- initialization complete!");
        this.cTime = 0.0f;
        this.time = 0.0f;
    }

    public void draw() {
        this.time = ((float)this.millis() * 0.001f - this.startTime) * 0.5f;
        if (this.useSonia) {
            LiveInput.getSpectrum();
            this.ffthelper.update(LiveInput.spectrum);
            this.renderScene();
        } else {
            this.analyze(this.frequencyScale);
            this.renderScene();
            this.advance();
        }
    }

    public void renderScene() {
        this.cTime = (float)this.millis() * 0.001f - this.sTime;
        if (this.cTime > 8.0f) {
            this.cTime = 0.0f;
            this.sTime = (float)this.millis() * 0.001f;
            if (this.camIndex >= this.camId.length) {
                this.camIndex = this.camId.length - 1;
            }
            switch (this.camId[this.camIndex]) {
                case 1: {
                    this.eye = this.cam1;
                    this.target = this.tar1;
                    break;
                }
                case 2: {
                    this.eye = this.cam2;
                    this.target = this.tar2;
                    break;
                }
                case 3: {
                    this.eye = this.cam3;
                    this.target = this.tar3;
                    break;
                }
                case 4: {
                    this.eye = this.cam4;
                    this.target = this.tar4;
                    break;
                }
                default: {
                    this.eye = this.cam1;
                    this.target = this.tar1;
                }
            }
            ++this.camIndex;
        }
        this.lightPos.set(sunflower.sin((float)(this.time * 0.5f)) * 300.0f, 0.0f, sunflower.cos((float)(this.time * 0.5f)) * 300.0f);
        float cfr_ignored_0 = this.lightPos.x;
        float cfr_ignored_1 = this.lightPos.y;
        float cfr_ignored_2 = this.lightPos.z;
        this.cam1.set(sunflower.sin((float)(this.time * 0.15f)) * 400.0f, 100.0f, sunflower.cos((float)(this.time * 0.25f)) * 400.0f);
        this.cam2.set(sunflower.cos((float)(this.time * 0.05f)) * 400.0f, 400.0f, sunflower.sin((float)(this.time * 0.075f)) * 400.0f);
        this.cam3.set(sunflower.cos((float)(this.time * 0.015f)) * 200.0f, -90.0f, sunflower.sin((float)(this.time * 0.075f)) * 200.0f);
        this.cam4.set(sunflower.sin((float)(this.time * 0.05f)) * 400.0f, 300.0f, sunflower.cos((float)(this.time * 0.075f)) * 400.0f);
        this.tar4.set(this.grasslines[10].renderPoints[this.grasslines[10].numSegments - 1]);
        this.gl.begin();
        this.gl.background(0.0f, 0.0f, 0.0f, 1.0f);
        this.gl.perspective(90.0f, this.aspectRatio, 1.0f, 2000.0f);
        this.gl.camera(this.eye.x, this.eye.y, this.eye.z, this.target.x, this.target.y, this.target.z, 0.0f, 1.0f, 0.0f);
        this.gl._gl.glViewport(0, 0, this.width, this.height);
        this.gl._gl.glDisable(2884);
        this.renderSkyBox(this.eye);
        this.gl.perspective(45.0f, this.aspectRatio, 1.0f, 2000.0f);
        this.gl.camera(this.eye.x, this.eye.y, this.eye.z, this.target.x, this.target.y, this.target.z, 0.0f, 1.0f, 0.0f);
        this.gl._gl.glViewport(0, 0, this.width, this.height);
        this.gl.enableLighting(false);
        this.gl.setDepthWrite(true);
        this.gl.setDepthMask(false);
        this.gl.setAdditiveBlend();
        this.gl.pushMatrix();
        this.gl.translate(0.0f, -100.0f, 0.0f);
        this.gl.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        this.gl.rotate(this.time * 21.0f, 0.0f, 0.0f, 1.0f);
        this.tex.enable();
        this.gl.fill(1.0f, 1.0f * this.ffthelper.bandmax[5] * 10.0f);
        this.gl.rect(350.0f, 350.0f);
        this.gl.popMatrix();
        this.gl.pushMatrix();
        this.gl.translate(0.0f, -100.0f, 0.0f);
        this.gl.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
        this.gl.rotate(-this.time * 12.0f, 0.0f, 0.0f, 1.0f);
        this.gl.fill(1.0f, 0.51f);
        this.gl.rect(350.0f, 350.0f);
        this.tex.disable();
        this.gl.popMatrix();
        this.gl.setDepthMask(true);
        this.gl.setDepthWrite(true);
        this.gl.setAdditiveBlend();
        int n = 0;
        while (n < this.grasslines.length) {
            this.grasslines[n].draw(this.time);
            this.grasslines[n].update(this.time + (float)(n * 4));
            ++n;
        }
        this.gl.setDepthWrite(false);
        this.gl.setDepthMask(false);
        this.gl.setAdditiveBlend();
        this.rib.x = sunflower.sin((float)(this.time * 0.496f)) * 200.0f;
        this.rib.y = 50.0f + sunflower.sin((float)(this.time * 1.0f)) * 60.0f;
        this.rib.z = -100.0f + sunflower.cos((float)(this.time * 0.596f)) * 200.0f;
        n = this.ribloc.length - 1;
        while (n > 0) {
            this.ribloc[n].set(this.ribloc[n - 1]);
            --n;
        }
        this.ribloc[0].set(this.rib);
        this.renderMainTrail(this.ribloc.length);
        float f = 1.0f;
        this.gl.ortho(0.0f, this.width, 0.0f, this.height, -100.0f, 100.0f);
        if (this.time > 6.7f * f && this.time < 16.0f * f) {
            this.gl.setDepthWrite(false);
            this.gl.setDepthMask(false);
            this.gl.setAdditiveBlend();
            this.vs.enable();
            this.gl.pushMatrix();
            this.gl.fill(sunflower.sin((float)((this.time - 6.7f * f) * 0.5f)) * 0.92f);
            this.gl.rect((float)this.width * 0.85f + (this.time - 6.7f * f) * 5.0f, (float)this.height * 0.5f, 0.0f, 50.0f, 50.0f);
            this.gl.popMatrix();
            this.vs.disable();
            this.gl.setDepthWrite(true);
            this.gl.setDepthMask(true);
        }
        if (this.time > 20.0f * f && this.time < 58.0f * f) {
            this.gl.setDepthWrite(false);
            this.gl.setDepthMask(false);
            this.gl.setAdditiveBlend();
            this.we.enable();
            this.gl.pushMatrix();
            this.gl.fill(sunflower.sin((float)((this.time - 20.0f * f) * 0.25f)) * 0.92f);
            this.gl.rect((float)this.width * 0.85f + (this.time - 20.0f * f) * 4.0f, (float)this.height * 0.5f, 0.0f, 50.0f, 50.0f);
            this.gl.popMatrix();
            this.we.disable();
            this.gl.setDepthWrite(true);
            this.gl.setDepthMask(true);
        }
        this.gl.setDepthMask(true);
        this.gl.end();
    }

    public void renderSkyBox(Vector3 vector3) {
        this.gl.setDepthWrite(false);
        this.gl.pushMatrix();
        this.gl.translate(vector3);
        this.sky.draw();
        this.gl.popMatrix();
        this.gl.setDepthWrite(true);
    }

    public void renderMainTrail(int n) {
        this.gl._gl.glDisable(2884);
        this.flare3.enable();
        this.gl._gl.glBegin(8);
        int n2 = (int)((float)(n - 1) * 0.5f);
        int n3 = -n2;
        while (n3 < n2) {
            int n4 = n3 + n2;
            float f = 1.0f - (float)sunflower.abs((int)n3) / (float)n2;
            float f2 = this.ribloc[n4].x;
            float f3 = this.ribloc[n4].y;
            float f4 = this.ribloc[n4].z;
            if (n4 < n - 2) {
                Vector3 vector3 = Vector3.sub(this.ribloc[n4 + 1], this.ribloc[n4]);
                vector3.normalize();
                Vector3 vector32 = vector3.cross(new Vector3(0.0f, 1.0f, 0.0f));
                vector32.normalize();
                Vector3 vector33 = vector3.cross(vector32);
                vector33.normalize();
                vector32 = vector3.cross(vector33);
                vector32.normalize();
                float f5 = vector32.x * (float)this.ribWidth * f * 1.5f;
                float f6 = vector32.y * (float)this.ribWidth * f * 1.5f;
                float f7 = vector32.z * (float)this.ribWidth * f * 1.5f;
                this.gl._gl.glColor4f(f, f, f, f);
                this.gl._gl.glTexCoord2f(0.0f, 0.0f);
                this.gl._gl.glVertex3f(f2 - f5, f3 - f6, f4 - f7);
                this.gl._gl.glTexCoord2f(1.0f, 1.0f);
                this.gl._gl.glVertex3f(f2 + f5, f3 + f6, f4 + f7);
            }
            ++n3;
        }
        this.gl._gl.glEnd();
        this.flare3.disable();
    }

    public Matrix createBillBoardMatrix() {
        Matrix matrix = new Matrix();
        matrix = this.gl.getMatrix(1);
        matrix._M[0] = 1.0f;
        matrix._M[1] = 0.0f;
        matrix._M[2] = 0.0f;
        matrix._M[3] = 0.0f;
        matrix._M[4] = 0.0f;
        matrix._M[5] = 1.0f;
        matrix._M[6] = 0.0f;
        matrix._M[7] = 0.0f;
        return matrix;
    }

    public void glReverseCamera(Vector3 vector3, Vector3 vector32) {
        float f = vector3.x - vector32.x;
        float f2 = vector3.y - vector32.y;
        float f3 = vector3.z - vector32.z;
        float f4 = sunflower.atan2((float)f2, (float)f);
        float f5 = sunflower.sqrt((float)(sunflower.sq((float)f) + sunflower.sq((float)f2)));
        float f6 = sunflower.atan2((float)f5, (float)f3);
        this.gl._gl.glRotatef(sunflower.degrees((float)f4), 0.0f, 0.0f, 1.0f);
        this.gl._gl.glRotatef(sunflower.degrees((float)f6), 0.0f, 1.0f, 0.0f);
    }

    public void renderImageOnFloor(Vector3 vector3, float f, float f2) {
        this.gl.pushMatrix();
        this.gl.translate(vector3);
        this.gl.rotate(90.0f, 1.0f, 0.0f, 0.0f);
        this.gl.scale(f, f, f);
        this.gl.fill(1.0f, f2);
        this.gl.quad(1.0f);
        this.gl.popMatrix();
    }

    public void stop() {
        if (this.useSonia) {
            Sonia.stop();
        } else {
            this.stop_sound();
        }
        super.stop();
    }

    public void init_sound(String string) {
        Ess.start((PApplet)this);
        Ess.masterVolume((float)1.0f);
        sunflower.println((String)("loading " + string));
        this.chn = new AudioChannel(string);
        this.fft = new FFT(this.spectrumLength * 2);
        this.fft.limits();
        this.ffthelper = new SoniaHelper(this.spectrumLength, 256, false);
        this.ffthelper.setMaxLimits(200.0f, 2000.0f);
        this.damperval = 0.62f;
        this.ffthelper.setDamper((double)this.damperval);
        this.fftbuffer = new float[this.spectrumLength];
    }

    public void play_sound() {
        this.chn.play();
    }

    public void analyze(float f) {
        this.fft.getSpectrum((AudioOutput)this.chn);
        int n = 0;
        while (n < this.fft.spectrum.length) {
            this.fftbuffer[n] = this.fft.spectrum[n] * f;
            ++n;
        }
        this.ffthelper.update(this.fftbuffer);
    }

    public void store() {
        this.saveFrame(String.valueOf(this.directory) + "i_" + sunflower.nf((int)this.frameNumber, (int)7) + this.extension);
    }

    public void advance() {
        ++this.frameNumber;
    }

    public void stop_sound() {
        this.chn.stop();
        Ess.stop();
    }

    public void quad(GL gL, float f, float f2, float f3) {
        gL.glBegin(7);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        gL.glColor4f(1.0f, 1.0f, 1.0f, f3);
        gL.glTexCoord2f(0.0f, 0.0f);
        gL.glVertex3f(-1.0f * f, 1.0f * f, f2);
        gL.glTexCoord2f(1.0f, 0.0f);
        gL.glVertex3f(1.0f * f, 1.0f * f, f2);
        gL.glTexCoord2f(1.0f, 1.0f);
        gL.glVertex3f(1.0f * f, -1.0f * f, f2);
        gL.glTexCoord2f(0.0f, 1.0f);
        gL.glVertex3f(-1.0f * f, -1.0f * f, f2);
        gL.glEnd();
    }

    public void quad(GL gL, float f, float f2, float f3, float f4) {
        gL.glBegin(7);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        gL.glColor4f(1.0f, 1.0f, 1.0f, f4);
        gL.glTexCoord2f(0.0f * f3, 0.0f * f3);
        gL.glVertex3f(-1.0f * f, 1.0f * f, f2);
        gL.glTexCoord2f(1.0f * f3, 0.0f * f3);
        gL.glVertex3f(1.0f * f, 1.0f * f, f2);
        gL.glTexCoord2f(1.0f * f3, 1.0f * f3);
        gL.glVertex3f(1.0f * f, -1.0f * f, f2);
        gL.glTexCoord2f(0.0f * f3, 1.0f * f3);
        gL.glVertex3f(-1.0f * f, -1.0f * f, f2);
        gL.glEnd();
    }

    public void rect(GL gL, float f, float f2, float f3) {
        gL.glBegin(7);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL.glTexCoord2f(0.0f, 0.0f);
        gL.glVertex3f(-1.0f * f, -1.0f * f2, f3);
        gL.glTexCoord2f(1.0f, 0.0f);
        gL.glVertex3f(1.0f * f, -1.0f * f2, f3);
        gL.glTexCoord2f(1.0f, 1.0f);
        gL.glVertex3f(1.0f * f, 1.0f * f2, f3);
        gL.glTexCoord2f(0.0f, 1.0f);
        gL.glVertex3f(-1.0f * f, 1.0f * f2, f3);
        gL.glEnd();
    }

    public void box(float f, float f2, float f3) {
        Vector3 vector3 = new Vector3(-f, -f2, -f3);
        Vector3 vector32 = new Vector3(f, f2, f3);
        this.gl._gl.glBegin(3);
        this.gl._gl.glVertex3f(vector3.x, vector3.y, vector3.z);
        this.gl._gl.glVertex3f(vector32.x, vector3.y, vector3.z);
        this.gl._gl.glVertex3f(vector32.x, vector3.y, vector32.z);
        this.gl._gl.glVertex3f(vector3.x, vector3.y, vector32.z);
        this.gl._gl.glVertex3f(vector3.x, vector3.y, vector3.z);
        this.gl._gl.glVertex3f(vector3.x, vector32.y, vector3.z);
        this.gl._gl.glVertex3f(vector32.x, vector32.y, vector3.z);
        this.gl._gl.glVertex3f(vector32.x, vector32.y, vector32.z);
        this.gl._gl.glVertex3f(vector3.x, vector32.y, vector32.z);
        this.gl._gl.glVertex3f(vector3.x, vector32.y, vector3.z);
        this.gl._gl.glEnd();
        this.gl._gl.glBegin(1);
        this.gl._gl.glVertex3f(vector32.x, vector3.y, vector3.z);
        this.gl._gl.glVertex3f(vector32.x, vector32.y, vector3.z);
        this.gl._gl.glEnd();
        this.gl._gl.glBegin(1);
        this.gl._gl.glVertex3f(vector32.x, vector3.y, vector32.z);
        this.gl._gl.glVertex3f(vector32.x, vector32.y, vector32.z);
        this.gl._gl.glEnd();
        this.gl._gl.glBegin(1);
        this.gl._gl.glVertex3f(vector3.x, vector3.y, vector32.z);
        this.gl._gl.glVertex3f(vector3.x, vector32.y, vector32.z);
        this.gl._gl.glEnd();
    }

    public void buildSphere(float f, int n, int n2, Vector3 vector3) {
        int n3;
        float f2 = f;
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3();
        int n4 = n2;
        int n5 = (n + 1) * n2;
        this.sphereSurface = new Vector3[n5];
        this.sphereSurfaceNormal = new Vector3[n5];
        this.sphereSurfaceUV = new Vector3[n5];
        int n6 = 0;
        while (n6 < n5) {
            this.sphereSurface[n6] = new Vector3();
            this.sphereSurfaceNormal[n6] = new Vector3();
            this.sphereSurfaceUV[n6] = new Vector3();
            ++n6;
        }
        n6 = 0;
        while (n6 < n + 1) {
            n3 = 0;
            while (n3 < n2) {
                float f3 = (float)n6 * (float)Math.PI / (float)n;
                float f4 = (float)(n3 * 2) * (float)Math.PI / (float)n2;
                float f5 = sunflower.sin((float)f3);
                float f6 = sunflower.sin((float)f4);
                float f7 = sunflower.cos((float)f3);
                float f8 = sunflower.cos((float)f4);
                float f9 = (float)(12 * n3) / PApplet.parseFloat((int)n2);
                float f10 = (float)(12 * n6) / PApplet.parseFloat((int)n);
                vector32.x = f8 * f5;
                vector32.y = f7;
                vector32.z = f6 * f5;
                vector33.x = vector3.x + f2 * vector32.x;
                vector33.y = vector3.y + f2 * vector32.y;
                vector33.z = vector3.z + f2 * vector32.z;
                this.sphereSurface[n6 * n4 + n3].x = vector33.x;
                this.sphereSurface[n6 * n4 + n3].y = vector33.y;
                this.sphereSurface[n6 * n4 + n3].z = vector33.z;
                this.sphereSurfaceNormal[n6 * n4 + n3].x = vector32.x;
                this.sphereSurfaceNormal[n6 * n4 + n3].y = vector32.y;
                this.sphereSurfaceNormal[n6 * n4 + n3].z = vector32.z;
                this.sphereSurfaceUV[n6 * n4 + n3].x = f9;
                this.sphereSurfaceUV[n6 * n4 + n3].y = f10;
                ++n3;
            }
            ++n6;
        }
        n3 = 0;
        while (n3 < n + 1) {
            this.sphereSurface[n3 * n2 + n2 - 1].x = this.sphereSurface[n3 * n2 + 0].x;
            this.sphereSurface[n3 * n2 + n2 - 1].y = this.sphereSurface[n3 * n2 + 0].y;
            this.sphereSurface[n3 * n2 + n2 - 1].z = this.sphereSurface[n3 * n2 + 0].z;
            ++n3;
        }
        this.sphereIndices = new int[n5 * 2];
        int n7 = 0;
        n6 = 0;
        while (n6 < n) {
            n3 = 0;
            while (n3 < n2) {
                this.sphereIndices[n7 + 0] = n6 * n2 + n3 % n2;
                this.sphereIndices[n7 + 0] = (n6 + 1) * n2 + n3 % n2;
                ++n3;
            }
            ++n6;
        }
    }

    public void sphere(float f, int n, boolean bl) {
        int n2 = n;
        float f2 = 1.0f / (float)n2;
        float f3 = f;
        float f4 = (float)Math.PI;
        float f5 = 1.5707964f;
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3();
        if (!bl) {
            this.gl._gl.glPolygonMode(1032, 6913);
        }
        int n3 = 0;
        while (n3 < n2 * 2) {
            double d = -f5 + (float)n3 * f4 * (f2 * 0.5f);
            double d2 = -f5 + (float)(n3 + 1) * f4 * (f2 * 0.5f);
            this.gl._gl.glBegin(8);
            this.gl._gl.glColor4f(this.gl._r, this.gl._g, this.gl._b, this.gl._a);
            int n4 = 0;
            while (n4 <= n2) {
                double d3 = (float)n4 * f4 * 2.0f * f2;
                vector3.x = (float)Math.cos(d) * (float)Math.cos(d3);
                vector3.y = (float)Math.sin(d);
                vector3.z = (float)Math.cos(d) * (float)Math.sin(d3);
                vector32.x = vector33.x + f3 * vector3.x;
                vector32.y = vector33.y + f3 * vector3.y;
                vector32.z = vector33.z + f3 * vector3.z;
                this.gl._gl.glNormal3f(vector3.x, vector3.y, vector3.z);
                this.gl._gl.glTexCoord2f((float)(4 * n4) * f2, (float)(4 * n3) * f2);
                this.gl._gl.glVertex3f(vector32.x, vector32.y, vector32.z);
                vector3.x = (float)Math.cos(d2) * (float)Math.cos(d3);
                vector3.y = (float)Math.sin(d2);
                vector3.z = (float)Math.cos(d2) * (float)Math.sin(d3);
                vector32.x = vector33.x + f3 * vector3.x;
                vector32.y = vector33.y + f3 * vector3.y;
                vector32.z = vector33.z + f3 * vector3.z;
                this.gl._gl.glNormal3f(vector3.x, vector3.y, vector3.z);
                this.gl._gl.glTexCoord2f((float)(4 * n4) * f2, (float)(4 * (n3 + 1)) * f2);
                this.gl._gl.glVertex3f(vector32.x, vector32.y, vector32.z);
                ++n4;
            }
            this.gl._gl.glEnd();
            ++n3;
        }
        if (!bl) {
            this.gl._gl.glPolygonMode(1032, 6914);
        }
    }

    public void setupPointLight(Vector3 vector3) {
        GL gL = this.gl._gl;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float[] fArray2 = new float[]{0.01f, 0.01f, 0.01f, 0.0f};
        float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] fArray5 = new float[]{24.0f};
        float[] fArray6 = new float[]{vector3.x, vector3.y, vector3.z, 1.0f};
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray2);
        gL.glLightfv(16385, 4608, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray3);
        gL.glLightfv(16385, 4609, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray4);
        gL.glLightfv(16385, 4610, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray6);
        gL.glLightfv(16385, 4611, floatBuffer);
        gL.glEnable(16385);
        gL.glEnable(2896);
        gL.glEnable(2903);
        floatBuffer = FloatBuffer.wrap(fArray);
        gL.glMaterialfv(1032, 4608, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray3);
        gL.glMaterialfv(1032, 4609, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray5);
        gL.glMaterialfv(1032, 5633, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray4);
        gL.glMaterialfv(1032, 4610, floatBuffer);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"sunflower"});
    }

    public class FFTHelper {
        public int num;
        public int numbands;
        public float[] spectrum;
        public float[] ttv;
        public double[] v;
        private double[] tv;
        double dampUp;
        double dampDown;
        double mult;
        boolean doDampen = false;
        boolean doDampenAsymm = false;
        boolean doAverage = false;
        boolean isFirstTime = true;
        boolean doNorm = false;
        public double maxinternal;
        public float max;
        public float maxMinimum;
        public float maxMaximum;
        double maxD;
        int maxCnt;
        double[] bandv;
        public float[] band;
        public float[] bandmax;
        public int bandsteps;

        public FFTHelper(int n, int n2, boolean bl) {
            this.num = n;
            this.numbands = n2;
            this.spectrum = new float[this.num];
            this.v = new double[this.num];
            this.tv = new double[this.num];
            this.ttv = new float[this.num];
            this.doAverage = bl;
            this.doNorm = true;
            this.mult = 1.0;
            this.maxMinimum = 200.0f;
            this.maxMaximum = 2000.0f;
            this.maxinternal = this.maxMinimum;
            this.maxCnt = 0;
            this.bandsteps = 256 / this.numbands;
            this.band = new float[this.numbands];
            this.bandv = new double[this.numbands];
            this.bandmax = new float[this.numbands];
        }

        public void setMaxLimits(float f, float f2) {
            this.maxMinimum = f;
            this.maxMaximum = f2;
        }

        public void setDamper(double d, double d2) {
            this.dampUp = d;
            this.dampDown = d2;
            this.doDampen = this.dampUp != -1.0;
            this.doDampenAsymm = true;
        }

        public void setDamper(double d) {
            this.setDamper(d, d);
            this.doDampenAsymm = false;
        }

        public float dampenVal(double d, double d2) {
            d = this.doDampenAsymm ? (d > d2 ? d2 * this.dampDown + d * (1.0 - this.dampDown) : d2 * this.dampUp + d * (1.0 - this.dampUp)) : d2 * this.dampUp + d * (1.0 - this.dampUp);
            return (float)d;
        }

        public void update(float[] fArray) {
            int n;
            int n2;
            if (this.isFirstTime) {
                this.isFirstTime = false;
            }
            if (this.doAverage) {
                this.tv[0] = (fArray[0] + fArray[1]) * 0.5f;
                this.tv[this.num - 1] = (fArray[this.num - 1] + fArray[this.num - 2]) * 0.5f;
                n2 = 1;
                while (n2 < this.num - 1) {
                    this.tv[n2] = (fArray[n2 - 1] + fArray[n2] + fArray[n2 + 1]) * 0.333f;
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < this.num) {
                    this.tv[n2] = fArray[n2];
                    ++n2;
                }
            }
            if (this.doDampen && !this.isFirstTime) {
                if (this.doDampenAsymm) {
                    n2 = 0;
                    while (n2 < this.num) {
                        this.v[n2] = this.v[n2] > this.tv[n2] ? this.tv[n2] * this.dampDown + this.v[n2] * (1.0 - this.dampDown) : this.tv[n2] * this.dampUp + this.v[n2] * (1.0 - this.dampUp);
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.num) {
                        this.v[n2] = this.tv[n2] * this.dampUp + this.v[n2] * (1.0 - this.dampUp);
                        if (this.v[n2] > (double)this.maxMaximum) {
                            this.v[n2] = this.maxMaximum;
                        }
                        ++n2;
                    }
                }
            } else {
                System.arraycopy(this.tv, 0, this.v, 0, this.num);
            }
            if (this.doNorm) {
                double d = 0.0;
                double d2 = 0.0;
                if (this.maxCnt > 0) {
                    this.maxinternal += this.maxD;
                    --this.maxCnt;
                }
                n = 0;
                while (n < this.num) {
                    if (this.v[n] > this.maxinternal) {
                        this.maxinternal = this.v[n];
                        this.maxD = (this.v[n] - this.maxinternal) / 4.0;
                        this.maxCnt = 4;
                        this.maxinternal += this.maxD;
                        --this.maxCnt;
                    }
                    d2 += this.v[n];
                    if (this.v[n] > d) {
                        d = this.v[n];
                    }
                    ++n;
                }
                if (d > (double)this.maxMaximum) {
                    d = this.maxMaximum;
                }
                if (this.maxinternal > (double)this.maxMinimum && this.maxCnt == 0) {
                    this.maxinternal = d * (double)0.005f + this.maxinternal * (double)0.995f;
                } else if (this.maxinternal > (double)this.maxMaximum) {
                    this.maxinternal = this.maxMaximum;
                }
                d2 /= (double)this.num;
                n = 0;
                while (n < this.num) {
                    this.spectrum[n] = (float)(this.v[n] / this.maxinternal);
                    if (this.spectrum[n] > 1.0f) {
                        this.spectrum[n] = 1.0f;
                    }
                    ++n;
                }
                this.max = (float)this.maxinternal;
            } else {
                n2 = 0;
                while (n2 < this.num) {
                    this.spectrum[n2] = (float)this.v[n2];
                    ++n2;
                }
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.numbands) {
                double d = this.bandv[n4];
                this.bandv[n4] = 0.0;
                n = 0;
                while (n < this.bandsteps) {
                    int n5 = n4;
                    this.bandv[n5] = this.bandv[n5] + (double)this.spectrum[n3++];
                    ++n;
                }
                int n6 = n4;
                this.bandv[n6] = this.bandv[n6] / (double)this.bandsteps;
                this.bandv[n4] = this.dampenVal(d, this.bandv[n4]);
                if ((double)this.bandmax[n4] < this.bandv[n4]) {
                    this.bandmax[n4] = (float)this.bandv[n4];
                } else {
                    int n7 = n4;
                    this.bandmax[n7] = this.bandmax[n7] * 0.995f;
                }
                this.band[n4] = (float)this.bandv[n4];
                ++n4;
            }
        }

        public void update(float[] fArray, int n, int n2) {
            System.arraycopy(fArray, n, this.ttv, 0, n2);
            this.update(this.ttv);
        }

        public void updateBands(float[] fArray, int n) {
            int n2 = fArray.length / n;
            float f = 0.0f;
            int n3 = 0;
            while (n3 < n2) {
                f = 0.0f;
                int n4 = 0;
                while (n4 < n2) {
                    f += fArray[n3 * n2 + n4];
                    ++n4;
                }
                this.ttv[n3] = f / (float)n2;
                ++n3;
            }
            this.update(this.ttv);
        }

        public double checkBandMax(int n) {
            return this.bandmax[n / this.bandsteps];
        }
    }

    class GrassLine {
        int id;
        float ysize;
        int numSegments;
        float segStep;
        Vector3 origin;
        Vector3[] points;
        Vector3[] renderPoints;
        boolean isSunflower;
        float leafTextureSize;
        XTexture leafTexture;
        float segTextureSize;
        XTexture segTexture;

        GrassLine() {
        }

        public void init(int n, Vector3 vector3, int n2, float f) {
            this.isSunflower = false;
            this.id = n;
            this.numSegments = n2;
            this.ysize = f;
            if (n % 10 == 0 && n <= 10) {
                this.isSunflower = true;
            }
            this.origin = new Vector3(vector3);
            this.points = new Vector3[n2];
            this.renderPoints = new Vector3[n2];
            this.points[0] = new Vector3(vector3);
            this.renderPoints[0] = this.points[0].copy();
            int n3 = 1;
            while (n3 < this.numSegments) {
                float f2;
                this.points[n3] = new Vector3();
                this.segStep = f2 = (float)n3 / (float)this.numSegments * f;
                this.points[n3].x = vector3.x;
                this.points[n3].y = vector3.y + f2;
                this.points[n3].z = vector3.z;
                this.renderPoints[n3] = this.points[n3].copy();
                ++n3;
            }
        }

        public void loadLeafTexture(String string, float f) {
            this.leafTextureSize = f;
        }

        public void loadSegmentTexture(String string, float f) {
            this.segTextureSize = f;
        }

        public void draw(float f) {
            sunflower.this.gl.fill(1.0f, sunflower.sq((float)sunflower.this.ffthelper.bandmax[this.id % 255]) * 5.0f);
            sunflower.this.gl.enableLighting(false);
            sunflower.this.gl.enableTexture(false);
            sunflower.this.gl.setDepthWrite(true);
            sunflower.this.gl.setAdditiveBlend();
            sunflower.this.gl._gl.glBegin(3);
            sunflower.this.gl._gl.glColor4f(sunflower.this.gl._r, sunflower.this.gl._g, sunflower.this.gl._b, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this.renderPoints[0].x, this.renderPoints[0].y, this.renderPoints[0].z);
            int n = 0;
            n = this.id % 10 == 0 && this.id <= 10 ? 1 : 0;
            int n2 = 1;
            while (n2 < this.numSegments - n) {
                float f2 = 1.0f - (float)n2 / (float)this.numSegments;
                sunflower.this.gl._gl.glColor4f(sunflower.this.gl._r, sunflower.this.gl._g, sunflower.this.gl._b, sunflower.this.gl._a * f2);
                sunflower.this.gl._gl.glVertex3f(this.renderPoints[n2].x, this.renderPoints[n2].y, this.renderPoints[n2].z);
                ++n2;
            }
            sunflower.this.gl._gl.glEnd();
            sunflower.this.gl.setAdditiveBlend();
            sunflower.this.gl.setDepthWrite(false);
            sunflower.this.gl.enableTexture(true);
            sunflower.this.grassTexture.enable();
            n2 = 1;
            while (n2 < this.numSegments - 1) {
                Vector3 vector3 = this.renderPoints[n2].copy();
                sunflower.this.gl.pushMatrix();
                sunflower.this.gl.translate(vector3);
                sunflower.this.glReverseCamera(sunflower.this.eye, sunflower.this.target);
                sunflower.this.gl.quad(0.0f, 0.0f, 0.0f, this.segTextureSize);
                sunflower.this.gl.popMatrix();
                ++n2;
            }
            sunflower.this.grassTexture.disable();
            if (this.isSunflower) {
                sunflower.this.sunflower.enable();
            } else {
                sunflower.this.grassTexture.enable();
            }
            sunflower.this.gl.pushMatrix();
            sunflower.this.gl.translate(this.renderPoints[this.numSegments - 1]);
            sunflower.this.glReverseCamera(sunflower.this.eye, sunflower.this.target);
            if (this.isSunflower) {
                sunflower.this.gl.quad(0.0f, 0.0f, 0.0f, this.leafTextureSize + sunflower.this.gl._a * 2.0f);
            } else {
                sunflower.this.gl.quad(0.0f, 0.0f, 0.0f, this.leafTextureSize + sunflower.this.gl._a);
            }
            sunflower.this.gl.popMatrix();
            sunflower.this.sunflower.disable();
            sunflower.this.grassTexture.enable();
            n2 = 0;
            while (n2 < this.numSegments) {
                sunflower.this.renderImageOnFloor(this.origin, 125.0f * sunflower.this.ffthelper.bandmax[this.id % 255], 0.015f);
                ++n2;
            }
            sunflower.this.flare3.disable();
        }

        public void update(float f) {
            float cfr_ignored_0 = sunflower.sq((float)sunflower.this.ffthelper.band[this.id % 255]) * 60.0f;
            float f2 = this.id % 10 == 0 ? sunflower.this.ffthelper.bandmax[this.id % 255] * 60.0f * 1.5f : sunflower.sq((float)sunflower.this.ffthelper.bandmax[this.id % 255]) * 60.0f;
            int n = 1;
            while (n < this.numSegments) {
                this.renderPoints[n].x = this.points[n].x + sunflower.sin((float)((float)n * 0.3f + f)) * (float)n;
                this.renderPoints[n].y = this.points[n].y + f2;
                this.renderPoints[n].z = this.isSunflower ? this.points[n].z + sunflower.cos((float)((float)n * 0.2f + f + f2 * 0.15f)) * (float)n * 0.5f : this.points[n].z + sunflower.cos((float)((float)n * 0.2f + f + f2 * 0.15f)) * (float)n * 0.5f;
                ++n;
            }
        }
    }

    class Overlay {
        GL _gl;

        Overlay(GL gL) {
            this._gl = gL;
        }

        public void setOrtho() {
            this._gl.glMatrixMode(5889);
            this._gl.glPushMatrix();
            this._gl.glLoadIdentity();
            this._gl.glOrtho(0.0, (double)sunflower.this.width, 0.0, (double)sunflower.this.height, -100.0, 100.0);
            this._gl.glMatrixMode(5888);
            this._gl.glPushMatrix();
            this._gl.glLoadIdentity();
        }

        public void unsetOrtho() {
            this._gl.glMatrixMode(5889);
            this._gl.glPopMatrix();
            this._gl.glMatrixMode(5888);
            this._gl.glPopMatrix();
        }

        public void draw(int n) {
            sunflower.this.gl._gl.glBegin(7);
            sunflower.this.gl._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            sunflower.this.gl._gl.glColor4f(sunflower.this.gl._r, sunflower.this.gl._g, sunflower.this.gl._b, sunflower.this.gl._a);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 0.0f);
            sunflower.this.gl._gl.glVertex2f(0.0f, 0.0f);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 0.0f);
            sunflower.this.gl._gl.glVertex2f((float)sunflower.this.width, 0.0f);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 1.0f);
            sunflower.this.gl._gl.glVertex2f((float)sunflower.this.width, (float)sunflower.this.height);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 1.0f);
            sunflower.this.gl._gl.glVertex2f(0.0f, (float)sunflower.this.height);
            sunflower.this.gl._gl.glEnd();
        }
    }

    class SkyBox {
        Vector3[] _V;
        XTexture[] _Tex;

        SkyBox() {
            int n = 5;
            this._V = new Vector3[8];
            this._Tex = new XTexture[n];
            String string = "starfield/";
            this._Tex[0] = new XTexture(sunflower.this.dataPath(String.valueOf(string) + "_front.jpg"));
            this._Tex[1] = new XTexture(sunflower.this.dataPath(String.valueOf(string) + "_back.jpg"));
            this._Tex[2] = new XTexture(sunflower.this.dataPath(String.valueOf(string) + "_left.jpg"));
            this._Tex[3] = new XTexture(sunflower.this.dataPath(String.valueOf(string) + "_right.jpg"));
            this._Tex[4] = new XTexture(sunflower.this.dataPath(String.valueOf(string) + "_top.jpg"));
            int n2 = 0;
            while (n2 < this._Tex.length) {
                this._Tex[n2].setClampToEdge();
                ++n2;
            }
            this._V[0] = new Vector3(-1.0f, 1.0f, 1.0f);
            this._V[1] = new Vector3(1.0f, 1.0f, 1.0f);
            this._V[2] = new Vector3(1.0f, -1.0f, 1.0f);
            this._V[3] = new Vector3(-1.0f, -1.0f, 1.0f);
            this._V[4] = new Vector3(-1.0f, 1.0f, -1.0f);
            this._V[5] = new Vector3(1.0f, 1.0f, -1.0f);
            this._V[6] = new Vector3(1.0f, -1.0f, -1.0f);
            this._V[7] = new Vector3(-1.0f, -1.0f, -1.0f);
        }

        public void draw() {
            this._Tex[0].enable();
            sunflower.this.gl._gl.glBegin(7);
            sunflower.this.gl._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            sunflower.this.gl._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[0].x, this._V[0].y, this._V[0].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[1].x, this._V[1].y, this._V[1].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[2].x, this._V[2].y, this._V[2].z);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[3].x, this._V[3].y, this._V[3].z);
            sunflower.this.gl._gl.glEnd();
            this._Tex[0].disable();
            this._Tex[1].enable();
            sunflower.this.gl._gl.glBegin(7);
            sunflower.this.gl._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            sunflower.this.gl._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[4].x, this._V[4].y, this._V[4].z);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[5].x, this._V[5].y, this._V[5].z);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[6].x, this._V[6].y, this._V[6].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[7].x, this._V[7].y, this._V[7].z);
            sunflower.this.gl._gl.glEnd();
            this._Tex[1].disable();
            this._Tex[2].enable();
            sunflower.this.gl._gl.glBegin(7);
            sunflower.this.gl._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            sunflower.this.gl._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[4].x, this._V[4].y, this._V[4].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[0].x, this._V[0].y, this._V[0].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[3].x, this._V[3].y, this._V[3].z);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[7].x, this._V[7].y, this._V[7].z);
            sunflower.this.gl._gl.glEnd();
            this._Tex[2].disable();
            this._Tex[3].enable();
            sunflower.this.gl._gl.glBegin(7);
            sunflower.this.gl._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            sunflower.this.gl._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[1].x, this._V[1].y, this._V[1].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[5].x, this._V[5].y, this._V[4].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[6].x, this._V[6].y, this._V[6].z);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[2].x, this._V[2].y, this._V[2].z);
            sunflower.this.gl._gl.glEnd();
            this._Tex[3].disable();
            this._Tex[4].enable();
            sunflower.this.gl._gl.glBegin(7);
            sunflower.this.gl._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            sunflower.this.gl._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[0].x, -this._V[0].y, this._V[0].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 0.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[1].x, -this._V[1].y, this._V[1].z);
            sunflower.this.gl._gl.glTexCoord2f(1.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[5].x, -this._V[5].y, this._V[5].z);
            sunflower.this.gl._gl.glTexCoord2f(0.0f, 1.0f);
            sunflower.this.gl._gl.glVertex3f(this._V[4].x, -this._V[4].y, this._V[4].z);
            sunflower.this.gl._gl.glEnd();
            this._Tex[4].disable();
        }

        public void resize(float f) {
            int n = 0;
            while (n < this._V.length) {
                this._V[n].mul(f * -1.0f);
                ++n;
            }
        }

        public void offset(float f, float f2, float f3) {
            int n = 0;
            while (n < this._V.length) {
                this._V[n].add(f, f2, f3);
                ++n;
            }
        }
    }

    class XGL {
        PGraphicsOpenGL _pgl;
        GL _gl;
        GLU _glu;
        PApplet _parent;
        float _r;
        float _g;
        float _b;
        float _a;

        XGL(PApplet pApplet) {
            this._parent = pApplet;
            this._pgl = (PGraphicsOpenGL)sunflower.this.g;
            this._gl = this._pgl.gl;
            this._glu = ((PGraphicsOpenGL)sunflower.this.g).glu;
        }

        public void begin() {
            this._gl = ((PGraphicsOpenGL)sunflower.this.g).beginGL();
            this._glu = ((PGraphicsOpenGL)sunflower.this.g).glu;
        }

        public void end() {
            ((PGraphicsOpenGL)sunflower.this.g).endGL();
        }

        public void background(float f) {
            this._gl.glClearColor(f, f, f, 1.0f);
            this._gl.glClear(16640);
        }

        public void background(float f, float f2, float f3, float f4) {
            this._gl.glClear(16640);
            this._gl.glClearColor(f, f2, f3, f4);
        }

        public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
            this._gl.glMatrixMode(5889);
            this._gl.glLoadIdentity();
            this._gl.glOrtho((double)f, (double)f2, (double)f4, (double)f3, (double)f5, (double)f6);
            this._gl.glMatrixMode(5888);
            this._gl.glLoadIdentity();
        }

        public void ortho() {
            this._gl.glMatrixMode(5888);
            this._gl.glLoadIdentity();
            this._gl.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        }

        public void perspective(float f, float f2, float f3, float f4) {
            this._gl.glMatrixMode(5889);
            this._gl.glLoadIdentity();
            this._glu.gluPerspective((double)f, (double)f2, (double)f3, (double)f4);
        }

        public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
            this._gl.glMatrixMode(5888);
            this._gl.glLoadIdentity();
            this._glu.gluLookAt((double)f, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8, (double)f9);
        }

        public void setMatrixMode(int n) {
            switch (n) {
                case 0: {
                    this._gl.glMatrixMode(5889);
                    this._gl.glLoadIdentity();
                    break;
                }
                case 1: {
                    this._gl.glMatrixMode(5888);
                    this._gl.glLoadIdentity();
                    break;
                }
                default: {
                    this._gl.glMatrixMode(5888);
                    this._gl.glLoadIdentity();
                }
            }
        }

        public Matrix getMatrix(int n) {
            Matrix matrix = new Matrix();
            matrix.identity();
            if (n == 0) {
                this._gl.glGetFloatv(2983, matrix.getFloatBuffer());
            } else {
                this._gl.glGetFloatv(2982, matrix.getFloatBuffer());
            }
            return matrix;
        }

        public void translate(float f, float f2, float f3) {
            this._gl.glTranslatef(f, f2, f3);
        }

        public void translate(Vector3 vector3) {
            this._gl.glTranslatef(vector3.x, vector3.y, vector3.z);
        }

        public void rotate(float f, float f2, float f3, float f4) {
            this._gl.glRotatef(f, f2, f3, f4);
        }

        public void rotate(float f, Vector3 vector3) {
            this._gl.glRotatef(f, vector3.x, vector3.y, vector3.z);
        }

        public void rotateX(float f) {
            this._gl.glRotatef(f, 1.0f, 0.0f, 0.0f);
        }

        public void rotateY(float f) {
            this._gl.glRotatef(f, 0.0f, 1.0f, 0.0f);
        }

        public void rotateZ(float f) {
            this._gl.glRotatef(f, 0.0f, 0.0f, 1.0f);
        }

        public void scale(float f, float f2, float f3) {
            this._gl.glScalef(f, f2, f3);
        }

        public void scale(float f) {
            this._gl.glScalef(f, f, f);
        }

        public void loadMatrix(FloatBuffer floatBuffer) {
            this._gl.glLoadMatrixf(floatBuffer);
        }

        public void multMatrix(FloatBuffer floatBuffer) {
            this._gl.glMultMatrixf(floatBuffer);
        }

        public void multMatrix(Matrix matrix) {
            FloatBuffer floatBuffer = FloatBuffer.wrap(matrix._M);
            this._gl.glMultMatrixf(floatBuffer);
        }

        public void pushMatrix() {
            this._gl.glPushMatrix();
        }

        public void popMatrix() {
            this._gl.glPopMatrix();
        }

        public void enableBlend() {
            this._gl.glEnable(3042);
        }

        public void disableBlend() {
            this._gl.glDisable(3042);
        }

        public void setBlend(boolean bl) {
            if (bl) {
                this._gl.glEnable(3042);
            } else {
                this._gl.glDisable(3042);
            }
        }

        public void setAlphaBlend() {
            this._gl.glBlendFunc(770, 771);
        }

        public void setAdditiveBlend() {
            this._gl.glBlendFunc(770, 1);
        }

        public void setOneBlend() {
            this._gl.glBlendFunc(1, 1);
        }

        public void enableLighting(boolean bl) {
            if (bl) {
                this._gl.glEnable(2896);
            } else {
                this._gl.glDisable(2896);
            }
        }

        public void enableTexture(boolean bl) {
            if (bl) {
                this._gl.glEnable(3553);
            } else {
                this._gl.glDisable(3553);
            }
        }

        public void setDepthWrite(boolean bl) {
            if (bl) {
                this._gl.glEnable(2929);
            } else {
                this._gl.glDisable(2929);
            }
        }

        public void setDepthMask(boolean bl) {
            this._gl.glDepthMask(bl);
        }

        public void fill(float f) {
            this._r = f;
            this._g = f;
            this._b = f;
            this._a = 1.0f;
        }

        public void fill(float f, float f2) {
            this._r = f;
            this._g = f;
            this._b = f;
            this._a = f2;
        }

        public void fill(float f, float f2, float f3, float f4) {
            this._r = f;
            this._g = f2;
            this._b = f3;
            this._a = f4;
        }

        public void quad(float f, float f2, float f3, float f4) {
            this._gl.glTranslatef(f, f2, f3);
            this._gl.glBegin(7);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glTexCoord2f(0.0f, 0.0f);
            this._gl.glVertex3f(-1.0f * f4, 1.0f * f4, f3);
            this._gl.glTexCoord2f(1.0f, 0.0f);
            this._gl.glVertex3f(1.0f * f4, 1.0f * f4, f3);
            this._gl.glTexCoord2f(1.0f, 1.0f);
            this._gl.glVertex3f(1.0f * f4, -1.0f * f4, f3);
            this._gl.glTexCoord2f(0.0f, 1.0f);
            this._gl.glVertex3f(-1.0f * f4, -1.0f * f4, f3);
            this._gl.glEnd();
        }

        public void quad(float f) {
            this.quad(0.0f, 0.0f, 0.0f, f);
        }

        public void rect(float f, float f2, float f3, float f4, float f5) {
            this._gl.glTranslatef(f, f2, f3);
            this._gl.glBegin(7);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glTexCoord2f(0.0f, 0.0f);
            this._gl.glVertex3f(-1.0f * f4, -1.0f * f5, f3);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glTexCoord2f(1.0f, 0.0f);
            this._gl.glVertex3f(1.0f * f4, -1.0f * f5, f3);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glTexCoord2f(1.0f, 1.0f);
            this._gl.glVertex3f(1.0f * f4, 1.0f * f5, f3);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glTexCoord2f(0.0f, 1.0f);
            this._gl.glVertex3f(-1.0f * f4, 1.0f * f5, f3);
            this._gl.glEnd();
        }

        public void rect(float f, float f2) {
            this.rect(0.0f, 0.0f, 0.0f, f, f2);
        }
    }

    class XTexture {
        String fileName;
        Texture _tex;
        int _id;
        int _width;
        int _height;
        BufferedImage _buffer;

        XTexture() {
            this._tex = null;
        }

        XTexture(String string) {
            this.fileName = string;
            this._tex = null;
            this._buffer = null;
            this.load(string);
        }

        public void bind() {
            sunflower.this.gl._gl.glBindTexture(3553, this._id);
        }

        public void enable() {
            sunflower.this.gl.enableTexture(true);
            this.bind();
        }

        public void disable() {
            sunflower.this.gl._gl.glBindTexture(3553, 0);
            sunflower.this.gl.enableTexture(false);
        }

        public void setWrap() {
            this._tex.setTexParameterf(10242, 10497.0f);
            this._tex.setTexParameterf(10243, 10497.0f);
        }

        public void setClamp() {
            this._tex.setTexParameterf(10242, 10496.0f);
            this._tex.setTexParameterf(10243, 10496.0f);
        }

        public void setClampToEdge() {
            this._tex.setTexParameterf(10242, 33071.0f);
            this._tex.setTexParameterf(10243, 33071.0f);
        }

        public void createGL(int n, int n2) {
            this._width = n;
            this._height = n2;
            int[] nArray = new int[1];
            sunflower.this.gl._gl.glGenTextures(1, nArray, 0);
            this._id = nArray[0];
            sunflower.println((String)("texture created: " + this._id));
            sunflower.this.gl._gl.glBindTexture(3553, this._id);
            sunflower.this.gl._gl.glTexParameteri(3553, 10242, 10496);
            sunflower.this.gl._gl.glTexParameteri(3553, 10243, 10496);
            sunflower.this.gl._gl.glTexParameteri(3553, 10241, 9729);
            sunflower.this.gl._gl.glTexParameteri(3553, 10240, 9729);
            sunflower.this.gl._gl.glTexImage2D(3553, 0, 6408, this._width, this._height, 0, 32993, 5121, null);
        }

        public void create(int n, int n2) {
            this._width = n;
            this._height = n2;
            this._buffer = new BufferedImage(n, n2, 2);
            this._tex = TextureIO.newTexture((BufferedImage)this._buffer, (boolean)false);
            this._id = this._tex.getTextureObject();
            sunflower.println((String)("texture created: " + this._id));
            this._tex.setTexParameterf(10242, 10497.0f);
            this._tex.setTexParameterf(10243, 10497.0f);
            this._tex.setTexParameterf(10241, 9729.0f);
            this._tex.setTexParameterf(10240, 9729.0f);
        }

        public void load(String string) {
            this.fileName = string;
            try {
                this._tex = TextureIO.newTexture((File)new File(sunflower.this.dataPath(this.fileName)), (boolean)true);
                this._id = this._tex.getTextureObject();
                this._tex.setTexParameterf(10242, 10497.0f);
                this._tex.setTexParameterf(10243, 10497.0f);
                this._tex.setTexParameterf(10240, 9729.0f);
                this._tex.setTexParameterf(10241, 9987.0f);
            }
            catch (Exception exception) {
                sunflower.println((Object)exception);
            }
        }

        public int getTarget() {
            return this._tex.getTarget();
        }

        public int getId() {
            return this._id;
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._height;
        }
    }
}

