/*
 * Decompiled with CFR 0.152.
 */
package pitaru.sonia_v2_9;

import com.softsynth.jsyn.AudioDevice;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import pitaru.sonia_v2_9.BJSyn;
import pitaru.sonia_v2_9.LiveInput;
import pitaru.sonia_v2_9.LiveOutput;
import processing.core.PApplet;

public class Sonia {
    static final boolean DIRECT = true;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final boolean NO_MIC = false;
    static final boolean MIC = true;
    static float valueMod = 32767.0f;
    static boolean directData = false;
    static PApplet host;
    static int inDevID;
    static int outDevID;
    static int inDevChNum;
    static int outDevChNum;
    public static final int AVAILABLE = 0;
    public static final int CLASSES_MISSING = -1;
    public static final int NATIVE_LIBRARY_MISSING = -2;
    public static final int OBSOLETE = -3;

    public static void start(PApplet pApplet, int n, int n2) {
        host = pApplet;
        Sonia.initJsyn(n, n2);
    }

    public static void start(PApplet pApplet) {
        host = pApplet;
        Sonia.initJsyn(44100, 0);
    }

    public static void start(PApplet pApplet, int n) {
        host = pApplet;
        Sonia.initJsyn(n, 0);
    }

    public static void initJsyn(int n, int n2) {
        if (Synth.openCount == 1) {
            try {
                Synth.stopEngine();
                for (int i = 0; i < 15; ++i) {
                }
                System.out.println("ENGINE STOPPED count:" + Synth.openCount);
            }
            catch (SynthException synthException) {
                System.err.println((Object)synthException);
            }
        }
        try {
            Synth.startEngine((int)n2, (double)n);
            Synth.setTrace((int)0);
            inDevID = AudioDevice.getDefaultInputDeviceID();
            outDevID = AudioDevice.getDefaultOutputDeviceID();
            inDevChNum = AudioDevice.getMaxInputChannels((int)inDevID);
            outDevChNum = AudioDevice.getMaxOutputChannels((int)outDevID);
            System.out.println("Input Device #" + inDevID + ": " + AudioDevice.getName((int)inDevID) + " has " + inDevChNum + " channels");
            System.out.println("Input Device #" + outDevID + ": " + AudioDevice.getName((int)outDevID) + " has " + outDevChNum + " channels");
        }
        catch (SynthException synthException) {
            System.err.println((Object)synthException);
        }
    }

    public static void setValueRange(boolean bl) {
        directData = true;
    }

    public static void setValueRange(int n) {
        directData = false;
        valueMod = (float)(32767.0 / (double)n);
    }

    public static void stop() {
        if (LiveInput.state == 1) {
            LiveInput.stop();
        }
        if (LiveOutput.state == 1) {
            LiveOutput.stop();
        }
        if (BJSyn.count > 0) {
            BJSyn.stop();
        }
        Synth.stopEngine();
    }

    public void dispose() {
        if (LiveInput.state == 1) {
            LiveInput.stop();
        }
        if (LiveOutput.state == 1) {
            LiveOutput.stop();
        }
        if (BJSyn.count > 0) {
            BJSyn.stop();
        }
        Synth.stopEngine();
    }

    public static boolean getStatus() {
        int n = Sonia._getStatus();
        return n == 0;
    }

    public static int _getStatus() {
        try {
            Class.forName("com.softsynth.jsyn.CuePoint");
            try {
                Class<?> clazz = Class.forName("com.softsynth.jsyn.SynthContext");
                try {
                    Object obj = clazz.newInstance();
                }
                catch (Throwable throwable) {
                    return -2;
                }
            }
            catch (Throwable throwable) {
                return -3;
            }
        }
        catch (Throwable throwable) {
            return -1;
        }
        return 0;
    }

    public static void setMaxSamples(int n) {
        BJSyn.maxSamples = n;
    }

    public static int getMaxSamples() {
        return BJSyn.maxSamples;
    }
}

