
texture2D frameColorRT;
float2 viewportMin;
float2 viewportMax;


float fade = 1;
bool bypass = false;
float4 filterColor = float4(0.7, 0.8, 1.0, 1.0f);	// bluish colors
float exposition = 3.2;								// bright exposition
bool negative = false;
float HueScale = 1;
float HueBias = 0.025;								// cold colors
float SaturationScale = 1.4;						// saturate a bit
float SaturationBias = 0;
float IntensityScale = 1.5;							// augment brightness (uses HDR colors)
float IntensityBias = -0.12;						// augment black areas for mood
float gamma = 1.0 / 1.2;							// a bit of gamma correction
float tunnelEffectPower = 0.9;


sampler2D frameColorSampler = sampler_state {
	texture = <frameColorRT>;
	addressu = CLAMP;
	addressv = CLAMP;
};


struct VertexInput {
	float3 oPosition: POSITION;
	float2 texCoord: TEXCOORD;
};


struct PixelInput {
	float4 sPosition: POSITION;
	float2 texCoord: TEXCOORD;
};


struct PixelOutput {
	float4 color: COLOR;
};


PixelInput SAQVS(VertexInput input) {
	PixelInput output;
	
	float2 sz = viewportMax - viewportMin;
	float2 p = input.oPosition.xy*0.5+0.5;
	p *= sz;
	p += viewportMin;
	
	output.sPosition.xy = p * 2 - 1;
	output.sPosition.zw = float2(0, 1);
	output.texCoord = input.texCoord;
	return output;
}


const float PI2 = 6.2831853;
const float rt3 = 1.0 / sqrt(3);


float3 RGBtoHSI(float3 rgb) {
	float r = rgb.r;
	float g = rgb.g * 0.99;		// there is a bug. If the color is grey (or white), the convertion back to RGB fails.
	float b = rgb.b;

	float rg = r - g;
	float rb = r - b;
	// Hue
	float h = acos((rg + rb) / (2 * sqrt(rg * rg + rb * (g - b)))) / PI2;
	if (b > g) h = 1 - h;

	// Intensity
	float i = (r + g + b) / 3;
	// Saturation
	float s = 1 - min(min(r, g), b) / i;

	return float4(h,s,i, 0);
}


float3 HSItoRGB(float3 hsi) {
	float h = hsi.r;
	float s = hsi.g;
	float i = hsi.b;
   
	float h3 = 3 * h;
	float x = (2 * floor(h3) + 1) / 6;

	// Get our rgb components
	float r = (1 - s) * i;
	float H = rt3 * tan((h - x) * PI2);
	float b = ((3 + 3 * H) * i - (1 + 3 * H) * r) / 2;
	float g = 3 * i - b - r;

	// Put them in right order
	float3 rgb;
	if (h3 < 1)
	  rgb = float3(g, b, r);
	else if (h3 < 2)
	  rgb = float3(r, g, b);
	else
	  rgb = float3(b, r, g);

	return float4(rgb, 0);
}


float3 BrightPass(float3 input) {
	// hacked bright pass filter...a bit of programmer's creativity ;)
	return pow(input, 1.5);
}


// Party PANIK!! This is plain horrible...should use multiple quad renders.
float3 BloomColor(float2 texCoord, float3 input) {
	const float BlurScale = 0.015;
	const float2 offsets[24] = {
	   -0.326212, -0.405805,
	   -0.840144, -0.073580,
	   -0.695914,  0.457137,
	   -0.203345,  0.620716,
		0.962340, -0.194983,
		0.473434, -0.480026,
		0.519456,  0.767022,
		0.185461, -0.893124,
		0.507431,  0.064425,
		0.896420,  0.412458,
	   -0.321940, -0.932615,
	   -0.791559, -0.597705,
	   
	   0.326212, -0.405805,
	   0.840144, -0.073580,
	   0.695914,  0.457137,
	   0.203345,  0.620716,
		-0.962340, -0.194983,
		-0.473434, -0.480026,
		-0.519456,  0.767022,
		-0.185461, -0.893124,
		-0.507431,  0.064425,
		-0.896420,  0.412458,
	   0.321940, -0.932615,
	   0.791559, -0.597705,
	};
	float3 output = 0;
	
	float3 blur = 0;
	for (int i = 0; i < 24; i++)
		blur += tex2D(frameColorSampler, texCoord + BlurScale * offsets[i]);
	blur /= 24;
	
	output = input + BrightPass(blur);
	return output;
}


PixelOutput SAQPS(PixelInput input) {
	PixelOutput output;
	float3 inputColor = tex2D(frameColorSampler, input.texCoord).rgb;
	
	if (bypass) {
		output.color = float4(inputColor*fade, 1);
		return output;
	}
	
	// bloom
	inputColor = BloomColor(input.texCoord, inputColor);
	
	// tunnel effect
	float distToCenter = distance(0.5, input.texCoord);
	inputColor *= 1 - pow(distToCenter, tunnelEffectPower);
	
	// exposition control
	inputColor *= filterColor;
	inputColor = 1 - pow(2.18, -inputColor*(exposition*fade));
	inputColor = saturate(negative ? 1-inputColor : inputColor);
	
	// manipulate colors in HSI space
	float3 inputHSI = RGBtoHSI(inputColor.rgb);
	inputHSI.r = frac    (inputHSI.r * HueScale        + HueBias);
	inputHSI.g = saturate(inputHSI.g * SaturationScale + SaturationBias);
	inputHSI.b = saturate(inputHSI.b * IntensityScale  + IntensityBias);
	inputColor.rgb = HSItoRGB(inputHSI);
	
	// gamma
	inputColor = pow(inputColor, gamma);
	
	output.color = float4(inputColor.rgb, 1);
	return output;
}



technique saq {
	pass p0 {
		vertexshader = compile vs_3_0 SAQVS();
		pixelshader = compile ps_3_0 SAQPS();
		
		cullmode = none;
		fillmode = solid;
		zenable = false;
		zwriteenable = false;
	}
}
