#include "consts.fxh"

float4x4 matObjectToWorld;
float4x4 matWorldToView;
float4x4 matViewToProj;
float4x4 matWorldToObject;
float4x4 matViewToWorld;
float3 cameraPosition;


texture diffuseTex < 
	string TextureType = "2D"; 
	string UIName = "Diffuse Map";
	bool VIExport = true;
>;


sampler2D diffuseSamp = sampler_state {
	texture = <diffuseTex>;
	magFilter = linear;
	minFilter = linear;
	mipFilter = linear;
};


int texcoord0 : Texcoord <
    int Texcoord = 0;
    int MapChannel = 1;
    string UIName = "dont use";
    string UIWidget = "none";
>;



struct VertexInput {
	float3 oPosition: POSITION;
	float2 texCoord: TEXCOORD;
};


struct PixelInput {
	float4 pPosition: POSITION;
	float2 texCoord: TEXCOORD0;
};


struct PixelOutput {
	float4 color: COLOR;
};


PixelInput VS(VertexInput input) {
	// transform position
	float4 oPosition = float4(input.oPosition, 1);
	float4 wPosition = mul(oPosition, matObjectToWorld);
	float4 vPosition = mul(wPosition, matWorldToView);
	float4 pPosition = mul(vPosition, matViewToProj);
	
	// create output
	PixelInput output = (PixelInput)0;
	output.texCoord = input.texCoord;
	output.pPosition = pPosition;
	return output;
}



PixelOutput PS(PixelInput input) {
	PixelOutput output;
	output.color = tex2D(diffuseSamp, input.texCoord);
	return output;
}



technique defaultSh {
	pass additive {
		vertexShader = compile vs_3_0 VS();
		pixelShader = compile ps_3_0 PS();
		alphaBlendEnable = true;
		srcBlend = one;
		destBlend = one;
		cullmode = none;
	}
}
