
/* Ilumination and ZFog , version 1.00.00 */

/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;

// Ilumination data, lights for pixelshader
float4	bw_LightPosition[4];
float4	bw_LightColor[4];
int		bw_LightCount;

// Material Color
float4	bw_MaterialDiffuse;
float4	bw_MaterialAmbient;

// Diffuse lighting expression
float3 bwDiffuseLighting(float3 vPosition,float3 vNormal,float3 lPosition, float lDistance, float3 lColor,float3 lEnergy)
{
	float3 Direction = lPosition-vPosition;
	float Distancia = length(Direction);

	float Att = lDistance/Distancia; // Atenuao linear

	if(Distancia<lDistance)
		Att = 1.0;

	// Atenuao Quadratica
	if(Distancia>lDistance)
		Att = Att*Att;

	return lColor * Att * lEnergy* clamp(dot(normalize(Direction),vNormal),0,1) ;
}

struct VS_INPUT
{
	float3 position  : POSITION;
	float3 normal    : NORMAL;
	float2 texcoord0 : TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 hposition : POSITION;
	float2 texcoord0 : TEXCOORD0;
	float4 Color:COLOR0;
	float zPos:TEXCOORD1;
};

//

VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;
	OUT.texcoord0 = IN.texcoord0;
	OUT.hposition = mul(float4(IN.position.xyz,1.0),bw_ModelViewProjectionMatrix);

	float4 v_Pos = mul(float4(IN.position.xyz,1.0),bw_ObjectMatrix);
	float4 v_Nor = normalize(mul(float4(IN.normal.xyz,0.0),bw_ObjectMatrix));

	float3 diffuse_col=0.0; 
	for (int i = 0;i<bw_LightCount;i++)
	{
		diffuse_col+=bwDiffuseLighting(	v_Pos,v_Nor,
							bw_LightPosition[i].xyz,bw_LightPosition[i].w,
							bw_LightColor[i].xyz,bw_LightColor[i].w
							);
	}

	float4 processed_color = clamp(bw_MaterialAmbient + bw_MaterialDiffuse*float4(diffuse_col,bw_MaterialDiffuse.w),0,1);


	

	
	OUT.zPos = v_Pos.z;
	//OUT.Color = processed_color*(1-bw_ZFogValue);
	//OUT.Color += processed_color*bw_ZFogValue*z_fog;
	OUT.Color = processed_color;
	return OUT;
}

#pragma HLSL_PS


struct VS_OUTPUT
{
	float4 hposition : POSITION;
	float2 texcoord0 : TEXCOORD0;
	float4 Color:COLOR0;
	float zPos:TEXCOORD1;
};

float bw_ZFogValue;
float4 u_val;

float4 main(VS_OUTPUT IN):COLOR
{
	float z_fog = pow(1-clamp(IN.zPos/2,0,1),2);

	float4 p_color = IN.Color;

	if(u_val.w>IN.texcoord0.x)
		p_color = float4(u_val.xyz,1)+p_color*0.5;
	else
		p_color = 0.0;

	float4 color_final = p_color*(1-bw_ZFogValue);
	color_final += p_color*bw_ZFogValue*z_fog;

	

	return color_final;
}

#end