

/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;
float4 bw_MaterialDiffuse;

struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 tex_0	: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 hpos		: POSITION;
	float2 tex_0	: TEXCOORD0;
	float4 col_0	: COLOR0;

};

float alpha;

VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;

	OUT.hpos = mul(float4(IN.pos.xyz,1.0),bw_ModelViewProjectionMatrix);

	float att =1- length(IN.pos.xyz)/13.0;

	OUT.col_0 = float4(att*bw_MaterialDiffuse.xyz,alpha);
	OUT.tex_0 = IN.tex_0;

	return OUT;
}

#end