/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
		
#pragma HLSL_VS

float4x4 bw_ModelViewProjectionMatrix;

struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 tex_0	: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 hpos		: POSITION;
	float4 col_0	: COLOR0;
	float2 tex_0	: TEXCOORD0;
};


VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;
	OUT.col_0	= 1.0;
	OUT.tex_0	= IN.tex_0;
	OUT.hpos	= mul(float4(IN.pos.xyz,1.0),bw_ModelViewProjectionMatrix);
	return OUT;
}

/*###############################################
# Pixel Shader
################################################*/

#pragma HLSL_PS

struct VS_OUTPUT
{
	float4 hpos		: POSITION;
	float4 col_0	: COLOR0;
	float2 tex_0	: TEXCOORD0;
};

// layer 0 texture
sampler texture_0:register(s0);

// blur filter configuration (x,y for direction, z for intensity)
float4 settings;

float4 main( VS_OUTPUT IN ) : COLOR
{
	float4 col = float4(0,0,0,0);	

	// Correct offset bug
	IN.tex_0 += float2(0.6/512.0,0.6/512.0);
							
	for(float i = -6.0;i<=6.0;i+=1.0)
	{
		float off = i*0.0034076;
		float wei = 0.12471*(1.0-(i*i)/36.0);
		col	+=tex2D(texture_0,IN.tex_0 +settings.xy*off )* wei*settings.z;
	}

	return col;
}

#end