#include <stdio.h>
#include <SDL/SDL.h>

#include "bassmod.h"

#ifdef WIN32
#include <conio.h>
#include <mmsystem.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#include <termios.h>
#endif

#define WIDTH 800
#define HEIGHT 480
#define BPP 4
#define DEPTH 16
#define SCREENFLAGS SDL_HWSURFACE

SDL_Surface *isologo;
SDL_Surface *pilvet;
SDL_Surface *porkkana;
SDL_Surface *tehdas;
SDL_Surface *ikemad;
SDL_Surface *kanerv;
SDL_Surface *johanna;
SDL_Surface *ikesaksa;
SDL_Surface *loppu;


Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
    int bpp = surface->format->BytesPerPixel;
    /* Here p is the address to the pixel we want to retrieve */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;       /* shouldn't happen, but avoids warnings */
    }
}

void putpixel(SDL_Surface *surface, int x, int y, Uint32 pixel)
{
    int bpp = surface->format->BytesPerPixel;
    /* Here p is the address to the pixel we want to set */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
    case 1:
        *p = pixel;
        break;

    case 2:
        *(Uint16 *)p = pixel;
        break;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN) {
            p[0] = (pixel >> 16) & 0xff;
            p[1] = (pixel >> 8) & 0xff;
            p[2] = pixel & 0xff;
        } else {
            p[0] = pixel & 0xff;
            p[1] = (pixel >> 8) & 0xff;
            p[2] = (pixel >> 16) & 0xff;
        }
        break;

    case 4:
        *(Uint32 *)p = pixel;
        break;
    }
}

void DrawScreen(SDL_Surface* screen, int h)
{ 
    if(SDL_MUSTLOCK(screen)) 
    {
        if(SDL_LockSurface(screen) < 0) return;
    }

	SDL_FillRect(screen,NULL,0);

    unsigned int pos = BASSMOD_MusicGetPosition();
    unsigned int origpos = pos>>16;
    pos&=0xFFFF;

    if (pos == 0) {
	SDL_BlitSurface(isologo,NULL,screen,NULL);
    }

    if (pos == 1) {
	SDL_BlitSurface(tehdas,NULL,screen,NULL);
    }

    else if (pos == 2) {
	SDL_BlitSurface(ikesaksa,NULL,screen,NULL);
    }

    else if (pos == 3) {
	SDL_BlitSurface(pilvet,NULL,screen,NULL);
    }

    else if (pos == 4) {
	SDL_BlitSurface(ikemad,NULL,screen,NULL);
    }

    else if (pos == 5) {
	
	int x,y;

	printf("%d\n",origpos);


	SDL_BlitSurface(johanna,NULL,screen,NULL);

	int t = origpos*100;

	for(y=0;y<480;y+=1) {
		for(x=0;x<800;x+=1) {
			if (getpixel(johanna,x,y) == 0xFF0000) putpixel(screen, x, y, SDL_MapRGB(screen->format,t+y>>4,x>>3,y>>2));
		}
	}
        
	
    }

    else if (pos == 6) {
	SDL_BlitSurface(loppu,NULL,screen,NULL);
    }

   

    if(SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
  
    SDL_Flip(screen); 
}


int main(int argc, char* argv[])
{
    SDL_Surface *screen;
    SDL_Event event;
  
    int keypress = 0;
    int h=0; 

	if (BASSMOD_GetVersion()!=MAKELONG(2,0)) {
		printf("BASSMOD version 2.0 was not loaded\n");
		return;
	}

	if (!BASSMOD_Init(-1,44100,0))
		return -1;

	if (!BASSMOD_MusicLoad(FALSE,"music.xm",0,0,BASS_MUSIC_RAMPS|BASS_MUSIC_SURROUND))
		return -1;


  
    if (SDL_Init(SDL_INIT_VIDEO) < 0 ) return 1;
   
    if (!(screen = SDL_SetVideoMode(WIDTH, HEIGHT, DEPTH, SCREENFLAGS)))
    {
        SDL_Quit();
        return 1;
    }

isologo = SDL_LoadBMP("isologo.bmp");
pilvet = SDL_LoadBMP("pilvet.bmp");
porkkana = SDL_LoadBMP("porkkana.bmp");
tehdas = SDL_LoadBMP("tehdas.bmp");
ikemad = SDL_LoadBMP("ikemad.bmp");
kanerv = SDL_LoadBMP("kanerv.bmp");
johanna = SDL_LoadBMP("johanna.bmp");
ikesaksa = SDL_LoadBMP("ikesaksa.bmp");
loppu = SDL_LoadBMP("loppu.bmp");

  	BASSMOD_MusicPlay();

  
    while(!keypress) 
    {
         DrawScreen(screen,h++);
         while(SDL_PollEvent(&event)) 
         {      
              switch (event.type) 
              {
                  case SDL_QUIT:
	              keypress = 1;
	              break;
                  case SDL_KEYDOWN:
                       keypress = 1;
                       break;
              }
         }
    }

	BASSMOD_Free();
    SDL_Quit();
  
    return 0;
}




