/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.easyogg;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class OggClip {
    private final int BUFSIZE = 8192;
    private int convsize = 16384;
    private byte[] convbuffer = new byte[this.convsize];
    private SyncState oy;
    private StreamState os;
    private Page og;
    private Packet op;
    private Info vi;
    private Comment vc;
    private DspState vd;
    private Block vb;
    private SourceDataLine outputLine;
    private int rate;
    private int channels;
    private BufferedInputStream bitStream = null;
    private byte[] buffer = null;
    private int bytes = 0;
    private Thread player = null;
    static /* synthetic */ Class class$0;

    public OggClip(String ref) throws IOException {
        try {
            this.init(Thread.currentThread().getContextClassLoader().getResourceAsStream(ref));
        }
        catch (IOException e) {
            throw new IOException("Couldn't find: " + ref);
        }
    }

    public OggClip(InputStream in) throws IOException {
        this.init(in);
    }

    private void init(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("Couldn't find input source");
        }
        this.bitStream = new BufferedInputStream(in);
    }

    public void play() {
        this.player = new Thread(){

            public void run() {
                OggClip.this.bitStream.mark(Integer.MAX_VALUE);
                try {
                    OggClip.this.playStream(Thread.currentThread());
                }
                catch (InternalException e) {
                    e.printStackTrace();
                }
                try {
                    OggClip.this.bitStream.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.player.setDaemon(true);
        this.player.start();
    }

    public boolean isPlaying() {
        return this.outputLine != null;
    }

    public void setPosition() {
    }

    public void stop() {
        this.player = null;
    }

    public void close() {
        try {
            if (this.bitStream != null) {
                this.bitStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initJavaSound(int channels, int rate) throws InternalException {
        try {
            DataLine.Info info;
            AudioFormat audioFormat = new AudioFormat(rate, 16, channels, true, false);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, audioFormat, -1))) {
                throw new Exception("Line " + info + " not supported.");
            }
            try {
                this.outputLine = (SourceDataLine)AudioSystem.getLine(info);
                this.outputLine.open(audioFormat);
            }
            catch (LineUnavailableException ex) {
                throw new Exception("Unable to open the sourceDataLine: " + ex);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("Illegal Argument: " + ex);
            }
            this.rate = rate;
            this.channels = channels;
        }
        catch (Exception ee) {
            System.out.println(ee);
        }
    }

    private SourceDataLine getOutputLine(int channels, int rate) throws InternalException {
        if (this.outputLine == null || this.rate != rate || this.channels != channels) {
            if (this.outputLine != null) {
                this.outputLine.drain();
                this.outputLine.stop();
                this.outputLine.close();
            }
            this.initJavaSound(channels, rate);
            this.outputLine.start();
        }
        return this.outputLine;
    }

    private void initJOrbis() {
        this.oy = new SyncState();
        this.os = new StreamState();
        this.og = new Page();
        this.op = new Packet();
        this.vi = new Info();
        this.vc = new Comment();
        this.vd = new DspState();
        this.vb = new Block(this.vd);
        this.buffer = null;
        this.bytes = 0;
        this.oy.init();
    }

    /*
     * Unable to fully structure code
     */
    private void playStream(Thread me) throws InternalException {
        chained = false;
        this.initJOrbis();
        while (true) {
            block31: {
                eos = false;
                index = this.oy.buffer(8192);
                this.buffer = this.oy.data;
                try {
                    this.bytes = this.bitStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    throw new InternalException(e);
                }
                this.oy.wrote(this.bytes);
                if (chained) {
                    chained = false;
                } else if (this.oy.pageout(this.og) != 1) {
                    if (this.bytes < 8192) break;
                    throw new InternalException("Input does not appear to be an Ogg bitstream.");
                }
                this.os.init(this.og.serialno());
                this.os.reset();
                this.vi.init();
                this.vc.init();
                if (this.os.pagein(this.og) < 0) {
                    throw new InternalException("Error reading first page of Ogg bitstream data.");
                }
                if (this.os.packetout(this.op) != 1) {
                    throw new InternalException("Error reading initial header packet.");
                }
                if (this.vi.synthesis_headerin(this.vc, this.op) < 0) {
                    throw new InternalException("This Ogg bitstream does not contain Vorbis audio data.");
                }
                i = 0;
                break block31;
                while ((result = this.oy.pageout(this.og)) != 0) {
                    if (result == 1) {
                        this.os.pagein(this.og);
                        while (i < 2) {
                            result = this.os.packetout(this.op);
                            if (result == 0) break;
                            if (result == -1) {
                                throw new InternalException("Corrupt secondary header.  Exiting.");
                            }
                            this.vi.synthesis_headerin(this.vc, this.op);
                            ++i;
                        }
                    }
lbl46:
                    // 5 sources

                    ** while (i >= 2)
lbl47:
                    // 1 sources

                }
lbl48:
                // 2 sources

                index = this.oy.buffer(8192);
                this.buffer = this.oy.data;
                try {
                    this.bytes = this.bitStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    throw new InternalException(e);
                }
                if (this.bytes == 0 && i < 2) {
                    throw new InternalException("End of file before finding all Vorbis headers!");
                }
                this.oy.wrote(this.bytes);
            }
            if (i < 2) ** GOTO lbl46
            this.convsize = 8192 / this.vi.channels;
            this.vd.synthesis_init(this.vi);
            this.vb.init(this.vd);
            _pcm = new double[1][][];
            _pcmf = new float[1][][];
            _index = new int[this.vi.channels];
            this.getOutputLine(this.vi.channels, this.vi.rate);
            ** GOTO lbl136
            {
                block32: {
                    block33: {
                        if (this.player != me) {
                            return;
                        }
                        result = this.oy.pageout(this.og);
                        if (result == 0) ** GOTO lbl123
                        if (result == -1) break block32;
                        this.os.pagein(this.og);
                        if (this.og.granulepos() != 0L) break block33;
                        chained = true;
                        eos = true;
                        ** GOTO lbl123
                    }
                    while ((result = this.os.packetout(this.op)) != 0) {
                        if (result == -1) continue;
                        if (this.vb.synthesis(this.op) == 0) {
                            this.vd.synthesis_blockin(this.vb);
                        }
                        while ((samples = this.vd.synthesis_pcmout(_pcmf, _index)) > 0) {
                            pcm = _pcm[0];
                            pcmf = _pcmf[0];
                            bout = samples < this.convsize ? samples : this.convsize;
                            i = 0;
                            while (i < this.vi.channels) {
                                ptr = i * 2;
                                mono = _index[i];
                                j = 0;
                                while (j < bout) {
                                    val = (int)((double)pcmf[i][mono + j] * 32767.0);
                                    if (val > 32767) {
                                        val = 32767;
                                    }
                                    if (val < -32768) {
                                        val = -32768;
                                    }
                                    if (val < 0) {
                                        val |= 32768;
                                    }
                                    this.convbuffer[ptr] = (byte)val;
                                    this.convbuffer[ptr + 1] = (byte)(val >>> 8);
                                    ptr += 2 * this.vi.channels;
                                    ++j;
                                }
                                ++i;
                            }
                            this.outputLine.write(this.convbuffer, 0, 2 * this.vi.channels * bout);
                            this.vd.synthesis_read(bout);
                        }
                    }
                    if (this.og.eos() != 0) {
                        eos = true;
                    }
                }
                do {
                    if (!eos) continue block10;
lbl123:
                    // 3 sources

                    if (eos) continue;
                    index = this.oy.buffer(8192);
                    this.buffer = this.oy.data;
                    try {
                        this.bytes = this.bitStream.read(this.buffer, index, 8192);
                    }
                    catch (Exception e) {
                        throw new InternalException(e);
                    }
                    if (this.bytes == -1) break block10;
                    this.oy.wrote(this.bytes);
                    if (this.bytes != 0) continue;
                    eos = true;
lbl136:
                    // 4 sources

                } while (!eos);
            }
            this.os.clear();
            this.vb.clear();
            this.vd.clear();
            this.vi.clear();
        }
        this.oy.clear();
    }

    private class InternalException
    extends Exception {
        public InternalException(Exception e) {
            super(e);
        }

        public InternalException(String msg) {
            super(msg);
        }
    }
}

