/*
 * Decompiled with CFR 0.152.
 */
package effects;

import com.xplsv.anim.Tween;
import com.xplsv.utils.Timer;
import core.Colour;
import core.Triangle;
import core.objects.IcosaBroken;
import effects.Effect;
import java.util.Random;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class EffectBall
extends Effect {
    private GLU glu;
    private Random rand;
    private IcosaBroken ballBg;
    private IcosaBroken ballMain;
    private IcosaBroken ballBoomOrig;
    private IcosaBroken ballBoomDest;
    private int count = 0;
    private float speedSpin = 0.003f;

    public EffectBall(GL gl, int start, int duration) {
        super(gl, start, duration);
    }

    public void init() {
        this.rand = new Random(2L);
        this.glu = new GLU();
        this.ballBg = new IcosaBroken(4, 50.0f);
        this.ballMain = new IcosaBroken(5, 15.0f);
        this.ballBoomOrig = new IcosaBroken(5, 15.0f);
        this.ballBoomDest = new IcosaBroken(5, 15.0f);
        int i = 0;
        while (i < this.ballMain.triangles.size()) {
            ((Triangle)this.ballMain.triangles.get((int)i)).visible = false;
            ++i;
        }
        i = 0;
        while (i < this.ballBoomDest.triangles.size()) {
            Triangle triangle = (Triangle)this.ballBoomDest.triangles.get(i);
            float displacement = this.rand.nextFloat() * 5.0f + 2.0f;
            triangle.v1.position.x = triangle.v1.position.x * displacement + this.rand.nextFloat();
            triangle.v1.position.y = triangle.v1.position.y * displacement + this.rand.nextFloat();
            triangle.v1.position.z = triangle.v1.position.z * displacement + this.rand.nextFloat();
            triangle.v2.position.x = triangle.v2.position.x * displacement + this.rand.nextFloat();
            triangle.v2.position.y = triangle.v2.position.y * displacement + this.rand.nextFloat();
            triangle.v2.position.z = triangle.v2.position.z * displacement + this.rand.nextFloat();
            triangle.v3.position.x = triangle.v3.position.x * displacement + this.rand.nextFloat();
            triangle.v3.position.y = triangle.v3.position.y * displacement + this.rand.nextFloat();
            triangle.v3.position.z = triangle.v3.position.z * displacement + this.rand.nextFloat();
            ++i;
        }
    }

    public void render() {
        Triangle triangleDest;
        Triangle triangleOrig;
        Triangle triangle;
        int i;
        float d;
        if (!this.active()) {
            return;
        }
        this.gl.glBlendFunc(770, 771);
        this.gl.glLoadIdentity();
        if (Timer.getTime() > 27900L && Timer.getTime() < 165000L) {
            this.glu.gluLookAt(0.0, 0.0, (double)Timer.getTime() * 5.0E-4, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        } else if (Timer.getTime() < 177840L) {
            this.glu.gluLookAt((double)Timer.getTime() * 1.0E-4, 0.0, (double)Timer.getTime() * 1.0E-4, (double)Timer.getTime() * 1.0E-4, 0.0, 0.0, 0.0, 1.0, 0.0);
        } else if (Timer.getTime() < 191520L) {
            this.glu.gluLookAt(50.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        } else if (Timer.getTime() < 205200L) {
            this.glu.gluLookAt(50.0, 50.0, 2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        } else if (Timer.getTime() < 218880L) {
            this.glu.gluLookAt(0.0, 10.0, (double)Timer.getTime() * 5.0E-4, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        }
        this.gl.glRotated((double)((float)Timer.getTime() * this.speedSpin), (double)((float)Timer.getTime() * this.speedSpin), (double)((float)Timer.getTime() * this.speedSpin), 1.0);
        this.gl.glColor4f(0.0f, 0.1f, 0.5f, 1.0f);
        this.ballBg.render(this.gl);
        if (Timer.getTime() > 27900L && Timer.getTime() < 110000L && this.count < this.ballMain.triangles.size() - 2) {
            this.gl.glBegin(3);
            this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            Triangle triangle2 = (Triangle)this.ballMain.triangles.get(this.count);
            triangle2.colour = new Colour(1.0f, 1.0f, 1.0f);
            triangle2.visible = true;
            this.gl.glVertex3f(0.0f, 0.0f, 0.0f);
            this.gl.glVertex3f(triangle2.position.x, triangle2.position.y, triangle2.position.z);
            this.gl.glEnd();
            ++this.count;
        }
        this.ballMain.render(this.gl);
        if (Timer.getTime() > (long)(Timer.beat_length * 128)) {
            this.speedSpin = (float)((double)this.speedSpin + 4.0E-6);
        }
        if (Timer.getTime() > (long)(Timer.beat_length * 128) && Timer.getTime() < 118000L) {
            float t = Timer.getTime() - (long)(Timer.beat_length * 128);
            d = 8000.0f;
            i = 0;
            while (i < this.ballMain.triangles.size()) {
                triangle = (Triangle)this.ballMain.triangles.get(i);
                triangleOrig = (Triangle)this.ballBoomOrig.triangles.get(i);
                triangleDest = (Triangle)this.ballBoomDest.triangles.get(i);
                if (!triangle.visible) {
                    triangle.visible = true;
                    triangle.colour = new Colour(1.0f, 1.0f, 1.0f);
                }
                triangle.v1.position.x = Tween.process(t, d - 1000.0f, triangleOrig.v1.position.x, triangleDest.v1.position.x, 17);
                triangle.v1.position.y = Tween.process(t, d, triangleOrig.v1.position.y, triangleDest.v1.position.y, 17);
                triangle.v1.position.z = Tween.process(t, d, triangleOrig.v1.position.z, triangleDest.v1.position.z, 17);
                triangle.v2.position.x = Tween.process(t, d - 2000.0f, triangleOrig.v2.position.x, triangleDest.v2.position.x, 17);
                triangle.v2.position.y = Tween.process(t, d - 2000.0f, triangleOrig.v2.position.y, triangleDest.v2.position.y, 17);
                triangle.v2.position.z = Tween.process(t, d - 2000.0f, triangleOrig.v2.position.z, triangleDest.v2.position.z, 17);
                triangle.v3.position.x = Tween.process(t, d, triangleOrig.v3.position.x, triangleDest.v3.position.x, 17);
                triangle.v3.position.y = Tween.process(t, d - 2000.0f, triangleOrig.v3.position.y, triangleDest.v3.position.y, 17);
                triangle.v3.position.z = Tween.process(t, d - 1000.0f, triangleOrig.v3.position.z, triangleDest.v3.position.z, 17);
                ++i;
            }
        }
        if (Timer.getTime() > 120000L && Timer.getTime() < 165000L) {
            float t = Timer.getTime() - 120000L;
            d = 25000.0f;
            i = 0;
            while (i < this.ballMain.triangles.size()) {
                triangle = (Triangle)this.ballMain.triangles.get(i);
                triangleOrig = (Triangle)this.ballBoomOrig.triangles.get(i);
                triangleDest = (Triangle)this.ballBoomDest.triangles.get(i);
                if (!triangle.visible) {
                    triangle.visible = true;
                    triangle.colour = new Colour(1.0f, 1.0f, 1.0f);
                }
                if (!((t -= (float)i * 0.001f) < 0.0f)) {
                    triangle.v1.position.x = Tween.process(t, d + 1000.0f, triangleDest.v1.position.x, triangleOrig.v1.position.x, 16);
                    triangle.v1.position.y = Tween.process(t, d + 1000.0f, triangleDest.v1.position.y, triangleOrig.v1.position.y, 16);
                    triangle.v1.position.z = Tween.process(t, d + 1000.0f, triangleDest.v1.position.z, triangleOrig.v1.position.z, 16);
                    triangle.v2.position.x = Tween.process(t, d, triangleDest.v2.position.x, triangleOrig.v2.position.x, 16);
                    triangle.v2.position.y = Tween.process(t, d, triangleDest.v2.position.y, triangleOrig.v2.position.y, 16);
                    triangle.v2.position.z = Tween.process(t, d, triangleDest.v2.position.z, triangleOrig.v2.position.z, 16);
                    triangle.v3.position.x = Tween.process(t, d - 1000.0f, triangleDest.v3.position.x, triangleOrig.v3.position.x, 16);
                    triangle.v3.position.y = Tween.process(t, d - 1000.0f, triangleDest.v3.position.y, triangleOrig.v3.position.y, 16);
                    triangle.v3.position.z = Tween.process(t, d - 1000.0f, triangleDest.v3.position.z, triangleOrig.v3.position.z, 16);
                }
                ++i;
            }
        }
        if (Timer.getTime() > 165000L) {
            float t = Timer.getTime() - 120000L;
            int i2 = 0;
            while (i2 < this.ballMain.triangles.size()) {
                Triangle triangle3 = (Triangle)this.ballMain.triangles.get(i2);
                Triangle triangleOrig2 = (Triangle)this.ballBoomOrig.triangles.get(i2);
                if (!triangle3.visible) {
                    triangle3.visible = true;
                    triangle3.colour = new Colour(1.0f, 1.0f, 1.0f);
                }
                triangle3.v1.position.x = triangleOrig2.v1.position.x * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v1.position.y = triangleOrig2.v1.position.y * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v1.position.z = triangleOrig2.v1.position.z * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v2.position.x = triangleOrig2.v2.position.x * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v2.position.y = triangleOrig2.v2.position.y * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v2.position.z = triangleOrig2.v2.position.z * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v3.position.x = triangleOrig2.v3.position.x * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v3.position.y = triangleOrig2.v3.position.y * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                triangle3.v3.position.z = triangleOrig2.v3.position.z * (float)(Math.sin((double)t * 0.001 + (double)i2 * 0.005) + 2.0);
                ++i2;
            }
        }
    }
}

