/*
 * Decompiled with CFR 0.152.
 */
import com.xplsv.controllers.AudioController;
import com.xplsv.utils.Timer;
import core.Colour;
import effects.Effect;
import effects.EffectBall;
import effects.EffectColour;
import effects.EffectColourFade;
import effects.EffectColourGradient;
import effects.EffectFlash;
import effects.EffectTexts;
import java.util.ArrayList;
import javax.media.opengl.GL;
import utils.Font;

public class Timeline {
    private int start_time = 0;
    private String tune_filename = "r08028_orbit.ogg";
    private ArrayList<Effect> effects;

    public Timeline(GL gl) {
        Timer.beat_length = 855;
        Font.gl = gl;
        this.effects = new ArrayList();
        this.effects.add(new EffectColour(gl, 0, 250000, new Colour(0.0f, 0.0f, 0.05f, 1.0f)));
        this.effects.add(new EffectBall(gl, 0, Timer.beat_length * 256));
        this.effects.add(new EffectColourGradient(gl, 0, 250000, new Colour(0.0f, 1.0f, 0.0f), new Colour(0.0f, 1.0f, 1.0f)));
        this.effects.add(new EffectTexts(gl, 0, 250000));
        this.effects.add(new EffectColourFade(gl, 0, 15000, 1.0f, 0.0f, new Colour(0.0f, 0.0f, 0.0f)));
        this.effects.add(new EffectFlash(gl, 110000, 2500, 0.5f, 0.0f, new Colour(1.0f, 1.0f, 1.0f)));
    }

    public void init() {
        AudioController.play(this.tune_filename);
        int i = 0;
        while (i < this.effects.size()) {
            this.effects.get(i).init();
            ++i;
        }
    }

    public void render() {
        if (!AudioController.isPlaying()) {
            Timer.init(this.start_time, true);
        }
        int i = 0;
        while (i < this.effects.size()) {
            this.effects.get(i).render();
            ++i;
        }
    }
}

