

/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;


struct VS_INPUT
{
	float3 position  : POSITION;
	float3 normal    : NORMAL;
	float2 texcoord0 : TEXCOORD0;
};


struct VS_OUTPUT
{
	float4 hposition	:POSITION;
	float4 Color		:COLOR0;
	float2 texcoord0	:TEXCOORD0;
};



VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;
	OUT.texcoord0 = IN.texcoord0;
	OUT.hposition = mul(float4(IN.position.xyz,1.0),bw_ModelViewProjectionMatrix);
	float4 v_Nor = normalize(mul(float4(IN.normal.xyz,0.0),bw_ObjectMatrix));
	OUT.Color = 0.25*v_Nor.x +0.5*v_Nor.z*v_Nor.z;


	return OUT;
}

#pragma HLSL_PS

#end